//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { WebStyleType } from '@/pages/Home/hooks/useHome';
import {UI_REST_LOGIN, UI_REST_KEEPALIVE, UI_REST_RSAKEY} from '../api/api';
import $http from './http-service';
import CustomizeService from '@/services/customize/customize.service';
import Color from '@/components/Customize/color';
import { DefaultColorConfig } from '@/components/Customize/customize.model';

const CustomizeConfig = new CustomizeService();
const colorConfig = JSON.parse(JSON.stringify(DefaultColorConfig));

// 获取Login接口信息
export function getLoginInfo(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(UI_REST_LOGIN)
      .then(res => {
        resolve(res);
      })
      .catch(error => {
        reject(error);
      });
  });
}

// 获取定制化配置信息
export function getStyleConfig(): Promise<any> {
  return new Promise((resolve, reject) => {
    const url = `/style_config.json?t=${Date.now()}`;
    $http.get(url).then(
      (res: any) => {
        resolve(res.data);
      },
      error => {
        resolve(null);
      },
    );
  });
}

export function getStyleInfo(): Promise<any> {
  return new Promise((resolve, reject) => {
    const url = `/extern/custom/style_config.json?t=${Date.now()}`;
    $http.get(url).then(
      (res: any) => {
        resolve(res.data);
      },
      error => {
        // 定制工具开关
        if (localStorage.getItem('ptc2')) {
          const pageStyle = JSON.parse(localStorage.getItem('customizeStyle') || '{}')?.pageStyle;
          resolve({ pageStyle: pageStyle || WebStyleType.DEFAULT });
        } else {
          resolve({ pageStyle: WebStyleType.DEFAULT });
        }
      },
    );
  });
}

// 保持会话请求
export function keepAlive(mode: 'Activate' | 'Deactivate'): Promise<any> {
  return $http.post(UI_REST_KEEPALIVE, { Mode: mode });
}
let mixColor = colorConfig.themeMode === 'dark' ? '#000' : '#FFF';
const colorList = [
  {
    text: '浪漫蓝紫',
    label: 'romantic',
    color1: '#3F51B5',
    color2: new Color(mixColor).mixin('#3F51B5', 0.32),
    color3: new Color(mixColor).mixin('#3F51B5', 0.72),
  },
  {
    text: '经典蓝',
    label: 'classic',
    color1: '#004EB5',
    color2: new Color(mixColor).mixin('#004EB5', 0.32),
    color3: new Color(mixColor).mixin('#004EB5', 0.72),
  },
  {
    text: '科技蓝',
    label: 'technology',
    color1: '#0077FF',
    color2: new Color(mixColor).mixin('#0077FF', 0.32),
    color3: new Color(mixColor).mixin('#0077FF', 0.72),
  },
];
const styleList = {
  standard: 'technology',
  ibma: 'classic',
  simple: 'technology',
  beautiful: 'romantic',
};
export function changeColor(val: string): void {
  let color1 = '';
  let color2 = '';
  let color3 = '';

  colorList.forEach(item => {
    if (item.label === styleList[val]) {
      color1 = item.color1;
      color2 = item.color2.origin;
      color3 = item.color3.origin;
    }
  });

  if (color1 !== '' && color2 !== '' && color3 !== '') {
    CustomizeConfig.setVar('--o-color-primary', color1);
    CustomizeConfig.setVar('--o-color-primary-secondary', color2);
    CustomizeConfig.setVar('--o-color-primary-fourth', color3);
    CustomizeConfig.setVar('--o-color-video-primary', `${color1}B3`);
    const color = new Color(color1);
    CustomizeConfig.setVar('--o-color-customize-shadow', `${color.mixin('#000', 0.52).value}66`);
  }
}

// 获取公钥接口
export function getEncryptKey(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
        .get(UI_REST_RSAKEY)
        .then(res => {
          resolve(res);
        })
        .catch(error => {
          reject(error);
        });
  });
}
