//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { IStyleConfig } from '@/services/customize/styleConfig.datatype';
import { StyleConfig } from '@/services/customize/styleConfig.model';
import { defineStore } from 'pinia';

const useThemeStore = defineStore('theme', {
  state: () => {
    return new StyleConfig().getStyleConfig;
  },
  getters: {},
  actions: {
    setThemeState(payload: { type: string; value: any }) {
      this[payload.type] = payload.value;
    },
    initThemeState(data: IStyleConfig): void {
      this.brandElement = { ...this.brandElement, ...data.brandElement };
      this.loginPage = { ...this.loginPage, ...data.loginPage };
      this.colorConfig = { ...this.colorConfig, ...data.colorConfig };
      this.layoutConfig = { ...this.layoutConfig, ...data.layoutConfig };
      this.textStyleConfig = { ...this.textStyleConfig, ...data.textStyleConfig };
      this.compStyleConfig = { ...this.compStyleConfig, ...data.compStyleConfig };
    },
  },
});

export default useThemeStore;
