//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { MaxLength } from '@/model/base-enum';
import { defineStore } from 'pinia';

const DEFAULT_USER_INFO = {
  uid: 0,
  un: '',
  uip: '',
  utime: '',
  ur: [],
  to: '',
  rn: '',
  lip: '',
  ltime: '',
  isValidVideoUser: null,
  sn: '',
  locale: '',
  pName: '',
  vid: '',
  smsName: '',
  pSN: '',
  armspt: null,
  fanspt: null,
  fdmspt: null,
  ibmaspt: null,
  ibmarun: null,
  tcespt: null,
  kvmspt: null,
  cpuspt: null,
  licensespt: null,
  powprespt: null,
  usbspt: null,
  spspt: null,
  partityspt: null,
  nopwd: null,
  platform: null,
  tpcmspt: null,
  sbootspt: null,
  obsspt: null,
  privil: [],
  twofac: null,
  isLogin: null,
  isExited: null,
  customizedId: null,
  multihost: null,
  computeDomain: null,
  sensorLocation: null,
  loginType: 0,
  navStyle: '',
  customeCertFlag: true,
  pml: MaxLength.min,
  unitspt: null,
  powerState: 'Off',
  multiPowerState: [],
  assetChange: null,
  powerSupplySupported: null,
  powerConverterSupported: null,
  powerSourceSwitchSupported: null,
  dynamicEnergySavingSupported: null,
  syslog: {
    ProtocolSupported: {
      TLS: true,
      TCP: true,
      UDP: true,
      RELP: false,
    },
    LogTypeSupported: {
      IntrusionDetectionLog: false,
      OperationLog: true,
      SecurityLog: true,
      EventLog: true,
      DiagnosticLog: false,
      BmcComLog: true,
      SysComLog: true,
      ChipLog: true,
    },
  },
  customerType: '',
};

function createStore() {
  const loct = localStorage.getItem('loct');
  const loctJson = loct ? JSON.parse(loct) : null;
  return Object.assign({}, DEFAULT_USER_INFO, loctJson);
}

const useLoctStore = defineStore('loct', {
  state: () => {
    return {
      ...createStore(),
    };
  },
  getters: {},
  actions: {
    setLoctState(payload: { type: string; value: any }) {
      this[payload.type] = payload.value;
    },
    resetLoctState(): void {
      const excludeKeys = ['locale', 'navStyle'];
      Object.keys(DEFAULT_USER_INFO).forEach(key => {
        if (!excludeKeys.includes(key)) {
          this[key] = DEFAULT_USER_INFO[key];
        }
      });
    },
  },
});

export default useLoctStore;

