//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { UI_REST_BIOS, UI_REST_CPU, UI_REST_ENERGY_SAVING } from '@/api/api';
import $http from '@/utils/http-service';
import { reqPath } from '@/api/reqPath';

export function getBiosConfig() {
  return new Promise((resolve, reject) => {
    $http.get(UI_REST_BIOS).then(
      res => {
        resolve(res.data);
      },
      error => {
        reject(error);
      },
    );
  });
}

export function saveBiosBoot(params: any) {
  return new Promise((resolve, reject) => {
    $http.patch(UI_REST_BIOS, params).then(
      res => {
        resolve(res.data);
      },
      error => {
        reject(error);
      },
    );
  });
}

export function getCPUData() {
  return new Promise((resolve, reject) => {
    $http.get(UI_REST_CPU).then(
      res => {
        resolve(res.data);
      },
      error => {
        reject(error);
      },
    );
  });
}

export function saveCPUState(params: any) {
  return new Promise((resolve, reject) => {
    $http.patch(UI_REST_CPU, params).then(
      res => {
        resolve(res.data);
      },
      error => {
        reject(error);
      },
    );
  });
}

export function getBiosSetting(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http.get('/UI/Rest/System/Bios/Settings').then(
      res => {
        resolve(res.data.Attributes);
      },
      error => {
        reject(error);
      },
    );
  });
}

export function discardAllPending(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http.post('/UI/Rest/System/Bios/RevokeSettings', {}).then(
      res => {
        resolve(res.data);
      },
      error => {
        reject(error);
      },
    );
  });
}

export function importBiosWebConfig(params: any): Promise<any> {
  return new Promise((resolve, reject) => {
    $http.patch('/UI/Rest/System/Bios/Settings', params).then(
      res => {
        resolve(res.data);
      },
      error => {
        reject(error);
      },
    );
  });
}

export function resetFirmware(params: any): Promise<any> {
  return $http.post(reqPath.ibmc.resetFirmware, params);
}

export function exportBiosConfig(): Promise<any> {
  return $http.post('/UI/Rest/System/Bios/ExportFirmware', {});
}

export function getTask(url: string): Promise<any> {
  return $http.get(url);
}