//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { getStoreData } from '@/utils/composition';

const iBMCRelations = {
  login: 'bmc_help_0005.html',
  home: 'bmc_help_0006.html',
  product: 'bmc_help_0056.html',
  processor: 'bmc_help_0057.html',
  memory: 'bmc_help_0058.html',
  net: 'bmc_help_0059.html',
  sensor: 'bmc_help_0060.html',
  others: 'bmc_help_0061.html',
  monitor: 'bmc_help_0009.html',
  storage: 'bmc_help_0010.html',
  info: 'bmc_help_0011.html',
  capping: 'bmc_help_0011.html',
  energy: 'bmc_help_0011.html',
  control: 'bmc_help_0011.html',
  psumode: 'bmc_help_0011.html',
  'multi-control': 'bmc_help_0011.html',
  'energy-saving': 'bmc_help_0011.html',
  'fans-info': 'bmc_help_0012.html',
  'fans-sensor': 'bmc_help_0012.html',
  bios: 'bmc_help_0013.html',
  export: 'bmc_help_0013.html',
  cpu: 'bmc_help_0013.html',
  partity: 'bmc_help_0014.html',
  alarm: 'bmc_help_0016.html',
  syslog: 'bmc_help_0017.html',
  syslogdb: 'bmc_help_0017.html',
  email: 'bmc_help_0017.html',
  trap: 'bmc_help_0017.html',
  fdm: 'bmc_help_0018.html',
  video: 'bmc_help_0019.html',
  diagnostics: 'bmc_help_0020.html',
  operation: 'bmc_help_0021.html',
  run: 'bmc_help_0021.html',
  security: 'bmc_help_0021.html',
  'work-records': 'bmc_help_0022.html',
  'local-users': 'bmc_help_0024.html',
  ldap: 'bmc_help_0025.html',
  kerberos: 'bmc_help_0026.html',
  root: 'bmc_help_0027.html',
  client: 'bmc_help_0027.html',
  'online-users': 'bmc_help_0028.html',
  enhance: 'bmc_help_0029.html',
  rule: 'bmc_help_0029.html',
  permission: 'bmc_help_0029.html',
  notice: 'bmc_help_0029.html',
  port: 'bmc_help_0031.html',
  web: 'bmc_help_0032.html',
  kvm: 'bmc_help_0033.html',
  vmm: 'bmc_help_0034.html',
  vnc: 'bmc_help_0035.html',
  snmp: 'bmc_help_0036.html',
  network: 'bmc_help_0038.html',
  ntp: 'bmc_help_0039.html',
  upgrade: 'bmc_help_0040.html',
  'config-update': 'bmc_help_0041.html',
  language: 'bmc_help_0042.html',
  license: 'bmc_help_0043.html',
  ibma: 'bmc_help_0065.html',
  sp: 'bmc_help_0068.html',
  usb: 'bmc_help_0067.html',
  'ca-certificate-list': 'bmc_help_0072.html',
  'ssl-certificate': 'bmc_help_0073.html',
  'auto-certificate-update': 'bmc_help_0074.html',
  tpcm: 'bmc_help_0075.html',
  units: 'bmc_help_0069.html',
  'asset-retire': 'bmc_help_0078.html',
  'discrete-sensors': 'bmc_help_0079.html',
  'asset-inventory': 'bmc_help_0081.html',
  'asset-change': 'bmc_help_0080.html',
  setting: 'bmc_help_0013.html',
  converter: 'bmc_help_0011.html',
  'supply-chain-config': 'bmc_help_0082.html',
  'sp-task': 'bmc_help_0068.html',
  'sp-manage': 'bmc_help_0068.html',
  'fru-info': 'bmc_help_0076.html',
  'telemetry-data': 'bmc_help_0083.html',
};

export default class HelpRelations {
  public static helpRelation(route: string) {
    const productType = getStoreData('glob', 'productType');
    const target = productType === 'IBMC' ? iBMCRelations : iBMCRelations;
    const router = route.split('?')[0];
    for (const key in target) {
      if (router === key) {
        return target[key];
      }
    }
    return undefined;
  }
}
