//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { UI_RESET_GENERIC, UI_RESET_LOGINOUT } from '@/api/api';
import { reqPath } from '@/api/reqPath';
import { IGeneric } from '@/model/base-interface';
import { AxiosResponse } from 'axios';
import $http from '@/utils/http-service';
import { urlReplace } from '@/utils/utils';
import { getStoreData, loading, setStoreData } from '@/utils/composition';
import { computed } from 'vue';

const multihost = computed(() => getStoreData('loct', 'multihost'));

// 退出会话
export function deleteSession(sid: string) {
  const url = urlReplace(UI_RESET_LOGINOUT, { sid });
  return $http.delete(url);
}

// 查询 GenericInfo 请求
export function getGenericInfo(): Promise<IGeneric> {
  return new Promise((resolve, reject) => {
    $http.get(UI_RESET_GENERIC).then((res: AxiosResponse) => {
      const result: IGeneric = Object.create(null);
      const data = res.data as any;
      result.armSupport = data.ArmSupported;
      result.copyRight = data.Copyright;
      result.currentTime = data.CurrentTime;
      sessionStorage.setItem('DateTime', data.CurrentTime);
      result.customizedId = data.CustomizedId;
      result.fanSupport = data.FanSupported;
      result.fdmSupport = data.FDMSupported;
      result.healthSummary = {
        critical: data.HealthSummary.NumberOfCriticalAlarm,
        major: data.HealthSummary.NumberOfMajorAlarm,
        minor: data.HealthSummary.NumberOfMinorAlarm,
      };
      result.ibmaRunning = data.SmsSupported && data.iBMARunningStatus === 'Running';
      result.ibmaSupport = data.SmsSupported;
      result.licenseSupport = data.LicSerSupported;
      result.partitySupport = data.FusionPartSupported;
      result.powerState = data.PowerState;
      result.smsSupport = data.SmsSupport;
      result.spSupport = data.SPSupported;
      result.storageConfigReady = data.StorageConfigReady;
      result.uidState = data.IndicatorLEDState;
      result.usbSupport = data.USBSupported;
      result.tceSupport = data.TCESupported;
      result.tpcmSupport = data.TPCMSupported;
      result.secureBootVerificationEnabled = data.SecureBootVerificationEnabled;
      result.observabilitySupported = data.ObservabilitySupported;
      result.customeCertFlag = data.CustomeCertFlag;
      result.powerPredictSupported = data.PowerPredictSupported; 
      result.multihostSupported = data.MultihostSupported; 
      result.kvmSupported = data.KVMSupported; 
      result.vmmSupported = data.VMMSupported; 
      result.vncSupported = data.VNCSupported; 
      result.snmpSupported = data.SnmpSupported; 
      result.rmcpSupported = data.IPMILANSupported; 
      result.computeSupported = data.GlobalDomainSupported;
      result.sensorSupported = data.SensorLocationSupported;
      result.assetChangeEnabled = data.AssetChangeEnabled;
      result.powerSupplySupported = data.PowerSupplySupported;
      result.powerConverterSupported = data.PowerConverterSupported; 
      result.dynamicEnergySavingSupported = data.DynamicEnergySavingSupported;
      result.langSupported = data.LanguageSetSupported;
      result.syslog = data.Syslog;
      resolve(result);
    });
  });
}

// 电源上下电
export function setPowerState(param: { type: string }): Promise<any> {
  let obj = {
    OperateType: param?.type || '',
  } as any;
  if (param?.type.indexOf('_') > -1) {
    obj.OperateType = param.type.split('_')[0];
    obj.FruID = Number(param.type.split('_')[1]);
  } else {
    obj.FruID = 0;
  }
  let mul = {
    OperateType: param.type,
  };
  let params = !multihost.value ? obj : mul;
  return new Promise((resolve, reject) => {
    $http.post(!multihost.value ? reqPath.ibmc.getPowerControl : reqPath.ibmc.getMultiPowerControl, params).then(
      res => {
        resolve(param.type);
      },
      error => {
        reject(error);
      },
    );
  });
}

// UID状态
export function setUIDState(param: { IndicatorLEDState: string }): Promise<any> {
  return new Promise((resolve, reject) => {
    $http.patch(UI_RESET_GENERIC, param).then(
      () => {
        resolve(param.IndicatorLEDState);
      },
      error => {
        reject(error);
      },
    );
  });
}
