//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export const LAYOUT_US = {
  name: 'US Standard',
  keys: [
    [
      [
        {
          key: 'Escape',
          showKey: 'Esc',
          location: 0,
          stickiness: false,
        },
        {
          key: 'Escape',
          showKey: 'Esc',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'F1',
          showKey: 'F1',
          location: 0,
          stickiness: false,
        },
        {
          key: 'F1',
          showKey: 'F1',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'F2',
          showKey: 'F2',
          location: 0,
          stickiness: false,
        },
        {
          key: 'F2',
          showKey: 'F2',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'F3',
          showKey: 'F3',
          location: 0,
          stickiness: false,
        },
        {
          key: 'F3',
          showKey: 'F3',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'F4',
          showKey: 'F4',
          location: 0,
          stickiness: false,
        },
        {
          key: 'F4',
          showKey: 'F4',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'F5',
          showKey: 'F5',
          location: 0,
          stickiness: false,
        },
        {
          key: 'F5',
          showKey: 'F5',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'F6',
          showKey: 'F6',
          location: 0,
          stickiness: false,
        },
        {
          key: 'F6',
          showKey: 'F6',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'F7',
          showKey: 'F7',
          location: 0,
          stickiness: false,
        },
        {
          key: 'F7',
          showKey: 'F7',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'F8',
          showKey: 'F8',
          location: 0,
          stickiness: false,
        },
        {
          key: 'F8',
          showKey: 'F8',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'F9',
          showKey: 'F9',
          location: 0,
          stickiness: false,
        },
        {
          key: 'F9',
          showKey: 'F9',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'F10',
          showKey: 'F10',
          location: 0,
          stickiness: false,
        },
        {
          key: 'F10',
          showKey: 'F10',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'F11',
          showKey: 'F11',
          location: 0,
          stickiness: false,
        },
        {
          key: 'F11',
          showKey: 'F11',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'F12',
          showKey: 'F12',
          location: 0,
          stickiness: false,
        },
        {
          key: 'F12',
          showKey: 'F12',
          location: 0,
          stickiness: false,
        },
      ],
    ],
    [
      [
        {
          key: '`',
          showKey: '`',
          location: 0,
          stickiness: false,
        },
        {
          key: '~',
          showKey: '~',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '1',
          showKey: '1',
          location: 0,
          stickiness: false,
        },
        {
          key: '!',
          showKey: '!',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '2',
          showKey: '2',
          location: 0,
          stickiness: false,
        },
        {
          key: '@',
          showKey: '@',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '3',
          showKey: '3',
          location: 0,
          stickiness: false,
        },
        {
          key: '#',
          showKey: '#',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '4',
          showKey: '4',
          location: 0,
          stickiness: false,
        },
        {
          key: '$',
          showKey: '$',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '5',
          showKey: '5',
          location: 0,
          stickiness: false,
        },
        {
          key: '%',
          showKey: '%',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '6',
          showKey: '6',
          location: 0,
          stickiness: false,
        },
        {
          key: '^',
          showKey: '^',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '7',
          showKey: '7',
          location: 0,
          stickiness: false,
        },
        {
          key: '&',
          showKey: '&',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '8',
          showKey: '8',
          location: 0,
          stickiness: false,
        },
        {
          key: '*',
          showKey: '*',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '9',
          showKey: '9',
          location: 0,
          stickiness: false,
        },
        {
          key: '(',
          showKey: '(',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '0',
          showKey: '0',
          location: 0,
          stickiness: false,
        },
        {
          key: ')',
          showKey: ')',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '-',
          showKey: '-',
          location: 0,
          stickiness: false,
        },
        {
          key: '_',
          showKey: '_',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '=',
          showKey: '=',
          location: 0,
          stickiness: false,
        },
        {
          key: '+',
          showKey: '+',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: 'Backspace',
          showKey: 'Bksp',
          location: 0,
          stickiness: false,
        },
        {
          key: 'Backspace',
          showKey: 'Bksp',
          location: 0,
          stickiness: false,
        },
      ],
    ],
    [
      [
        {
          key: 'Tab',
          showKey: 'Tab',
          location: 0,
          stickiness: false,
        },
        {
          key: 'Tab',
          showKey: 'Tab',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'q',
          showKey: 'q',
          location: 0,
          stickiness: false,
        },
        {
          key: 'Q',
          showKey: 'Q',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'w',
          showKey: 'w',
          location: 0,
          stickiness: false,
        },
        {
          key: 'W',
          showKey: 'W',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'e',
          showKey: 'e',
          location: 0,
          stickiness: false,
        },
        {
          key: 'E',
          showKey: 'E',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'r',
          showKey: 'r',
          location: 0,
          stickiness: false,
        },
        {
          key: 'R',
          showKey: 'R',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 't',
          showKey: 't',
          location: 0,
          stickiness: false,
        },
        {
          key: 'T',
          showKey: 'T',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'y',
          showKey: 'y',
          location: 0,
          stickiness: false,
        },
        {
          key: 'Y',
          showKey: 'Y',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'u',
          showKey: 'u',
          location: 0,
          stickiness: false,
        },
        {
          key: 'U',
          showKey: 'U',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'i',
          showKey: 'i',
          location: 0,
          stickiness: false,
        },
        {
          key: 'I',
          showKey: 'I',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'o',
          showKey: 'o',
          location: 0,
          stickiness: false,
        },
        {
          key: 'O',
          showKey: 'O',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'p',
          showKey: 'p',
          location: 0,
          stickiness: false,
        },
        {
          key: 'P',
          showKey: 'P',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: '[',
          showKey: '[',
          location: 0,
          stickiness: false,
        },
        {
          key: '{',
          showKey: '{',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: ']',
          showKey: ']',
          location: 0,
          stickiness: false,
        },
        {
          key: '}',
          showKey: '}',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '\\',
          showKey: '\\',
          location: 0,
          stickiness: false,
        },
        {
          key: '|',
          showKey: '|',
          location: 0,
          stickiness: true,
        },
      ],
    ],
    [
      [
        {
          key: 'CapsLock',
          showKey: 'Caps',
          location: 0,
          stickiness: false,
        },
        {
          key: 'CapsLock',
          showKey: 'Caps',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'a',
          showKey: 'a',
          location: 0,
          stickiness: false,
        },
        {
          key: 'A',
          showKey: 'A',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 's',
          showKey: 's',
          location: 0,
          stickiness: false,
        },
        {
          key: 'S',
          showKey: 'S',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'd',
          showKey: 'd',
          location: 0,
          stickiness: false,
        },
        {
          key: 'D',
          showKey: 'D',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'f',
          showKey: 'f',
          location: 0,
          stickiness: false,
        },
        {
          key: 'F',
          showKey: 'F',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'g',
          showKey: 'g',
          location: 0,
          stickiness: false,
        },
        {
          key: 'G',
          showKey: 'G',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'h',
          showKey: 'h',
          location: 0,
          stickiness: false,
        },
        {
          key: 'H',
          showKey: 'H',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'j',
          showKey: 'j',
          location: 0,
          stickiness: false,
        },
        {
          key: 'J',
          showKey: 'J',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'k',
          showKey: 'k',
          location: 0,
          stickiness: false,
        },
        {
          key: 'K',
          showKey: 'K',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'l',
          showKey: 'l',
          location: 0,
          stickiness: false,
        },
        {
          key: 'L',
          showKey: 'L',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: ';',
          showKey: ';',
          location: 0,
          stickiness: false,
        },
        {
          key: ':',
          showKey: ':',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '\'',
          showKey: '\'',
          location: 0,
          stickiness: false,
        },
        {
          key: '"',
          showKey: '"',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: 'Enter',
          showKey: 'Enter',
          location: 0,
          stickiness: false,
        },
        {
          key: 'Enter',
          showKey: 'Enter',
          location: 0,
          stickiness: false,
        },
      ],
    ],
    [
      [
        {
          key: 'Shift',
          showKey: 'Shift',
          location: 1,
          stickiness: false,
        },
        {
          key: 'Shift',
          showKey: 'Shift',
          location: 1,
          stickiness: false,
        },
      ],
      [
        {
          key: 'z',
          showKey: 'z',
          location: 0,
          stickiness: false,
        },
        {
          key: 'Z',
          showKey: 'Z',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'x',
          showKey: 'x',
          location: 0,
          stickiness: false,
        },
        {
          key: 'X',
          showKey: 'X',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'c',
          showKey: 'c',
          location: 0,
          stickiness: false,
        },
        {
          key: 'C',
          showKey: 'C',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'v',
          showKey: 'v',
          location: 0,
          stickiness: false,
        },
        {
          key: 'V',
          showKey: 'V',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'b',
          showKey: 'b',
          location: 0,
          stickiness: false,
        },
        {
          key: 'B',
          showKey: 'B',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'n',
          showKey: 'n',
          location: 0,
          stickiness: false,
        },
        {
          key: 'N',
          showKey: 'N',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'm',
          showKey: 'm',
          location: 0,
          stickiness: false,
        },
        {
          key: 'M',
          showKey: 'M',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: ',',
          showKey: ',',
          location: 0,
          stickiness: false,
        },
        {
          key: '<',
          showKey: '<',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '.',
          showKey: '.',
          location: 0,
          stickiness: false,
        },
        {
          key: '>',
          showKey: '>',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: '/',
          showKey: '/',
          location: 0,
          stickiness: false,
        },
        {
          key: '?',
          showKey: '?',
          location: 0,
          stickiness: true,
        },
      ],
      [
        {
          key: 'Shift',
          showKey: 'Shift',
          location: 2,
          stickiness: false,
        },
        {
          key: 'Shift',
          showKey: 'Shift',
          location: 2,
          stickiness: false,
        },
      ],
    ],
    [
      [
        {
          key: 'Control',
          showKey: 'Ctrl',
          location: 1,
          stickiness: false,
        },
        {
          key: 'Control',
          showKey: 'Ctrl',
          location: 1,
          stickiness: false,
        },
      ],
      [
        {
          key: 'Meta',
          showKey: 'Win',
          location: 1,
          stickiness: false,
        },
        {
          key: 'Meta',
          showKey: 'Win',
          location: 1,
          stickiness: false,
        },
      ],
      [
        {
          key: 'Alt',
          showKey: 'Alt',
          location: 1,
          stickiness: false,
        },
        {
          key: 'Alt',
          showKey: 'Alt',
          location: 1,
          stickiness: false,
        },
      ],
      [
        {
          key: ' ',
          showKey: 'Space',
          location: 0,
          stickiness: false,
        },
        {
          key: ' ',
          showKey: 'Space',
          location: 0,
          stickiness: false,
        },
      ],
      [
        {
          key: 'Alt',
          showKey: 'Alt',
          location: 2,
          stickiness: false,
        },
        {
          key: 'Alt',
          showKey: 'Alt',
          location: 2,
          stickiness: false,
        },
      ],
      [
        {
          key: 'Control',
          showKey: 'Ctrl',
          location: 2,
          stickiness: false,
        },
        {
          key: 'Ctrl',
          showKey: 'Ctrl',
          location: 2,
          stickiness: false,
        },
      ],
    ],
  ],
  keyCode: [
    [
      [0x1b, 0x1b],
      [0x70, 0x70],
      [0x71, 0x71],
      [0x72, 0x72],
      [0x73, 0x73],
      [0x74, 0x74],
      [0x75, 0x75],
      [0x76, 0x76],
      [0x77, 0x77],
      [0x78, 0x78],
      [0x79, 0x79],
      [0x7a, 0x7a],
      [0x7b, 0x7b],
    ],
    [
      [0xc0, 0xc0],
      [0x31, 0x31],
      [0x32, 0x32],
      [0x33, 0x33],
      [0x34, 0x34],
      [0x35, 0x35],
      [0x36, 0x36],
      [0x37, 0x37],
      [0x38, 0x38],
      [0x39, 0x39],
      [0x30, 0x30],
      [0xbd, 0xbd],
      [0xbb, 0xbb],
      [0x08, 0x08],
    ],
    [
      [0x09, 0x09],
      [0x51, 0x51],
      [0x57, 0x57],
      [0x45, 0x45],
      [0x52, 0x52],
      [0x54, 0x54],
      [0x59, 0x59],
      [0x55, 0x55],
      [0x49, 0x49],
      [0x4f, 0x4f],
      [0x50, 0x50],
      [0xdb, 0xdb],
      [0xdd, 0xdd],
      [0xdc, 0xdc],
    ],
    [
      [0x14, 0x14],
      [0x41, 0x41],
      [0x41, 0x53],
      [0x44, 0x44],
      [0x46, 0x46],
      [0x47, 0x47],
      [0x48, 0x48],
      [0x4a, 0x4a],
      [0x4b, 0x4b],
      [0x4c, 0x4c],
      [0xba, 0xba],
      [0xde, 0xde],
      [0x0d, 0x0d],
    ],
    [
      [0x10, 0x10],
      [0x5a, 0x5a],
      [0x58, 0x58],
      [0x43, 0x43],
      [0x56, 0x56],
      [0x42, 0x42],
      [0x4e, 0x4e],
      [0x4d, 0x4d],
      [0xbc, 0xbc],
      [0xbe, 0xbe],
      [0xbf, 0xbf],
      [0x10, 0x10],
    ],
    [
      [0x11, 0x11],
      [0x5b, 0x5b],
      [0x12, 0x12],
      [0x20, 0x20],
      [0x12, 0x12],
      [0x11, 0x11],
    ],
  ],
  code: [
    [
      ['Escape', 'Escape'],
      ['F1', 'F1'],
      ['F2', 'F2'],
      ['F3', 'F3'],
      ['F4', 'F4'],
      ['F5', 'F5'],
      ['F6', 'F6'],
      ['F7', 'F7'],
      ['F8', 'F8'],
      ['F9', 'F9'],
      ['F10', 'F10'],
      ['F11', 'F11'],
      ['F12', 'F12'],
    ],
    [
      ['Backquote', 'Backquote'],
      ['Digit1', 'Digit1'],
      ['Digit2', 'Digit2'],
      ['Digit3', 'Digit3'],
      ['Digit4', 'Digit4'],
      ['Digit5', 'Digit5'],
      ['Digit6', 'Digit6'],
      ['Digit7', 'Digit7'],
      ['Digit8', 'Digit8'],
      ['Digit9', 'Digit9'],
      ['Digit0', 'Digit0'],
      ['Minus', 'Minus'],
      ['Equal', 'Equal'],
      ['Backspace', 'Backspace'],
    ],
    [
      ['Tab', 'Tab'],
      ['KeyQ', 'KeyQ'],
      ['KeyW', 'KeyW'],
      ['KeyE', 'KeyE'],
      ['KeyR', 'KeyR'],
      ['KeyT', 'KeyT'],
      ['KeyY', 'KeyY'],
      ['KeyU', 'KeyU'],
      ['KeyI', 'KeyI'],
      ['KeyO', 'KeyO'],
      ['KeyP', 'KeyP'],
      ['BracketLeft', 'BracketLeft'],
      ['BracketRight', 'BracketRight'],
      ['Backslash', 'Backslash'],
    ],
    [
      ['CapsLock', 'CapsLock'],
      ['KeyA', 'KeyA'],
      ['KeyS', 'KeyS'],
      ['KeyD', 'KeyD'],
      ['KeyF', 'KeyF'],
      ['KeyG', 'KeyG'],
      ['KeyH', 'KeyH'],
      ['KeyJ', 'KeyJ'],
      ['KeyK', 'KeyK'],
      ['KeyL', 'KeyL'],
      ['Semicolon', 'Semicolon'],
      ['Quote', 'Quote'],
      ['Enter', 'Enter'],
    ],
    [
      ['ShiftLeft', 'ShiftLeft'],
      ['KeyZ', 'KeyZ'],
      ['KeyX', 'KeyX'],
      ['KeyC', 'KeyC'],
      ['KeyV', 'KeyV'],
      ['KeyB', 'KeyB'],
      ['KeyN', 'KeyN'],
      ['KeyM', 'KeyM'],
      ['Comma', 'Comma'],
      ['Period', 'Period'],
      ['Slash', 'Slash'],
      ['ShiftRight', 'ShiftRight'],
    ],
    [
      ['ControlLeft', 'ControlLeft'],
      ['MetaLeft', 'MetaLeft'],
      ['AltLeft', 'AltLeft'],
      ['Space', 'Space'],
      ['AltRight', 'AltRight'],
      ['ControlRight', 'ControlRight'],
    ],
  ],
  smallKeys: [
    [[{
      key: 'Home',
      showKey: 'Home',
      location: 0,
    }], [{
      key: 'ScrollLock',
      showKey: 'Scroll',
      location: 0,
    }], [{
      key: 'Insert',
      showKey: 'Ins',
      location: 0,
    }]],
    [[{
      key: 'End',
      showKey: 'End',
      location: 0,
    }], [{
      key: 'ArrowUp',
      showKey: 'top',
      location: 0,
    }], [{
      key: 'Delete',
      showKey: 'Del',
      location: 0,
    }]],
    [[{
      key: 'ArrowLeft',
      showKey: 'left',
      location: 0,
    }], [{
      key: 'ArrowDown',
      showKey: 'down',
      location: 0,
    }], [{
      key: 'ArrowRight',
      showKey: 'right',
      location: 0,
    }]],
    [[{
      key: '+',
      showKey: '+',
      location: 3,
    }], [{
      key: '-',
      showKey: '-',
      location: 3,
    }], [{
      key: '*',
      showKey: '*',
      location: 3,
    }]],
    [[{
      key: 'PageUp',
      showKey: 'Pg Up',
      location: 0,
    }], [{
      key: '/',
      showKey: '/',
      location: 3,
    }], [{
      key: 'Prnt Scrn',
      showKey: 'Prnt Scrn',
      location: 0,
    }]],
    [[{
      key: 'PageDown',
      showKey: 'Pg Dn',
      location: 0,
    }], [{
      key: 'Enter',
      showKey: 'Enter',
      location: 0,
    }]],
  ],
  smallKeyCode: [
    [[0x24], [0x91], [0x2d]],
    [[0x23], [0x26], [0x2e]],
    [[0x25], [0x28], [0x27]],
    [[0xbb], [0xbd], [0x6a]],
    [[0x21], [0x6f], [0x2c]],
    [[0x22], [0x6c]],
  ],
  smallCode: [
    [['Home'], ['ScrollLock'], ['Insert']],
    [['End'], ['ArrowUp'], ['Delete']],
    [['ArrowLeft'], ['ArrowDown'], ['ArrowRight']],
    [['NumpadAdd'], ['NumpadSubtract'], ['NumpadMultiply']],
    [['PageUp'], ['NumpadDivide'], ['PrintScreen']],
    [['PageDown'], ['NumpadEnter']],
  ],
};