//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { base64 } from './base64';
export class Display {
  public _canvas: any;
  public _ctx;
  public _ctxW;
  public _ctxH;
  public _vpX = 0;
  public _vpY = 0;
  public _vpW = 1024;
  public _vpH = 768;
  public _scale = 1;
  public _seq = 0;
  public _packetSize = 0;
  public _imageW = 1024;
  public _imageH = 768;
  public _imageBuffer = null as any;
  public _imageCache = new Array(192);
  public _head = null;
  public _frameType = 0;
  public _quantization = 0;
  public _fullscreen = 0;
  public _blockW = 64;
  public _blockH = 64;
  public _client;

  public HEAD_SYN_SOI_APPO = [
    0xff, 0xd8, 0xff, 0xe0, 0x00, 0x10, 0x4a, 0x46, 0x49, 0x46, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
    0x00
  ];

  public HEAD_SYN_SOF_420 = [
    0xff, 0xc0, 0x00, 0x11, 0x08, 0x00, 0x40, 0x00, 0x40, 0x03, 0x01, 0x22, 0x00, 0x02, 0x11, 0x01, 0x03, 0x11, 0x02
  ];

  public HEAD_SYN_SOF_444 = [
    0xff, 0xc0, 0x00, 0x11, 0x08, 0x00, 0x40, 0x00, 0x40, 0x03, 0x01, 0x11, 0x00, 0x02, 0x11, 0x01, 0x03, 0x11, 0x02
  ];

  public HEAD_SYN_SOF_SOS = [
    0xff, 0xc4, 0x00, 0x1f, 0x00, 0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,

    0xff, 0xc4, 0x00, 0x1f, 0x01, 0x00, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,

    0xff, 0xc4, 0x00, 0xb5, 0x10, 0x00, 0x02, 0x01, 0x03, 0x03, 0x02, 0x04, 0x03, 0x05, 0x05, 0x04, 0x04, 0x00, 0x00,
    0x01, 0x7d, 0x01, 0x02, 0x03, 0x00, 0x04, 0x11, 0x05, 0x12, 0x21, 0x31, 0x41, 0x06, 0x13, 0x51, 0x61, 0x07, 0x22,
    0x71, 0x14, 0x32, 0x81, 0x91, 0xa1, 0x08, 0x23, 0x42, 0xb1, 0xc1, 0x15, 0x52, 0xd1, 0xf0, 0x24, 0x33, 0x62, 0x72,
    0x82, 0x09, 0x0a, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x34, 0x35, 0x36, 0x37, 0x38,
    0x39, 0x3a, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x63,
    0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x83, 0x84, 0x85, 0x86,
    0x87, 0x88, 0x89, 0x8a, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
    0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8,
    0xc9, 0xca, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8,
    0xe9, 0xea, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa,

    0xff, 0xc4, 0x00, 0xb5, 0x11, 0x00, 0x02, 0x01, 0x02, 0x04, 0x04, 0x03, 0x04, 0x07, 0x05, 0x04, 0x04, 0x00, 0x01,
    0x02, 0x77, 0x00, 0x01, 0x02, 0x03, 0x11, 0x04, 0x05, 0x21, 0x31, 0x06, 0x12, 0x41, 0x51, 0x07, 0x61, 0x71, 0x13,
    0x22, 0x32, 0x81, 0x08, 0x14, 0x42, 0x91, 0xa1, 0xb1, 0xc1, 0x09, 0x23, 0x33, 0x52, 0xf0, 0x15, 0x62, 0x72, 0xd1,
    0x0a, 0x16, 0x24, 0x34, 0xe1, 0x25, 0xf1, 0x17, 0x18, 0x19, 0x1a, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x35, 0x36, 0x37,
    0x38, 0x39, 0x3a, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a,
    0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x82, 0x83, 0x84,
    0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5,
    0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6,
    0xc7, 0xc8, 0xc9, 0xca, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
    0xe8, 0xe9, 0xea, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa,

    0xff, 0xdd, 0x00, 0x04, 0x00, 0x64,

    0xff, 0xda, 0x00, 0x0c, 0x03, 0x01, 0x00, 0x02, 0x11, 0x03, 0x11, 0x00, 0x3f, 0x00
  ];

  public TAIL = [0xff, 0xd9];

  public HEAD_SYN_DQT_Y_10 = [
    0xff, 0xdb, 0x00, 0x43, 0x00, 0x50, 0x37, 0x3c, 0x46, 0x3c, 0x32, 0x50, 0x46, 0x41, 0x46, 0x5a, 0x55, 0x50, 0x5f,
    0x78, 0xc8, 0x82, 0x78, 0x6e, 0x6e, 0x78, 0xf5, 0xaf, 0xb9, 0x91, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
  ];

  public HEAD_SYN_DQT_U_10 = [
    0xff, 0xdb, 0x00, 0x43, 0x01, 0x55, 0x5a, 0x5a, 0x78, 0x69, 0x78, 0xeb, 0x82, 0x82, 0xeb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
  ];

  public HEAD_SYN_DQT_V_10 = [
    0xff, 0xdb, 0x00, 0x43, 0x02, 0x55, 0x5a, 0x5a, 0x78, 0x69, 0x78, 0xeb, 0x82, 0x82, 0xeb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
  ];

  public HEAD_SYN_DQT_Y_20 = [
    0xff, 0xdb, 0x00, 0x43, 0x00, 0x28, 0x1c, 0x1e, 0x23, 0x1e, 0x19, 0x28, 0x23, 0x21, 0x23, 0x2d, 0x2b, 0x28, 0x30,
    0x3c, 0x64, 0x41, 0x3c, 0x37, 0x37, 0x3c, 0x7b, 0x58, 0x5d, 0x49, 0x64, 0x91, 0x80, 0x99, 0x96, 0x8f, 0x80, 0x8c,
    0x8a, 0xa0, 0xb4, 0xe6, 0xc3, 0xa0, 0xaa, 0xda, 0xad, 0x8a, 0x8c, 0xc8, 0xff, 0xcb, 0xda, 0xee, 0xf5, 0xff, 0xff,
    0xff, 0x9b, 0xc1, 0xff, 0xff, 0xff, 0xfa, 0xff, 0xe6, 0xfd, 0xff, 0xf8
  ];

  public HEAD_SYN_DQT_U_20 = [
    0xff, 0xdb, 0x00, 0x43, 0x01, 0x2b, 0x2d, 0x2d, 0x3c, 0x35, 0x3c, 0x76, 0x41, 0x41, 0x76, 0xf8, 0xa5, 0x8c, 0xa5,
    0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
    0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
    0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8
  ];

  public HEAD_SYN_DQT_V_20 = [
    0xff, 0xdb, 0x00, 0x43, 0x02, 0x2b, 0x2d, 0x2d, 0x3c, 0x35, 0x3c, 0x76, 0x41, 0x41, 0x76, 0xf8, 0xa5, 0x8c, 0xa5,
    0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
    0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
    0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8
  ];

  public HEAD_SYN_DQT_Y_30 = [
    0xff, 0xdb, 0x00, 0x43, 0x00, 0x1b, 0x12, 0x14, 0x17, 0x14, 0x11, 0x1b, 0x17, 0x16, 0x17, 0x1e, 0x1c, 0x1b, 0x20,
    0x28, 0x42, 0x2b, 0x28, 0x25, 0x25, 0x28, 0x51, 0x3a, 0x3d, 0x30, 0x42, 0x60, 0x55, 0x65, 0x64, 0x5f, 0x55, 0x5d,
    0x5b, 0x6a, 0x78, 0x99, 0x81, 0x6a, 0x71, 0x90, 0x73, 0x5b, 0x5d, 0x85, 0xb5, 0x86, 0x90, 0x9e, 0xa3, 0xab, 0xad,
    0xab, 0x67, 0x80, 0xbc, 0xc9, 0xba, 0xa6, 0xc7, 0x99, 0xa8, 0xab, 0xa4
  ];

  public HEAD_SYN_DQT_U_30 = [
    0xff, 0xdb, 0x00, 0x43, 0x01, 0x1c, 0x1e, 0x1e, 0x28, 0x23, 0x28, 0x4e, 0x2b, 0x2b, 0x4e, 0xa4, 0x6e, 0x5d, 0x6e,
    0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4,
    0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4,
    0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4
  ];

  public HEAD_SYN_DQT_V_30 = [
    0xff, 0xdb, 0x00, 0x43, 0x02, 0x1c, 0x1e, 0x1e, 0x28, 0x23, 0x28, 0x4e, 0x2b, 0x2b, 0x4e, 0xa4, 0x6e, 0x5d, 0x6e,
    0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4,
    0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4,
    0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4
  ];

  public HEAD_SYN_DQT_Y_40 = [
    0xff, 0xdb, 0x00, 0x43, 0x00, 0x14, 0x0e, 0x0f, 0x12, 0x0f, 0x0d, 0x14, 0x12, 0x10, 0x12, 0x17, 0x15, 0x14, 0x18,
    0x1e, 0x32, 0x21, 0x1e, 0x1c, 0x1c, 0x1e, 0x3d, 0x2c, 0x2e, 0x24, 0x32, 0x49, 0x40, 0x4c, 0x4b, 0x47, 0x40, 0x46,
    0x45, 0x50, 0x5a, 0x73, 0x62, 0x50, 0x55, 0x6d, 0x56, 0x45, 0x46, 0x64, 0x88, 0x65, 0x6d, 0x77, 0x7b, 0x81, 0x82,
    0x81, 0x4e, 0x60, 0x8d, 0x97, 0x8c, 0x7d, 0x96, 0x73, 0x7e, 0x81, 0x7c
  ];

  public HEAD_SYN_DQT_U_40 = [
    0xff, 0xdb, 0x00, 0x43, 0x01, 0x15, 0x17, 0x17, 0x1e, 0x1a, 0x1e, 0x3b, 0x21, 0x21, 0x3b, 0x7c, 0x53, 0x46, 0x53,
    0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
    0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
    0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c
  ];

  public HEAD_SYN_DQT_V_40 = [
    0xff, 0xdb, 0x00, 0x43, 0x02, 0x15, 0x17, 0x17, 0x1e, 0x1a, 0x1e, 0x3b, 0x21, 0x21, 0x3b, 0x7c, 0x53, 0x46, 0x53,
    0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
    0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
    0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c
  ];

  public HEAD_SYN_DQT_Y_50 = [
    0xff, 0xdb, 0x00, 0x43, 0x00, 0x10, 0x0b, 0x0c, 0x0e, 0x0c, 0x0a, 0x10, 0x0e, 0x0d, 0x0e, 0x12, 0x11, 0x10, 0x13,
    0x18, 0x28, 0x1a, 0x18, 0x16, 0x16, 0x18, 0x31, 0x23, 0x25, 0x1d, 0x28, 0x3a, 0x33, 0x3d, 0x3c, 0x39, 0x33, 0x38,
    0x37, 0x40, 0x48, 0x5c, 0x4e, 0x40, 0x44, 0x57, 0x45, 0x37, 0x38, 0x50, 0x6d, 0x51, 0x57, 0x5f, 0x62, 0x67, 0x68,
    0x67, 0x3e, 0x4d, 0x71, 0x79, 0x70, 0x64, 0x78, 0x5c, 0x65, 0x67, 0x63
  ];

  public HEAD_SYN_DQT_U_50 = [
    0xff, 0xdb, 0x00, 0x43, 0x01, 0x11, 0x12, 0x12, 0x18, 0x15, 0x18, 0x2f, 0x1a, 0x1a, 0x2f, 0x63, 0x42, 0x38, 0x42,
    0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,
    0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,
    0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63
  ];

  public HEAD_SYN_DQT_V_50 = [
    0xff, 0xdb, 0x00, 0x43, 0x02, 0x11, 0x12, 0x12, 0x18, 0x15, 0x18, 0x2f, 0x1a, 0x1a, 0x2f, 0x63, 0x42, 0x38, 0x42,
    0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,
    0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,
    0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63
  ];

  public HEAD_SYN_DQT_Y_60 = [
    0xff, 0xdb, 0x00, 0x43, 0x00, 0x0d, 0x09, 0x08, 0x0d, 0x13, 0x20, 0x29, 0x31, 0x0a, 0x0a, 0x0b, 0x0f, 0x15, 0x2e,
    0x30, 0x2c, 0x0b, 0x0a, 0x0d, 0x13, 0x20, 0x2e, 0x37, 0x2d, 0x0b, 0x0e, 0x12, 0x17, 0x29, 0x46, 0x40, 0x32, 0x0e,
    0x12, 0x1e, 0x2d, 0x36, 0x57, 0x52, 0x3e, 0x13, 0x1c, 0x2c, 0x33, 0x41, 0x53, 0x5a, 0x4a, 0x27, 0x33, 0x3e, 0x46,
    0x52, 0x61, 0x60, 0x51, 0x3a, 0x4a, 0x4c, 0x4e, 0x5a, 0x50, 0x52, 0x4f
  ];

  public HEAD_SYN_DQT_U_60 = [
    0xff, 0xdb, 0x00, 0x43, 0x01, 0x0e, 0x0e, 0x0e, 0x13, 0x11, 0x13, 0x26, 0x15, 0x15, 0x26, 0x4f, 0x35, 0x2d, 0x35,
    0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
    0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
    0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f
  ];

  public HEAD_SYN_DQT_V_60 = [
    0xff, 0xdb, 0x00, 0x43, 0x02, 0x0e, 0x0e, 0x0e, 0x13, 0x11, 0x13, 0x26, 0x15, 0x15, 0x26, 0x4f, 0x35, 0x2d, 0x35,
    0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
    0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
    0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f
  ];

  public HEAD_SYN_DQT_Y_70 = [
    0xff, 0xdb, 0x00, 0x43, 0x00, 0x0a, 0x07, 0x07, 0x08, 0x07, 0x06, 0x0a, 0x08, 0x08, 0x08, 0x0b, 0x0a, 0x0a, 0x0b,
    0x0e, 0x18, 0x10, 0x0e, 0x0d, 0x0d, 0x0e, 0x1d, 0x15, 0x16, 0x11, 0x18, 0x23, 0x1f, 0x25, 0x24, 0x22, 0x1f, 0x22,
    0x21, 0x26, 0x2b, 0x37, 0x2f, 0x26, 0x29, 0x34, 0x29, 0x21, 0x22, 0x30, 0x41, 0x31, 0x34, 0x39, 0x3b, 0x3e, 0x3e,
    0x3e, 0x25, 0x2e, 0x44, 0x49, 0x43, 0x3c, 0x48, 0x37, 0x3d, 0x3e, 0x3b
  ];

  public HEAD_SYN_DQT_U_70 = [
    0xff, 0xdb, 0x00, 0x43, 0x01, 0x0a, 0x0b, 0x0b, 0x0e, 0x0d, 0x0e, 0x1c, 0x10, 0x10, 0x1c, 0x3b, 0x28, 0x22, 0x28,
    0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
    0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
    0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b
  ];

  public HEAD_SYN_DQT_V_70 = [
    0xff, 0xdb, 0x00, 0x43, 0x02, 0x0a, 0x0b, 0x0b, 0x0e, 0x0d, 0x0e, 0x1c, 0x10, 0x10, 0x1c, 0x3b, 0x28, 0x22, 0x28,
    0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
    0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
    0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b
  ];

  public HEAD_SYN_DQT_Y_80 = [
    0xff, 0xdb, 0x00, 0x43, 0x00, 0x06, 0x04, 0x05, 0x06, 0x05, 0x04, 0x06, 0x06, 0x05, 0x06, 0x07, 0x07, 0x06, 0x08,
    0x0a, 0x10, 0x0a, 0x0a, 0x09, 0x09, 0x0a, 0x14, 0x0e, 0x0f, 0x0c, 0x10, 0x17, 0x14, 0x18, 0x18, 0x17, 0x14, 0x16,
    0x16, 0x1a, 0x1d, 0x25, 0x1f, 0x1a, 0x1b, 0x23, 0x1c, 0x16, 0x16, 0x20, 0x2c, 0x20, 0x23, 0x26, 0x27, 0x29, 0x2a,
    0x29, 0x19, 0x1f, 0x2d, 0x30, 0x2d, 0x28, 0x30, 0x25, 0x28, 0x29, 0x28
  ];

  public HEAD_SYN_DQT_U_80 = [
    0xff, 0xdb, 0x00, 0x43, 0x01, 0x07, 0x07, 0x07, 0x0a, 0x08, 0x0a, 0x13, 0x0a, 0x0a, 0x13, 0x28, 0x1a, 0x16, 0x1a,
    0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
    0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
    0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28
  ];

  public HEAD_SYN_DQT_V_80 = [
    0xff, 0xdb, 0x00, 0x43, 0x02, 0x07, 0x07, 0x07, 0x0a, 0x08, 0x0a, 0x13, 0x0a, 0x0a, 0x13, 0x28, 0x1a, 0x16, 0x1a,
    0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
    0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
    0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28
  ];

  public HEAD_SYN_DQT_Y_90 = [
    0xff, 0xdb, 0x00, 0x43, 0x00, 0x03, 0x02, 0x02, 0x03, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x04, 0x03, 0x03, 0x04,
    0x05, 0x08, 0x05, 0x05, 0x04, 0x04, 0x05, 0x0a, 0x07, 0x07, 0x06, 0x08, 0x0c, 0x0a, 0x0c, 0x0c, 0x0b, 0x0a, 0x0b,
    0x0b, 0x0d, 0x0e, 0x12, 0x10, 0x0d, 0x0e, 0x11, 0x0e, 0x0b, 0x0b, 0x10, 0x16, 0x10, 0x11, 0x13, 0x14, 0x15, 0x15,
    0x15, 0x0c, 0x0f, 0x17, 0x18, 0x16, 0x14, 0x18, 0x12, 0x14, 0x15, 0x14
  ];

  public HEAD_SYN_DQT_U_90 = [
    0xff, 0xdb, 0x00, 0x43, 0x01, 0x03, 0x04, 0x04, 0x05, 0x04, 0x05, 0x09, 0x05, 0x05, 0x09, 0x14, 0x0d, 0x0b, 0x0d,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14
  ];

  public HEAD_SYN_DQT_V_90 = [
    0xff, 0xdb, 0x00, 0x43, 0x02, 0x03, 0x04, 0x04, 0x05, 0x04, 0x05, 0x09, 0x05, 0x05, 0x09, 0x14, 0x0d, 0x0b, 0x0d,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14
  ];

  public HEAD_SYN_DQT_Y_100 = [
    0xff, 0xdb, 0x00, 0x43, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01
  ];

  public HEAD_SYN_DQT_U_100 = [
    0xff, 0xdb, 0x00, 0x43, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01
  ];

  public HEAD_SYN_DQT_V_100 = [
    0xff, 0xdb, 0x00, 0x43, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01
  ];

  public HEAD_SYN_DQT_Y_S = [
    this.HEAD_SYN_DQT_Y_10,
    this.HEAD_SYN_DQT_Y_20,
    this.HEAD_SYN_DQT_Y_30,
    this.HEAD_SYN_DQT_Y_40,
    this.HEAD_SYN_DQT_Y_50,
    this.HEAD_SYN_DQT_Y_60,
    this.HEAD_SYN_DQT_Y_70,
    this.HEAD_SYN_DQT_Y_80,
    this.HEAD_SYN_DQT_Y_90,
    this.HEAD_SYN_DQT_Y_100
  ];
  
  public HEAD_SYN_DQT_U_S = [
    this.HEAD_SYN_DQT_U_10,
    this.HEAD_SYN_DQT_U_20,
    this.HEAD_SYN_DQT_U_30,
    this.HEAD_SYN_DQT_U_40,
    this.HEAD_SYN_DQT_U_50,
    this.HEAD_SYN_DQT_U_60,
    this.HEAD_SYN_DQT_U_70,
    this.HEAD_SYN_DQT_U_80,
    this.HEAD_SYN_DQT_U_90,
    this.HEAD_SYN_DQT_U_100
  ];

  public HEAD_SYN_DQT_V_S = [
    this.HEAD_SYN_DQT_V_10,
    this.HEAD_SYN_DQT_V_20,
    this.HEAD_SYN_DQT_V_30,
    this.HEAD_SYN_DQT_V_40,
    this.HEAD_SYN_DQT_V_50,
    this.HEAD_SYN_DQT_V_60,
    this.HEAD_SYN_DQT_V_70,
    this.HEAD_SYN_DQT_V_80,
    this.HEAD_SYN_DQT_V_90,
    this.HEAD_SYN_DQT_V_100
  ];

  constructor(client: any) {
    this._client = client;
    this._canvas = document.getElementById('image_panel');
    this._ctx = this._canvas?.getContext('2d');
    this._ctxW = this._canvas.width;
    this._ctxH = this._canvas.height;
    this._FullscreenListen();
  }

  _CanvasChange(w: any, h: any, redraw: number) {
    let tempW = 0;
    let tempH = 0;
    this._scale = w / this._imageW > h / this._imageH ? h / this._imageH : w / this._imageW;
    this._scale = parseInt(String(this._scale / 0.125), 10) * 0.125;
    tempW = this._scale * this._imageW;
    tempH = this._scale * this._imageH;
    const oldCanvas = document.createElement('canvas');
    const oldScale = tempW / this._vpW > tempH / this._vpH ? tempH / this._vpH : tempW / this._vpW;
    if (redraw) {
      const imageData = this._ctx.getImageData(this._vpX, this._vpY, this._vpW, this._vpH);
      oldCanvas.width = this._vpW;
      oldCanvas.height = this._vpH;
      oldCanvas.getContext('2d')?.putImageData(imageData, 0, 0);
    }

    this._ctxW = w;
    this._ctxH = h;
    this._canvas.width = w;
    this._canvas.height = h;
    const imagePanel: HTMLElement = document.getElementById('image_panel') as HTMLElement;
    imagePanel.style.width = w;
    imagePanel.style.height = h;
    this._vpW = this._scale * this._imageW;
    this._vpH = this._scale * this._imageH;
    this._vpX = (this._ctxW - this._vpW) / 2;
    this._vpY = (this._ctxH - this._vpH) / 2;
    if (redraw) {
      this._ctx.scale(oldScale, oldScale);
      this._ctx.drawImage(oldCanvas, this._vpX / oldScale, this._vpY / oldScale);
      this._ctx.scale(1 / oldScale, 1 / oldScale);
    }
    this._ctx.scale(this._scale, this._scale);
  }

  _UpdateHead(quantization: any) {
    if (this._head == null || this._quantization !== quantization) {
      let headSynData: any = [];
      headSynData = headSynData.concat(this.HEAD_SYN_SOI_APPO);
      headSynData = headSynData.concat(this.HEAD_SYN_DQT_Y_S[quantization - 1]);
      headSynData = headSynData.concat(this.HEAD_SYN_DQT_U_S[quantization - 1]);
      headSynData = headSynData.concat(this.HEAD_SYN_DQT_V_S[quantization - 1]);
      headSynData = headSynData.concat(this.HEAD_SYN_SOF_444);
      headSynData = headSynData.concat(this.HEAD_SYN_SOF_SOS);
      this._head = headSynData;
      this._quantization = quantization;
    }
    return this._head;
  }

  _DrawBlock(x: number, y: number, block: any) {
    let img = null as any;
    if (typeof block !== 'undefined') {
      const self = this;
      img = new Image();
      const xPos = (this._vpX / this._scale) + x;
      const yPos = (this._vpY / this._scale) + y;
      img.onload = () => {
        self._ctx.drawImage(img, xPos, yPos);
        if (x + self._blockW - self._imageW > 0) {
          const fillX = (self._vpX / self._scale) + self._imageW;
          const fillW = x + self._blockW - self._imageW;
          self._ctx.fillRect(fillX, yPos, fillW, self._blockH);
        }
        if (y + self._blockH - self._imageH > 0) {
          const fillY = (self._vpY / self._scale) + self._imageH;
          const fillH = y + self._blockH - self._imageH;
          self._ctx.fillRect(xPos, fillY, self._blockW, fillH);
        }
      };

      img.src = `data:image/jpeg;base64,${base64.encode(block)}`;
    } else {
      img = null;
    }
  }

  _Decode(iamge: any) {
    let syclen = 0;
    let zipType = 0;
    let len = 0;
    let count = 0;
    const widthCount = parseInt(String((this._imageW + this._blockW - 1) / this._blockW), 10);
    const heightCount = parseInt(String((this._imageH + this._blockH - 1) / this._blockH), 10);

    for (let i = 0; i < iamge.length; i += syclen) {
      zipType = (iamge[i] & 0xff & 0xe0) >> 5;
      switch (zipType) {
        case 2:
        case 3: {
          len = ((iamge[i + 1] & 0xff) << 8) + (iamge[i + 2] & 0xff);
          const synHeadData = this._head;
          let kvmImage = (synHeadData as any).concat(iamge.slice(i + 3, i + 3 + len));
          kvmImage = kvmImage.concat(this.TAIL);
          const x = this._blockW * parseInt(String(count % widthCount), 10);
          const y = this._blockH * parseInt(String(count / widthCount), 10);
          this._DrawBlock(x, y, kvmImage);
          this._imageCache[count] = kvmImage;
          count = count + 1;
          syclen = 1 + 2 + len;
          break;
        }

        case 4:
          syclen = 1;
          count = count + 1;
          break;

        case 5: {
          const y2 = this._blockH * parseInt(String(count / widthCount), 10);
          const x2 = this._blockW * parseInt(String(count % widthCount), 10);
          this._imageCache[count] = this._imageCache[count - widthCount];
          this._DrawBlock(x2, y2, this._imageCache[count]);
          syclen = 1;
          count = count + 1;
          break;
        }
         
        case 6: {
          const y3 = this._blockH * parseInt(String(count / widthCount), 10);
          const x3 = this._blockW * parseInt(String(count % widthCount), 10);
          this._imageCache[count] = this._imageCache[count - 1];
          this._DrawBlock(x3, y3, this._imageCache[count]);
          syclen = 1;
          count = count + 1;
          break;
        }

        default:
          syclen = 1;
          break;
      }
    }
  }

  drawImage(dataE: any) {    
    let width = dataE.imageWidth;
    let height = dataE.imageHight;
    // 处理量化等级
    this._UpdateHead(dataE.imageQuantizationLevel);
    this._frameType = dataE.imageFrameType;
    // 数据包的总大小
    this._packetSize = dataE.imageLength;
    this._quantization = dataE.imageQuantizationLevel;
    // 处理全屏
    if (this._imageW !== width || this._imageH !== height) {
      const widthNum = parseInt(String((width + this._blockW - 1) / this._blockW), 10);
      const heightNum = parseInt(String((height + this._blockH - 1) / this._blockH), 10);
      this._imageW = width;
      this._imageH = height;
      this._imageCache = new Array(widthNum * heightNum);
      if (this._fullscreen) {
        let ratio = window.outerWidth / window.innerWidth;
        this._CanvasChange(window.screen.width / ratio, window.screen.height / ratio, 0);
      } else {
        this._CanvasChange(1024, 768, 0);
      }
    }

    // 解码并绘制图像
    this._imageBuffer = [...dataE.imageBodyData];
    this._Decode(this._imageBuffer);
    // 录屏
    if (this._client._toolbar._recorder !== null) {
      const fullAction = new Uint8Array(this._imageBuffer.length + 1);
      fullAction.set(this._imageBuffer, 1);
      this._client._toolbar._recorder.writeFrame(
        this._imageW,
        this._imageH,
        this._quantization,
        this._frameType,
        fullAction
      );
    }
    this._client._statusbar.updateFrame(1);
  }

  switchCursor(status: number) {
    status ? this._canvas.classList.add('cursor-hide') : this._canvas.classList.remove('cursor-hide');
  }

  supportFullscreen() {
    const docElm = document.getElementById('divFullscreen');
    const el = docElm as HTMLElement & {
      mozRequestFullScreen: () => Promise<void>;
      webkitRequestFullscreen: () => Promise<void>;
      msRequestFullscreen: () => Promise<void>;
    };
    const isFullscreen =
      document.fullscreenElement ||
      (document as any).msFullscreenElement ||
      (document as any).mozFullScreenElement ||
      (document as any).webkitFullscreenElement ||
      false;
    return [isFullscreen, el];
  }

  toggleFullScreen() {
    const el = this.supportFullscreen()[1];
    if (!this.supportFullscreen()[0]) {
      if (el.requestFullscreen) {
        el.requestFullscreen();
      } else if (el.mozRequestFullScreen) {
        el.mozRequestFullScreen();
      } else if (el.webkitRequestFullscreen) {
        el.webkitRequestFullscreen();
      } else if (el.msRequestFullscreen) {
        el.msRequestFullscreen();
      }
    } else {
      const exitMethod =
        document.exitFullscreen ||
        (document as any).mozCancelFullScreen ||
        (document as any).webkitExitFullscreen ||
        (document as any).msExitFullscreen;
      if (exitMethod) {
        exitMethod.call(document);
      }
    }
  }

  _FullscreenListen() {
    const fullAction = () => {
      if (this._fullscreen === 0) {
        this._fullscreen = 1;
        document.getElementById('divFullscreen')?.style.setProperty('width', '100%', 'important');
        let ratio = window.outerWidth / window.innerWidth;
        this._CanvasChange(window.screen.width / ratio, window.screen.height / ratio, 1);
        this._client._toolbar.fullscreenAction(1);
      } else {
        this._fullscreen = 0;
        document.getElementById('divFullscreen')?.style.setProperty('width', '1024px');
        this._CanvasChange(1024, 768, 1);
        this._client._toolbar.fullscreenAction(0);
      }
    };

    document.onfullscreenchange = fullAction;
    (document as any).onwebkitfullscreenchange = fullAction;
    (document as any).onmozfullscreenchange = fullAction;
    (document as any).onmsfullscreenchange = fullAction;
  }
}
