//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { VolumeMembersModel } from './volume-members.model';
export class VolumeCreateModel {
  private constructor() { }

  set setButtonState(buttonState: boolean) {
    this.buttonState = buttonState;
  }

  get getButtonState() {
    return this.buttonState;
  }

  private static instance: VolumeCreateModel;

  private buttonState: boolean = true;

  public static getInstance(): VolumeCreateModel {
    if (!VolumeCreateModel.instance) {
      VolumeCreateModel.instance = new VolumeCreateModel();
    }
    return VolumeCreateModel.instance;
  }

  public destroy(): void {
    VolumeMembersModel.destroy();
  }

  public checkBtnState() {
    const memberState = VolumeMembersModel.getInstance().checkSave();

    if (memberState) {
      this.buttonState = true;
    } else {
      this.buttonState = false;
    }
  }
}
