//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { traduction } from '@/utils/language';
import { ILabelValue, IFields, IIpv4, IIpv6 } from '@/model/System/net-interface';
import { notLinkList } from './NetPages/components/OpenRowDataFunctions';

// 非null，非undefined，非''判断   preStr:前置字符串  后置单位:backUnit
export function haveDataJudgments(e?: string | number | null, preStr?: string, backUnit?: string): any {
  return (e !== null && e !== undefined && e !== '' && e !== 'null' && e !== 'undefined'
    ? addPreStrAndBackUnit(e, preStr, backUnit)
    : '--');
}

// 加前置字符串和后置单位
function addPreStrAndBackUnit(e: string | number, preStr?: string, backUnit?: string) {
  let str = e;
  if (preStr) {
    str = preStr + str;
  }
  if (backUnit) {
    str += backUnit;
  }
  return str;
}

// 判断速度协商阶段
export function dealRate(e?: string | null): any {
  let str = '--';
  if (e === 'WaitSignal') {
    str = traduction('WAIT_SIGNAL_LABEL');
  } else if (e === 'Negotiating') {
    str = traduction('NEGOTIATING_LABEL');
  } else if (e === 'NegotiationCompleted') {
    str = traduction('NEGOTIATION_COMPLETED_LABEL');
  }
  return str;
}

// 数据判断转换
function conversion(e: any, list: Array<string>) {
  return (notLinkList.includes(e) || e === 'NoLink' || e === 'Disabled' || !e) ? list[1] : list[0];
}

// 加工键值对数据
export function initShowData(data: any, fieldsList: Array<IFields>, aimList: Array<ILabelValue>) {
  aimList.splice(0);
  fieldsList.forEach((item: IFields) => {
    let value = data[item.key];
    if (value !== null && value !== undefined && value !== '') {
      // 有数据判断转换
      if (item.judgments) {
        value = conversion(value, item.judgments);
      }

      // 有后置单位
      if (item.unit) {
        value += item.unit;
      }

      // 数据加工函数
      if (item.fun) {
        value = item.fun(value);
      }

      aimList.push({
        label: item.lable,
        value: value,
      });
    }
  });
}

// 判断介质类型
export function initMediaType(e?: string | null): any {
  return e === 'Electrical' ? 'NET_ELETRICITY' : 'NET_LIGHTEST';
}

// 判断网口类型
export function initInterfaceType(e?: string | null | number): any {
  return e === 'Physical' ? 'NET_PHYSICAL_PORT' : 'NET_VITURL_PORT';
}

// 加工ipv4/ipv6|掩码/前缀|网关
function initIpv4Ipv6(e: Array<IIpv4 | IIpv6>, keyList: Array<string>): string {
  let str = '';
  e.forEach((item: IIpv4) => {
    keyList.forEach((key: string) => {
      if (item[key] || item[key] === 0 || item[key] === '0') {
        str += (`${item[key]}|`);
      } else {
        str += '--|';
      }
    });
    // 去除最后一根竖线且加一个空格
    str = `${str.substring(0, str.length - 1)} `;
  });
  // 去除最后一个空格
  return str.substring(0, str.length - 1);
}

// 加工ipv4|掩码|网关
export function initIpv4MaskGateway(e: Array<IIpv4>) {
  const keyList = ['Address', 'Mask', 'Gateway'];
  return initIpv4Ipv6(e, keyList);
}

// 加工IPv6|前缀|网关
export function initIpv6PrefixGateway(e: Array<IIpv6>) {
  const keyList = ['Address', 'Prefix', 'Gateway'];
  return initIpv4Ipv6(e, keyList);
}

export function _dealVlans(vlans: any): string {
  if (vlans && vlans.length > 0) {
      let str = '';
      vlans.forEach((vlan: any) => {
          str += getVlan(vlan);
      });
      return str;
  }
  return '';
}

function getVlan(vlan: any): string {
  const portData = {} as any;
  portData.vlanId = vlan.ID !== null ? vlan.ID : '--';
  if (vlan.Enable !== null) {
    portData.vlanEnable = vlan.Enable ? 'Enable' : 'Disable';
  } else {
    portData.vlanEnable = '--';
  }
  
  portData.prEnable = vlan.Priority !== null ? (vlan.Priority) : '--';
  return `${portData.vlanId}|${portData.vlanEnable}|${portData.prEnable}`;
}

export function _getPort(portInfo: any): any {
  let portData = {} as any;
  portData.CardName = _dealUsefulString(portInfo?.NetCardName);
  portData.Name = _dealUsefulString(portInfo?.Name);
  portData.Port = `Port${portInfo?.PhysicalPortNumber}`;
  portData.MAC = _dealUsefulString(portInfo?.MAC);
  portData.LinkStatus = _dealUsefulString(portInfo?.LinkStatus);
  return portData;
}

export function _dealUsefulString(info: any): any {
  let results = '--';
  if (info !== null && info !== undefined && info !== '') {
      results = info;
  }
  return results;
}