//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import $http from '@/utils/http-service';
import { reqPath } from '@/api/reqPath';
import { escapeHeader } from '@/utils/utils';
import { UI_REST_FIRMWAREINVENTORY, UI_REST_REAUTH } from '@/api/api';
import { reauthHandler } from '@/utils/sensitive';

const loct = localStorage.getItem('loct');
// 获取版本信息
export function getUpgradeInfo(): Promise<any> {
  return $http.get(reqPath.ibmc.getUpgrade);
}

// 获取升级文件列表
export function getFileList(): Promise<any> {
  return $http.get(reqPath.ibmc.SPUpdateFileList);
}

// 固件升级重启
export function resetFirmware(params: any): Promise<any> {
  return $http.post(reqPath.ibmc.resetFirmware, params);
}

// 切换iBMC镜像
export function rollBackFirmware(params: any): Promise<any> {
  return $http.post(reqPath.ibmc.rollBackFirmware, params);
}

// 固件升级进度查询
export function queryTaskProgress(url: string): Promise<any> {
  return $http.get(url);
}

// 上传固件升级文件
export function uploadUpgradeFile(formData: FormData) {
  return $http.post(UI_REST_FIRMWAREINVENTORY, formData);
}
// 上传文件二次密码校验
export function reauth(key: string): Promise<any> {
  const params = {
    ReauthKey: window.btoa(key),
  };
  return reauthHandler(params).post(UI_REST_REAUTH, params);
}

// 导入固件升级文件
export function importUpgradeFile(fileName: string, configSelected: string): Promise<any> {
  const data = { FilePath: `/tmp/web/${fileName}` };
  if (configSelected !== 'yes') {
    Object.assign(data, {
      RestoreFactorySettings: true,
    });
  }
  return $http.post(reqPath.ibmc.firmwareUpdate, data);
}

export function importParallelUpdate(fileName: string, _: any): Promise<any> {
  const data = { FilePath: `/tmp/web/${fileName}` };
  return $http.post(reqPath.ibmc.parallelUpdate, data);
}

export function queryParallelUpdateProgress(cancelSource: any): Promise<any> {
  return $http.get(reqPath.ibmc.queryTaskProgress, {}, { keepAlive: false }, cancelSource);
}

export function importFileByConfig(formData: FormData): Promise<any> {
  let header = {
    headers: {
      'X-CSRF-Token': escapeHeader(loct ? JSON.parse(loct).to : ''),
      From: 'WebUI',
      Accept: '*/*',
    },
  };
  return $http.post(reqPath.ibmc.firmwareUpdate, formData, header);
}
export function getPowerControl() {
  return $http.get(reqPath.ibmc.getPowerControl);
}
// 删除文件列表
export function delSPUpdateFileList() {
  return $http.post(reqPath.ibmc.DeleteSPUpdateFile, {});
}

// 带内上传
export function uploadFile(param: { formData: FormData }) {
  let header = {};
  header = {
    headers: {
      'X-CSRF-Token': escapeHeader(loct ? JSON.parse(loct).to : ''),
      From: 'WebUI',
      Accept: '*/*',
    },
  };
  return $http.post(reqPath.ibmc.SPFWUpdate, param.formData, header);
}

export function getActiveInfo(type: string[]): any {
  return $http.post(reqPath.ibmc.startActive, { ActivationActions: type });
}

export function getFirmwareList(): any {
  return $http.get(reqPath.ibmc.pendingFirmwareList);
}