//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { nextTick } from 'vue';

// 删除空对象
export function deleteNull(obj: any) {
  for (const key in obj) {
    if (Object.prototype.hasOwnProperty.call(obj, key) && JSON.stringify(obj[key]) === '{}') {
      delete obj[key];
    }
  }
  return obj;
}

export function addLabelId() {
  // 异步操作等待节点渲染后才能获取节点
  nextTick(() => {
    // tiny框架版本未给label添加id，为与master版本一致添加id
    const labelCheckbox = document.querySelectorAll('el-checkbox');
    const labelRadio = document.querySelectorAll('el-radio');
    labelCheckbox.forEach((item: any) => {
      item.setAttribute('id', `${item.getAttributeNode('for').value}_checkbox`);
    });
    labelRadio.forEach((item: any) => {
      item.setAttribute('id', `${item.getAttributeNode('for').value}_radio`);
    });
  });
}

// 对比前后是否发生修改
export function compareArray(origin: any, target: any) {
  if (
    Object.prototype.toString.call(origin) !== '[object Array]' ||
    Object.prototype.toString.call(target) !== '[object Array]'
  ) {
    return false;
  }

  if (origin.length === 0) {
    return false;
  }

  let flag = false;
  for (const key1 of origin) {
    for (const key2 of target) {
      if (key2.id === key1.id && key2.checked !== key1.checked) {
        flag = true;
        break;
      }
      if (flag) {
        break;
      }
    }
  }
  return flag;
}

function getPortNumber(type: string, networkConfigObj: any) {
  let portNumber = 1;
  if (type === 'Dedicated') {
    portNumber = Number(networkConfigObj.dedicatedInternetAc.value);
  } else if (type === 'LOM') {
    portNumber = Number(networkConfigObj.extendInternetAc.value);
  } else if (type === 'FlexIO') {
    portNumber = Number(networkConfigObj.extendInternetAc2.value);
  } else if (type === 'Aggregation') {
    portNumber = Number(networkConfigObj.onboardInternetAc.value);
  } else if (type === 'ExternalPCIe') {
    portNumber = Number(networkConfigObj.pcieInternetAc.value);
  } else if (type === 'OCP') {
    portNumber = Number(networkConfigObj.ocpInternetAc.value);
  } else if (type === 'OCP2') {
    portNumber = Number(networkConfigObj.ocpInternetAc2.value);
  }
  return portNumber;
}

function getPortData(data: any) {
  const list: any = [];
  for (const key of data) {
    list.push({
      PortNumber: Number(key.id),
      AdaptiveFlag: key.checked,
    });
  }
  return list;
}

function getAutomaticData(networkConfigObj: any) {
  return {
    // 专用网口
    dedicatedPort: getPortData(networkConfigObj.dedicatedInternetAc.checkList),
    // 汇聚网口
    aggregationPort: getPortData(networkConfigObj.onboardInternetAc.checkList),
    // 板载网口
    lomPort: getPortData(networkConfigObj.extendInternetAc.checkList),
    // 板载网口2
    flexIOPort: getPortData(networkConfigObj.extendInternetAc2.checkList),
    // PCIE扩展网口
    externalPCIePort: getPortData(networkConfigObj.pcieInternetAc.checkList),
    // OCP扩展网口
    ocpPort: getPortData(networkConfigObj.ocpInternetAc.checkList),
    // OCP2扩展网口
    ocpPort2: getPortData(networkConfigObj.ocpInternetAc2.checkList),
  };
}

// 加工请求数据
export function protocolEnabledEN(mode: any, networkPortType: any, networkConfigObj: any, multiSupported: any) {
  const queryParams = {
    NetworkPort: {
      ManagementNetworkPort: {},
      ManagementNetworkPorts: [],
      Members: {},
    },
  };
  if (mode.value === 'Fixed') {
    if (multiSupported) {
      queryParams.NetworkPort.ManagementNetworkPorts = networkPortType;
    } else {
      // 固定模式 则只能选择一种模式，那种模式被选中，则传哪个模式的参数
      const type = networkPortType.Type;
      const portNumber = getPortNumber(type, networkConfigObj);

      queryParams.NetworkPort.ManagementNetworkPort = {
        Type: type,
        PortNumber: portNumber,
      };
    }
    (queryParams.NetworkPort as any).Mode = mode.value;
  } else if (mode.value === 'Automatic') {
    const {
      dedicatedPort,
      aggregationPort,
      lomPort,
      flexIOPort,
      externalPCIePort,
      ocpPort,
      ocpPort2,
    } = getAutomaticData(networkConfigObj);
    (queryParams.NetworkPort.Members as any).Dedicated = dedicatedPort;
    (queryParams.NetworkPort.Members as any).Aggregation = aggregationPort;
    (queryParams.NetworkPort.Members as any).LOM = lomPort;
    (queryParams.NetworkPort.Members as any).FlexIO = flexIOPort;
    (queryParams.NetworkPort.Members as any).ExternalPCIe = externalPCIePort;
    (queryParams.NetworkPort.Members as any).OCP = ocpPort;
    (queryParams.NetworkPort.Members as any).OCP2 = ocpPort2;
    (queryParams.NetworkPort as any).Mode = mode.value;
    delete queryParams.NetworkPort.ManagementNetworkPorts;
  }
  deleteNull(queryParams.NetworkPort);
  return queryParams;
}
