//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import $http from '@/utils/http-service';
import { reqPath } from '@/api/reqPath';
import { reauthHandler } from '@/utils/sensitive';

const api = reqPath.maintance.asset;

// 资产报废
export function assetRetire(data: object): any {
  return reauthHandler(data).post(api.retire, data);
}

export function retireProcess(): any {
  return $http.get(api.retireProcess);
}

// 获取可信资产数据
export function getAssetData(): Promise<any> {
  return new Promise((resolve, reject) => {
    $http
      .get(api.getAssetChange)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}

export function refreshInfo(params: any): Promise<any> {
  return new Promise((resolve, reject) => {
    reauthHandler(params)
      .post(api.refreshChange, params)
      .then((res: any) => {
        resolve(res.data);
      })
      .catch((err: any) => {
        reject(err);
      });
  });
}


// 资产清单
export function getAssetInventory(): any {
  return $http.get(api.inventory);
}

export function getSupplyChainConfig(): any {
  return $http.get(api.supplyChainChange);
}

export function confirmSupplyChain(): any {
  return $http.post(api.supplyChainConfirm, {});
}
