//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import $http from '@/utils/http-service';
import { reqPath } from '@/api/reqPath';
import { UI_REST_GENERALDOWNLOAD } from '@/api/api';

const api = reqPath.maintance.alarm;

// 清空日志
export function clearData() {
  return $http.post(api.clearEvent, {});
}

// 配置查询下载日志
export function downloadLog() {
  return $http.post(api.downloadEvent, {});
}

// 下载传感器日志
export function downloadSensorLog(): Promise<any> {
  return $http.post(api.downloadSelEvent, {});
}

// 获取下载进度
export function getTaskStatus(url: string) {
  return $http.get(url);
}

// 当前日志
export function logServices(): Promise<any> {
  return $http.get(api.alarm);
}

// 系统日志
export function sysLogServices(data: object): Promise<any> {
  return $http.post(api.queryEvent, data, { ignoredErrorTip: true });
}

// 系统日志
export function sensorServices(data: object): Promise<any> {
  return $http.post(api.querySensorEvent, data, { ignoredErrorTip: true });
}


// 查询系统事件主体类型
export function getSubjectType() {
  return $http.get(api.eventObjectType);
}

// 下载系统事件
export function downLoadSystemEvents() {
  const data = {
    Path: '/tmp/sel.tar',
    TransferProtocol: 'HTTPS',
  };
  return $http.post(UI_REST_GENERALDOWNLOAD, data, { responseType: 'blob' });
}

export function downLoadSelEvents(): Promise<any> {
  const data = {
    Path: '/tmp/sensor_sel.tar',
    TransferProtocol: 'HTTPS',
  };
  return $http.post(UI_REST_GENERALDOWNLOAD, data, { responseType: 'blob' });
}

// 获取记录方式
export function getRecordType(): Promise<any> {
  return $http.get(api.recordType);
}

// 设置记录方式
export function setRecordType(param: any): Promise<any> {
  return $http.patch(api.recordType, param);
}

// 获取系统事件记录方式
export function getRecordTypeEvent(): Promise<any> {
  return $http.get(api.recordTypeEvent);
}

// 设置系统事件记录方式
export function setRecordTypeEvent(param: any): Promise<any> {
  return $http.patch(api.recordTypeEvent, param);
}