//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export const ipProps = {
  // 输入框的id
  idStr: {
    type: String,
    default: '',
    required: false,
  },
  // 输入框的类名
  classStr: {
    type: String,
    default: '',
    required: false,
  },
  // 输入框值
  value: {
    type: [String, Number],
    default: '',
    required: false,
  },
  // 校验规则
  rule: {
    type: Object,
    default: () => {
      return {};
    },
    required: false,
  },
  // 是否禁用
  disabled: {
    type: Boolean,
    default: false,
    required: false,
  },
  // 输入框样式
  inputStyle: {
    type: Object,
    default: () => {
      return {
        width: '280px',
      };
    },
    required: false,
  },
  // popover的相关设置
  popoverSetting: {
    type: Object,
    default: () => {
      return {
        // 是否有
        show: false,
        // popover的类型,是简单的字符串还是比较复杂的自定义内容（自定义的需要传组件）
        type: 'ordinary', // ordinary(简单的字符串)或者complex(复杂的自定义展示组件)
        // 自定义的popover展示组件配置
        popoverSlotSetting: {
          // 展示的组件
          component: '',
          // 传给组件的数据
          data: '',
        },
        // popover宽度
        width: 'auto',
        // popover的类名
        popperClass: 'no-wrap-popover',
        // 展示内容
        content: '',
        // 展示位置
        placement: 'right',
        // popover触发方式
        trigger: 'focus',
      };
    },
    required: false,
  },
};

// 输入框的props
export const inputProps = {
  ...ipProps,
  // 输入框的placeholder
  placeholder: {
    type: String,
    default: '',
    required: false,
  },
  // 输入框类型
  inputType: {
    type: String,
    default: 'text',
    required: false,
  },
  // 输入框最大长度
  maxLength: {
    type: Number,
    default: 255,
    required: false,
  },
  // 是否将其展示为错误样式输入框（红色边框）
  errorInput: {
    type: Boolean,
    default: false,
    required: false,
  },
};

// edtor编辑框的props
export const edtorProps: any = {
  ...ipProps,
  // 单位
  unit: {
    type: String,
    default: '',
    required: false,
  },
  // 输入框的placeholder
  placeholder: {
    type: String,
    default: '',
    required: false,
  },
  // 输入框类型
  inputType: {
    type: String,
    default: 'text',
    required: false,
  },
  // 输入框最大长度
  maxLength: {
    type: Number,
    default: 255,
    required: false,
  },
  // 是否可以清空
  clearable: {
    type: Boolean,
    default: false,
    required: false,
  },
  // 防止影响其他editor样式
  teleported: {
    type: Boolean,
    default: false,
    required: false,
  },
};

edtorProps.inputStyle = {
  type: Object,
  default: () => {
    return { width: '56px' };
  },
  required: false,
};
