//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { getRealColor, getThemeMode } from '@/utils/utils';

const heleathAndBeyondColorsLight = {
  heleathColor: '#0062DC',
  heleathShadowColor: 'rgba(0, 98, 220, 0.39)',
  beyondColor: '#E32020',
  beyondShadowColor: 'rgba(227,32,32,0.25)',
};
const heleathAndBeyondColorsDark = {
  heleathColor: '#0077FF',
  heleathShadowColor: 'rgba(0, 119, 255, 0.39)',
  beyondColor: '#E32020',
  beyondShadowColor: 'rgba(227,32,32,0.25)',
};

const pieCircleColorsLight = [getRealColor('--o-border-color-light'), '#f2f2f2', '#fff'];
const pieCircleColorsDark = ['#3e4450', '#1e2128', '#2a2e37'];

const lineColorsLight = [
  '#0062dc',
  '#3DB6FC',
  '#81BA06',
  '#3DCFD4',
  '#6D47F5',
  '#2DB47C',
  '#BD45E8',
  '#9EA8B9',
  '#FF5432',
  '#EC4F83',
  '#FF7D63',
  '#5328BF',
  '#279C6E',
  '#75A105',
  '#9ECBFF',
  '#EBBC00',
];

const lineColorsDark = [
  '#0077FF',
  '#37A4E3',
  '#73A409',
  '#30B7BB',
  '#613DE4',
  '#29A370',
  '#A843CD',
  '#4E5865',
  '#E05034',
  '#DA4576',
  '#CD362B',
  '#9073F7',
  '#60C594',
  '#A1D13C',
  '#66ADFF',
  '#EBBC00',
];

// 门限值的虚线的颜色 以及 文本颜色
export const visualMapLineColor = '#E32020';

// 安全程度 强、中、弱
export const securityColors = {
  strong: getRealColor('--o-color-success'),
  middle: getRealColor('--o-color-major'),
  weak: getRealColor('--o-color-danger'),
};

export const colors = {
  // 健康和超出门限值的颜色
  heleathAndBeyondColors: heleathAndBeyondColorsLight,
  // 饼状图的三个辅助环的颜色
  pieCircleColors: pieCircleColorsLight,
  // 条形图/柱状图的颜色
  lineColors: lineColorsLight,
};

// 根据主题设置颜色
export function setColors() {
  const type = getThemeMode();
  if (type !== 'light') {
    colors.heleathAndBeyondColors = heleathAndBeyondColorsDark;
    colors.pieCircleColors = pieCircleColorsDark;
    colors.lineColors = lineColorsDark;
  } else {
    colors.heleathAndBeyondColors = heleathAndBeyondColorsLight;
    colors.pieCircleColors = pieCircleColorsLight;
    colors.lineColors = lineColorsLight;
  }
  securityColors.strong = getRealColor('--o-color-success');
  securityColors.middle = getRealColor('--o-color-major');
  securityColors.weak = getRealColor('--o-color-danger');
}

