//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export interface IVersion {
  name: string;
  currentVersion: string;
  type: string;
}

export interface IFirmwareVersion {
  activeBMCVersion: string;
  backupBMCVersion: string;
  availableBMCVersion: string;
}

export interface IUpgradeVersion {
  availableBMC: string;
  unavailable: boolean;
}

export interface IUpgradeFile {
  id: string;
  name: string;
}

export interface IRadio {
  label: string;
  id: string;
}

export interface ITableStep2 {
  index: number;
  name: string;
  state: string;
  progress: number;
  firmwareName: string;
  description: string;
  eta?: number;
}

export interface ITableStep3 {
  id: number;
  firmwareType: string;
  activeStatus: string;
  activeAction: string;
}