//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { number } from '@intlify/core-base';

export interface IAlarm {
  content: string;
  createdTime: string;
  eventCode: string;
  handlingSuggestion?: string[];
  level: string;
  subject: string;
}

export interface IEvent {
  displayed: string[];
  srcData: ISrcData;
}

export interface ISrcData {
  data: object[];
  state: IState;
}

export interface IState {
  searched: boolean;
  sorted: boolean;
  paginated: boolean;
}

export interface IRadio {
  id: number;
  nameId: string;
  title: string;
  selected: IItem | string;
  items: IItem[];
}

export interface IItem {
  id: number | string | null;
  text: string;
  isShow?: boolean;
}

export interface IParams {
  Skip: number;
  Top: number;
  Level: string;
  Subject: string;
  BeginTime?: string;
  EndTime?: string;
  SearchString: string;
}
