//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { checkPrivil } from '@/apps/app-bmc/router/routes';
import { UserPrivil } from '@/model/base-enum';

export function privilDirective(app: any) {
  app.directive('privil', {
    mounted(el: HTMLElement, binding: any) {
      const needPrivils: string[] = [];
      Object.keys(binding.modifiers).forEach(key => {
        switch (key) {
          case 'baseConfig':
            needPrivils.push(UserPrivil.baseConfig);
            break;
          case 'diagnos':
            needPrivils.push(UserPrivil.diagnosis);
            break;
          case 'userConfig':
            needPrivils.push(UserPrivil.userConfig);
            break;
          case 'security':
            needPrivils.push(UserPrivil.securityConfig);
            break;
          case 'powerConfig':
            needPrivils.push(UserPrivil.powerControl);
            break;
          case 'vmm':
            needPrivils.push(UserPrivil.vmm);
            break;
          case 'remote':
            needPrivils.push(UserPrivil.remoteControl);
            break;
          case 'selfConfig':
            needPrivils.push(UserPrivil.configSelf);
            break;
          default:
            break;
        }
      });

      // 检查所需的权限是否都在用户权限列表内
      const result = checkPrivil(needPrivils);

      if (!result) {
        el.style.display = 'none';
      }
    },
  });
}
