//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export const enum Step {
  step0 = 'step0',
  step1 = 'step1',
  step2 = 'step2',
  step3 = 'step3',
  step4 = 'step4',
  step5 = 'step5'
}

export const DefaultColorConfig = {
  themeMode: 'light',
  brandColor: '#0077FF',
  brandMode: 'technology',
  background: {
    light: '#EBEFF6',
    dark: '#181B20',
  },
  alarmColor: {
    criticalColor: '#E32020',
    majorColor: '#F97611',
    minorColor: '#EBAF00',
  },
  stateColor: {
    alertColor: '#0077FF',
    successColor: '#24AB36',
    inheritBrand: null,
  },
};

export const DefaultLayoutConfig = {
  nav: 'topLeft',
  control: {
    radius: 'small',
    shadow: 'middle',
  },
};

export const DefaultConfig = {
  color: DefaultColorConfig,
  layout: DefaultLayoutConfig,
};
