//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { RouteRecordRaw } from 'vue-router';
import { storageGuard } from '@/apps/app-bmc/guard/storage.guard';

const infoRoutes: Array<RouteRecordRaw> = [
  {
    path: '/navigate/system/info/product',
    component: () => import('@/pages/System/Info/InfoPages/ProductInformation/ProductInformation.vue'),
  },
  {
    path: '/navigate/system/info/processor',
    component: () => import('@/pages/System/Info/InfoPages/Processor/Processor.vue'),
  },
  {
    path: '/navigate/system/info/memory',
    component: () => import('@/pages/System/Info/InfoPages/Memory/Memory.vue'),
  },
  {
    path: '/navigate/system/info/net',
    component: () => import('@/pages/System/Info/InfoPages/Net/Net.vue'),
  },
  {
    path: '/navigate/system/info/sensor',
    component: () => import('@/pages/System/Info/InfoPages/Sensors/Sensors.vue'),
  },
  {
    path: '/navigate/system/info/discrete-sensors',
    component: () => import('@/pages/System/Info/InfoPages/DiscreteSensors/DiscreteSensors.vue'),
  },
  {
    path: '/navigate/system/info/fru-info',
    component: () => import('@/pages/System/Info/InfoPages/Fru/Fru.vue'),
    beforeEnter: storageGuard,
  },
  {
    path: '/navigate/system/info/units',
    component: () => import('@/pages/System/Info/InfoPages/Units/Units.vue'),
  },
  {
    path: '/navigate/system/info/others',
    component: () => import('@/pages/System/Info/InfoPages/Others/Others.vue'),
  },
];
export default infoRoutes;