//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { RouterChangeReason } from '@/model/base-enum';
import { getPowerSupplyMode } from '@/pages/System/Power/services/power.services';
import { getStoreData, setStoreData } from '@/utils/composition';
import { getRandomNumber } from '@/utils/utils';
import { NavigationGuardNext, RouteLocationNormalized } from 'vue-router';

// 这类具体的路由守卫主要是验证环境是否支持该功能，以防止不支持该功能的环境可以通过路由跳转的方式进入该页面
export async function psuModeGuard(
  to: RouteLocationNormalized,
  from: RouteLocationNormalized,
  next: NavigationGuardNext,
): Promise<void> {
  let supported = getStoreData('loct', 'powerSourceSwitchSupported');
  if (supported === null && supported === undefined) {
    supported = true;
    try {
      await getPowerSupplyMode();
    } catch (error: any) {
      if (error.status === 404) {
        supported = false;
      }
    } finally {
      setStoreData('loct', 'powerSourceSwitchSupported', supported);
    }
  }
  if (!supported) {
    setStoreData('event', 'routeChangeError', RouterChangeReason.invalid + getRandomNumber());
  } else {
    next();
  }
}
