//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//       #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
const fs = require('fs');
const travelFuc = require('./scripts/travel');
const unzipFileRegex = /.*(?<!\.gz)$/;
const zipSourceRegex = /\.(js|css|scss|ts)?$/;
const zipTargetRegex = /\.(js|css|scss|ts)\.gz$/;
const distPath = './dist/';

travelFuc.travel(distPath, pathname => {
  if (unzipFileRegex.test(pathname)) {
    if (zipSourceRegex.test(pathname)) {
      fs.unlinkSync(pathname);
    }
  } else {
    if (!zipTargetRegex.test(pathname)) {
      fs.unlinkSync(pathname);
    }
  }
});