//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { MockMethod } from 'vite-plugin-mock';
import accounts from './data/accounts.data';
import { reqPath } from '../../src/api/reqPath';
import onlineUserData from './data/online-user.data';
import ldapEnable from './data/ldap.enable';
import ldapGroup from './data/ldap.data';
import securityModule from './security/security';
import kerberos from './data/kerberos.data';

export default [
  {
    url: '/UI/Rest/AccessMgnt/Accounts',
    method: 'get',
    timeout: 500,
    response: accounts
  },
  {
    url: reqPath.onlineUser.sessions,
    method: 'get',
    timeout: 500,
    response: onlineUserData
  },
  {
    url: '/UI/Rest/AccessMgnt/Kerberos',
    method: 'get',
    timeout: 500,
    response: kerberos
  },
  {
    url: '/UI/Rest/AccessMgnt/LDAP/1',
    method: 'get',
    timeout: 500,
    response: ldapGroup
  },
  {
    url: '/UI/Rest/AccessMgnt/LDAP',
    method: 'get',
    timeout: 500,
    response: ldapEnable
  },
  ...securityModule
] as MockMethod[];
