//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
export default {
  Team: [],
  Bridge: [],
  NetCard: [
    {
      BoardID: '0x0003',
      AdapterId: 'mainboardLOM',
      AssociatedResource: 'CPU1',
      OrderlyHotplugCtrlStatus: null,
      HotPlugSupported: false,
      PortProperties: [
        {
          NetworkAttribute: {
            PermanentPhysicalAddress: '34:0A:98:65:17:4A',
            MAC: '34:0A:98:65:17:4A',
            SpeedMbps: null,
            AutoNeg: null,
            FullDuplex: null,
            BusInfo: '0000:4c:00.2'
          },
          BasicAttribute: {
            MediaType: 'Electrical',
            PhysicalPortNumber: 1,
            InterfaceType: 'Physical',
            LinkStatus: 'Down'
          }
        },
        {
          NetworkAttribute: {
            PermanentPhysicalAddress: '34:0A:98:65:17:4B',
            MAC: '34:0A:98:65:17:4B',
            SpeedMbps: null,
            AutoNeg: null,
            FullDuplex: null,
            BusInfo: '0000:4c:00.3'
          },
          BasicAttribute: {
            MediaType: 'Electrical',
            PhysicalPortNumber: 2,
            InterfaceType: 'Physical',
            LinkStatus: 'Down'
          }
        },
        {
          NetworkAttribute: {
            PermanentPhysicalAddress: '34:0A:98:65:17:49',
            MAC: '34:0A:98:65:17:49',
            SpeedMbps: null,
            AutoNeg: null,
            FullDuplex: null,
            BusInfo: '0000:4c:00.1'
          },
          BasicAttribute: {
            MediaType: 'Optical',
            PhysicalPortNumber: 3,
            InterfaceType: 'Physical',
            LinkStatus: 'Down'
          }
        },
        {
          NetworkAttribute: {
            PermanentPhysicalAddress: '34:0A:98:65:17:48',
            MAC: '34:0A:98:65:17:48',
            SpeedMbps: null,
            AutoNeg: null,
            FullDuplex: null,
            BusInfo: '0000:4c:00.0'
          },
          BasicAttribute: {
            MediaType: 'Optical',
            PhysicalPortNumber: 4,
            InterfaceType: 'Physical',
            LinkStatus: 'Down'
          }
        }
      ],
      HotPlugAttention: false,
      BusInfo: '0000:4b:03.0',
      ChipModel: 'X722',
      ChipManufacturer: 'Intel',
      DisplayName: 'LOM',
      CardName: 'LOM',
      CardModel: '2*(10GE+GE)',
      CardManufacturer: 'Huawei',
      PCBVersion: '.B'
    },
    {
      BoardID: '0x00da',
      AdapterId: 'MainboardPCIeCard5(SP580)',
      AssociatedResource: 'CPU1',
      OrderlyHotplugCtrlStatus: null,
      PcieSlotId: 5,
      HotPlugSupported: false,
      PortProperties: [
        {
          NetworkAttribute: {
            PermanentPhysicalAddress: '00:02:03:04:05:06',
            MAC: '00:02:03:04:05:06',
            SpeedMbps: null,
            AutoNeg: null,
            FullDuplex: null,
            BusInfo: '0000:0b:00.0'
          },
          DCB: {
            PGPCT: [0],
            Up2cos: [0],
            Pgid: [0],
            PgStrict: [0]
          },
          BasicAttribute: {
            MediaType: 'Optical',
            PhysicalPortNumber: 1,
            InterfaceType: 'Physical',
            LinkStatus: 'Down'
          }
        },
        {
          NetworkAttribute: {
            PermanentPhysicalAddress: '00:02:03:04:05:07',
            MAC: '00:02:03:04:05:07',
            SpeedMbps: null,
            AutoNeg: null,
            FullDuplex: null,
            BusInfo: '0000:0c:00.0'
          },
          DCB: {
            PGPCT: [0],
            Up2cos: [0],
            Pgid: [0],
            PgStrict: [0]
          },
          BasicAttribute: {
            MediaType: 'Optical',
            PhysicalPortNumber: 2,
            InterfaceType: 'Physical',
            LinkStatus: 'Up'
          }
        },
        {
          NetworkAttribute: {
            PermanentPhysicalAddress: '00:02:03:04:05:08',
            MAC: '00:02:03:04:05:08',
            SpeedMbps: null,
            AutoNeg: null,
            FullDuplex: null,
            BusInfo: '0000:0d:00.0'
          },
          DCB: {
            PGPCT: [0],
            Up2cos: [0],
            Pgid: [0],
            PgStrict: [0]
          },
          BasicAttribute: {
            MediaType: 'Optical',
            PhysicalPortNumber: 3,
            InterfaceType: 'Physical',
            LinkStatus: 'Down'
          }
        },
        {
          NetworkAttribute: {
            PermanentPhysicalAddress: '00:02:03:04:05:09',
            MAC: '00:02:03:04:05:09',
            SpeedMbps: null,
            AutoNeg: null,
            FullDuplex: null,
            BusInfo: '0000:0e:00.0'
          },
          DCB: {
            PGPCT: [0],
            Up2cos: [0],
            Pgid: [0],
            PgStrict: [0]
          },
          BasicAttribute: {
            MediaType: 'Optical',
            PhysicalPortNumber: 4,
            InterfaceType: 'Physical',
            LinkStatus: 'Down'
          }
        }
      ],
      HotPlugAttention: false,
      BusInfo: '0000:08:00.0',
      ChipModel: 'Hi1822',
      ChipManufacturer: 'Huawei',
      DisplayName: 'PCIe Card 5 (SP580)',
      CardName: 'SP580',
      CardModel: '4*25GE',
      CardManufacturer: 'Huawei',
      PCBVersion: '.A'
    }
  ],
  FCCard: [
    {
      PortProperties: [
        {
          NetworkAttribute: {
            WWPN: null,
            WWNN: null,
            FirmwareVersion: null,
            DriverName: null,
            LinkSpeedGbps: null,
            DriverVersion: null
          },
          BasicAttribute: {
            FC_ID: null,
            Name: null,
            LinkStatus: null,
            InterfaceType: null
          }
        },
        {
          NetworkAttribute: {
            WWPN: null,
            WWNN: null,
            FirmwareVersion: null,
            DriverName: null,
            LinkSpeedGbps: null,
            DriverVersion: null
          },
          BasicAttribute: {
            FC_ID: null,
            Name: null,
            LinkStatus: null,
            InterfaceType: null
          }
        }
      ],
      CardModel: '2*8GE',
      ChipModel: 'Hi1822',
      ChipManufacturer: 'Huawei',
      DisplayName: 'PCIe Card 3 (SP522)',
      CardName: 'SP522',
      SerialNumber: '',
      PartNumber: '03025SVV',
      CardManufacturer: 'Huawei Technologies Co., Ltd.'
    }
  ]
};
