//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { MockMethod } from 'vite-plugin-mock';
import portData from './data/port.data';
import { vncData } from './data/vnc.data';
import { snmpData } from './data/snmp.data';
import { reqPath } from '@/api/reqPath';
import webData from './data/web/webService.data';
import patchWebData from './data/web/patchWebService.data';
import exportCsrData from './data/web/exportCsrt.data';
import taskData from './data/web/task.data';
import downloadData from './data/web/download.data';

export default [
  {
    url: '/UI/Rest/Services/PortConfig',
    method: 'get',
    timeout: 150,
    response: portData
  },
  {
    url: '/UI/Rest/Services/WEBService',
    method: 'get',
    timeout: 150,
    response: webData
  },
  {
    url: '/UI/Rest/Services/WEBService',
    method: 'patch',
    timeout: 300,
    response: patchWebData
  },
  {
    url: '/UI/Rest/Services/WEBService/ImportCertificate',
    method: 'post',
    timeout: 300,
    response: ''
  },
  {
    url: '/UI/Rest/Services/WEBService/ExportCSR',
    method: 'post',
    timeout: 300,
    response: exportCsrData
  },
  {
    url: '/task/758b4dbe-852f-4b14-be9b-88d7a8bde70f',
    method: 'get',
    timeout: 10000,
    response: taskData
  },
  {
    url: '/download/758b4dbe-852f-4b14-be9b-88d7a8bde70f',
    method: 'get',
    timeout: 300,
    rawResponse: async (req, res) => {
      res.setHeader('Content-Disposition', 'attachment; filename=server.csr');
      res.end(downloadData);
    }
  },
  {
    url: reqPath.vnc.getVncData,
    method: 'get',
    timeout: 500,
    response: vncData
  },
  {
    url: reqPath.snmp,
    method: 'get',
    timeout: 500,
    response: snmpData
  }
] as MockMethod[];
