//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { createProdMockServer } from 'vite-plugin-mock/es/createProdMockServer';

import userModule from './user/localuser';
import loginModule from './login/login';
import ServiceModule from './services/services';
import systemModule from './system/system';
import storageModule from './storage/localStorage';
import vmmModule from './vmm/vmm';
import licenseModule from './license/license';
import managerModule from './manager/manager';
import maintanceModule from './maintance/maintance';
import ntpModule from './ntp/ntp';
import reportModule from './report/report';

export function setupProdMockServer() {
  createProdMockServer([
    ...loginModule,
    ...userModule,
    ...ServiceModule,
    ...systemModule,
    ...storageModule,
    ...vmmModule,
    ...licenseModule,
    ...managerModule,
    ...maintanceModule,
    ...ntpModule,
    ...reportModule
  ])
}