//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.
import { MockMethod } from 'vite-plugin-mock';
import loginData from './data/login.data';
import { loginPostdata } from './data/login.post.data';
import overViewData from './data/overview.data';
import { UI_REST_KEEPALIVE } from '@/api/api';

export default [
  {
    url: '/UI/Rest/Login',
    method: 'get',
    timeout: 500,
    response: loginData
  },
  {
    url: '/UI/Rest/Overview',
    method: 'get',
    timeout: 500,
    response: overViewData
  },
  {
    url: '/UI/Rest/Login',
    method: 'post',
    timeout: 500,
    response: loginPostdata
  },
  {
    url: UI_REST_KEEPALIVE,
    method: 'post',
    timeout: 500,
    response: {}
  },
  {
    url: '/UI/Rest/Sessions/XXXXXXXXXX',
    method: 'delete',
    timeout: 500,
    response: {}
  }
] as MockMethod[];
