//  Copyright (c) 2024 Huawei Technologies Co., Ltd.
//  openUBMC is licensed under Mulan PSL v2.
//  You can use this software according to the terms and conditions of the Mulan PSL v2.
//  You may obtain a copy of Mulan PSL v2 at:
//        #  http://license.coscl.org.cn/MulanPSL2
//  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
//  EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
//  MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
//  See the Mulan PSL v2 for more details.

export function configRollupOptions() {
  return {
    output: {
      manualChunks(id) {
        if (id.includes('/node_modules/')) {
          const dep = /node_modules\/(.+?)\//g.exec(id)?.[1] || '';
          if (/\/opendesign2\/themes\/es\/(.*?)\//.test(id)) {
            return 'opendesign2';
          } else if (/\/element-plus\/es\/components\/(.*?)\/(.*)\/?style/.test(id)) {
            return 'element-plus';
          } else {
            return 'vendor';
          }
        } else if (id.includes('/src/assets/baseI18n/')) {
          const i18n = /src\/assets\/baseI18n\/(.+?).json/g.exec(id)?.[1];
          if (i18n) {
            return i18n;
          }
          return 'assets';
        }
      },
      // 优化打包文件名
      chunkFileNames: (chunkInfo: any): string => {
        const facadeModuleId = chunkInfo.facadeModuleId ? chunkInfo.facadeModuleId.split('/') : [];
        const fileName = facadeModuleId[facadeModuleId.length - 2] || '[name]';
        return `assets/${fileName}.[hash].js`;
      },
    },
  };
}