-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local c_object_manage = require 'mc.orm.object_manage'
local c_tasks = require 'mc.orm.tasks'
local threshold_sensor_data_keeping = require 'basic_cooling.data_keeping.threshold_sensor_data_keeping'

TestThresholdSensor = {}

local path = 'path1'
local inlet_path = 'inlet_path'
local outlet_path = 'outlet_path'
local power_path = 'power_path'
local fan_power_path = 'fan_power_path'
local interface = "bmc.kepler.Systems.ThresholdSensor"
local threshold_sensor_interface = "bmc.kepler.Systems.ThresholdSensor"
local threshold_sensor_display_interface = "bmc.kepler.Systems.ThresholdSensorDisplay"

local tmp = {
    ['threshold_sensor_interface'] = threshold_sensor_interface,
    ['threshold_sensor_display_interface'] = threshold_sensor_display_interface,
    ['inlet_path'] = inlet_path,
    ['outlet_path'] = outlet_path,
    ['power_path'] = power_path,
    ['fan_power_path'] = fan_power_path
}
tmp.objs = {
    [path] = {
        [threshold_sensor_interface] = {},
        [threshold_sensor_display_interface] = {}
    },
    [inlet_path] = {
        [threshold_sensor_display_interface] = {}
    },
    [outlet_path] = {
        [threshold_sensor_display_interface] = {}
    },
    [power_path] = {
        [threshold_sensor_display_interface] = {}
    },
    [fan_power_path] = {
        [threshold_sensor_display_interface] = {}
    }
}
tmp.objs[path][interface].obj = {
    ['SensorName'] = 'SensorName',
    ['ReadingDisplay'] = 45
}
tmp.objs[inlet_path][threshold_sensor_display_interface].obj = {
    ['ReadingDisplay'] = 20
}
tmp.objs[outlet_path][threshold_sensor_display_interface].obj = {
    ['ReadingDisplay'] = 60
}
tmp.objs[power_path][threshold_sensor_display_interface].obj = {
    ['ReadingDisplay'] = 800
}
tmp.objs[fan_power_path][threshold_sensor_display_interface].obj = {
    ['ReadingDisplay'] = 90
}

function TestThresholdSensor:test_action_after_property_changed()
    local fan_obj = {
        ['FanId'] = 1,
        ['MaxSupportedPWM'] = 255,
        ['HardwarePWM'] = 66,
        ['Coefficient'] = 1,
        ['FrontSpeed'] = 10000,
        ['RearSpeed'] = 10000
    }
    tmp.c_fan_object = {}
    tmp.c_fan_object.collection = {
        fold = function (s, func)
            func(_, fan_obj)
        end
    }
    tmp.utils = {
        thermal_log = function (log_msg)
            lu.assertEquals(log_msg, 'SensorName[SensorName] Health change to Minor, value:45,' ..
            ' Inlet Temp:20, Output Temp:60, System power:800, Fan total power:90, [fanId:1|PWM:25|Speed:10000]')
        end
    }
    threshold_sensor_data_keeping.action_after_property_changed(tmp, path, interface, 'Health', 'Minor')
end

function TestThresholdSensor:test_action_after_obj_added()
    local path_local = "path"
    local interface_local = "interface"
    
    local tmp_local = {}
    tmp_local.props = {
        ["THRESHOLD_SENSOR_DISPLY"] = {
            ["SENSOR_NAME"] = 'SENSOR_NAME',
            ["SENSOR_IDENTIFIER"] = 'SENSOR_IDENTIFIER'
        },
        ['INLET_TEMP'] = 'Inlet Temp',
        ['OUTLET_TEMP'] = 'Outlet Temp',
        ['POWER'] = 'Power', -- 整机功耗
        ['FAN_POWER'] = 'FAN Power' -- 风扇功耗
    }
    tmp_local.objs = {
        [path_local] = {
            [interface_local] = {
                ["SENSOR_NAME"] = 'Inlet Temp',
                ["SENSOR_IDENTIFIER"] = 'Inlet Temp'
            }
        }
    }
    threshold_sensor_data_keeping.action_after_obj_added(tmp_local, path_local, interface_local)
    lu.assertEquals(tmp_local.inlet_path, path_local)
    tmp_local.objs[path_local][interface_local]["SENSOR_NAME"] = ''
    threshold_sensor_data_keeping.action_after_obj_added(tmp_local, path_local, interface_local)
    lu.assertEquals(tmp_local.inlet_path, path_local)

    tmp_local.objs[path_local][interface_local]["SENSOR_NAME"] = 'Outlet Temp'
    tmp_local.objs[path_local][interface_local]["SENSOR_IDENTIFIER"] = 'Outlet Temp'
    threshold_sensor_data_keeping.action_after_obj_added(tmp_local, path_local, interface_local)
    lu.assertEquals(tmp_local.outlet_path, path_local)
    tmp_local.objs[path_local][interface_local]["SENSOR_NAME"] = ''
    threshold_sensor_data_keeping.action_after_obj_added(tmp_local, path_local, interface_local)
    lu.assertEquals(tmp_local.outlet_path, path_local)

    tmp_local.objs[path_local][interface_local]["SENSOR_NAME"] = 'Power'
    tmp_local.objs[path_local][interface_local]["SENSOR_IDENTIFIER"] = 'Power'
    threshold_sensor_data_keeping.action_after_obj_added(tmp_local, path_local, interface_local)
    lu.assertEquals(tmp_local.outlet_path, path_local)
    tmp_local.objs[path_local][interface_local]["SENSOR_NAME"] = ''
    threshold_sensor_data_keeping.action_after_obj_added(tmp_local, path_local, interface_local)
    lu.assertEquals(tmp_local.outlet_path, path_local)

    tmp_local.objs[path_local][interface_local]["SENSOR_NAME"] = 'FAN Power'
    tmp_local.objs[path_local][interface_local]["SENSOR_IDENTIFIER"] = 'FAN Power'
    threshold_sensor_data_keeping.action_after_obj_added(tmp_local, path_local, interface_local)
    lu.assertEquals(tmp_local.outlet_path, path_local)
    tmp_local.objs[path_local][interface_local]["SENSOR_NAME"] = ''
    threshold_sensor_data_keeping.action_after_obj_added(tmp_local, path_local, interface_local)
    lu.assertEquals(tmp_local.outlet_path, path_local)
end