-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local PCIE_CARD_INTERFACE <const> = "bmc.kepler.Systems.PCIeDevices.PCIeCard"

TestPCIeCard = {}

function TestPCIeCard:test_action_after_property_changed()
    local cards_data_keeping = require 'basic_cooling.data_keeping.cards_data_keeping'
    local pcie_card1_name = 'pciecard_name1'
    local pcie_card2_name = 'pciecard_name2'
    local pcie_card_path = '/bmc/kepler/Systems/1/PCIeDevices/PCIeCards/PCIeCard_1_01'

    cards_data_keeping.loaded_pciecards = {
        [pcie_card1_name] = 1
    }
    cards_data_keeping.pciecard_path_name_map = {
        [pcie_card_path] = pcie_card1_name
    }

    cards_data_keeping:action_after_property_changed(pcie_card_path, PCIE_CARD_INTERFACE, 'Name', pcie_card2_name)
    lu.assertEquals(cards_data_keeping.loaded_pciecards[pcie_card1_name], 0)
    lu.assertEquals(cards_data_keeping.loaded_pciecards[pcie_card2_name], 1)
    lu.assertEquals(cards_data_keeping.pciecard_path_name_map[pcie_card_path], pcie_card2_name)
end