-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local c_fans_object = require 'fans_object'
local c_object_manage = require 'mc.orm.object_manage'
local c_tasks = require 'mc.orm.tasks'
local thermal_db = require 'thermal_mgmt.db'
local hook_tasks = require 'test_common.hook_tasks'
local test_utils = require 'test_utils'

TestFans = {}

function TestFans:flush()
    c_tasks.get_instance():run_all_task()
    self.database.db:flush()
end

function TestFans:setUp()
    self.database = thermal_db(':memory:')

    hook_tasks.hook()
    self.object_manage = c_object_manage.new(self.database)
    self.object_manage.app = self

    local fans  = {
        PWMChip = {},
        SetPWMCmd = 402657792,
        WorkInStandby = 1,
        FansObjectName = "Fans_0_010107"
    }

    local fans_obj = test_utils.add_fans_obj(self.object_manage, 'Fans_1', fans)
    self.object_manage.mc:before_add_object(c_fans_object.__class_name, fans_obj)
    self.object_manage.mc:add_object(c_fans_object.__class_name, fans_obj, '010107')
    self.object_manage.mc:prepare_ok()
    self:flush()
end

function TestFans:tearDown()
    c_object_manage.destroy()
    self.database.db:close()
    hook_tasks.unhook()
end

function TestFans:test_fans_ctor_init()
    local obj = c_fans_object.collection:find({
        SetPWMCmd = 402657792,
    })
    lu.assertIsTable(obj.fan_collection)
    lu.assertIsTable(obj.t_pwm)
    lu.assertIsTable(obj.l_pwm)
end

function TestFans:test_check_standby()
    local obj = c_fans_object.collection:find({
        SetPWMCmd = 402657792,
    })
    lu.assertEquals(obj:check_standby(), true)
end

function TestFans:test_set_standy_fan()
    local obj = c_fans_object.collection:find({
        SetPWMCmd = 402657792,
    })
    obj.fan_collection.fan1 = {}
    obj.fan_collection.fan1.standbyfan = false
    obj.fan_collection.fan2 = {}
    obj.fan_collection.fan2.standbyfan = false
    obj:set_standy_fan()
    lu.assertEquals(obj.fan_collection.fan1.standbyfan, true)
    lu.assertEquals(obj.fan_collection.fan2.standbyfan, true)
end