-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local fans_config = require 'basic_cooling.cooling_config.fans_config'
local disks_data_keeping = require 'basic_cooling.data_keeping.disks_data_keeping'
local lu = require 'luaunit'

fans_config.destroy()


TestDiskTemp = {}

local cooling_config_obj = {
    ["RearNVMeSSDMaxTemperatureCelsius"] = 0,
    ["RearHddMaxTemperatureCelsius"] = 0,
    ["FrontNVMeSSDMaxTemperatureCelsius"] = 0,
    ["FrontHddMaxTemperatureCelsius"] = 0,
}

local disks_data_keeping_obj_1 = {
    ["RearNVMeSSDMaxTemperatureCelsius"] = 0,
    ["RearHddMaxTemperatureCelsius"] = 20,
    ["FrontNVMeSSDMaxTemperatureCelsius"] = 0,
    ["FrontHddMaxTemperatureCelsius"] = 0,
}

function TestDiskTemp:test_assign()
    fans_config.obj = cooling_config_obj
    fans_config.disks_data_keeping = disks_data_keeping_obj_1

    fans_config:set_coolingconfig_prop_by_info()
    lu.assertEquals(fans_config.obj.RearHddMaxTemperatureCelsius, 20)

    -- 模拟温度变化时信号触发
    fans_config:set_coolingconfig_prop_by_info_signal('front_hdd_temp', 30)
    lu.assertEquals(fans_config.obj.FrontHddMaxTemperatureCelsius, 30)
end

function TestDiskTemp:test_disk_data_keeping()
    disks_data_keeping.get_all_infos = function()
    end

    disks_data_keeping.storage_info = {}
    disks_data_keeping.disks_info_changed = {}
    disks_data_keeping.disks_info_changed.emit = function()
    end

    -- 模拟不在位
    local Drive1 = {
        id = 1,
        presence = 0,
        protocol = '',
        media_type = '',
        temperature = 0,
        position = 'Front'
    }
    -- 模拟前置disk
    local Drive2 = {

        id = 2,
        presence = 1,
        protocol = 1,
        media_type = 0,
        temperature = 20,
        position = 'Front'
    }
    local Drive3 = {
        id = 3,
        presence = 1,
        protocol = 1,
        media_type = '',
        temperature = 50,
        position = 'Front'
    }
    -- 模拟后置disk
    local Drive4 = {
        id = 4,
        presence = 1,
        protocol = 1,
        media_type = 0,
        temperature = 30,
        position = 'Rear'
    }
    -- 模拟后置nvme
    local Drive5 = {
        id = 5,
        presence = 1,
        protocol = 6,
        media_type = '',
        temperature = 30,
        position = 'Rear'
    }
    -- 模拟前置nvme
    local Drive6 = {
        id = 6,
        presence = 1,
        protocol = 6,
        media_type = '',
        temperature = 40,
        position = 'Front'
    }

    table.insert(disks_data_keeping.storage_info, Drive1)
    table.insert(disks_data_keeping.storage_info, Drive2)
    table.insert(disks_data_keeping.storage_info, Drive3)
    table.insert(disks_data_keeping.storage_info, Drive4)
    table.insert(disks_data_keeping.storage_info, Drive5)
    table.insert(disks_data_keeping.storage_info, Drive6)

    disks_data_keeping:update_drive_max_temp_for_sensor()

    lu.assertEquals(disks_data_keeping.RearNVMeSSDMaxTemperatureCelsius, 30)
    lu.assertEquals(disks_data_keeping.RearHddMaxTemperatureCelsius, 30)
    lu.assertEquals(disks_data_keeping.FrontNVMeSSDMaxTemperatureCelsius, 40)
    lu.assertEquals(disks_data_keeping.FrontHddMaxTemperatureCelsius, 20)
end

return TestDiskTemp
