-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local abnormal_fan =  require "basic_cooling.cooling_abnormal_device.abnormal_fan"
local props = require 'basic_cooling.define.cooling_properties'
local enums = require 'basic_cooling.define.cooling_enums'

TestAbnormalFan = {}

function TestAbnormalFan:test_get_abnormal_fan_obj()
    abnormal_fan.objs = {[1] = nil}
    local ok = pcall(abnormal_fan.get_abnormal_fan_obj, abnormal_fan, 1, 1)
    lu.assertEquals(ok, true)   
    abnormal_fan.objs = {[1] = {[1] = {}}}
    ok = pcall(abnormal_fan.get_abnormal_fan_obj, abnormal_fan, 1, 1)
    lu.assertEquals(ok, true)    
end

function TestAbnormalFan:test_obj_add_callback()
    local object = {
        FanIdx = 1,
        Status = 1,
        [props.ABNORMAL_FAN_PRIORITY] = 2
    }
    abnormal_fan.objs = {
        [1] = {[1] = {[props.ABNORMAL_FAN_PRIORITY] = 1}}
    }
    local ok = pcall(abnormal_fan.obj_add_callback, abnormal_fan, 1, object, 1)
    lu.assertEquals(ok, true)    
end

function TestAbnormalFan:test_obj_delete_callback()
    local object = {
        FanIdx = 1,
        Status = 1
    }
    local ok = pcall(abnormal_fan.obj_delete_callback, abnormal_fan, 1, object, 1)
    lu.assertEquals(ok, true)
end

function TestAbnormalFan:test_gen_exp_speed_key()
    local ok = pcall(abnormal_fan.gen_exp_speed_key, nil, nil, nil)
    lu.assertEquals(ok, true)
end

function TestAbnormalFan:test_get_fan_speed_status()
    abnormal_fan.abn_status_mapping = {[1] = nil, [2] = nil}
    local ok = pcall(abnormal_fan.get_fan_speed_status, abnormal_fan, 0, 1, 2)
    lu.assertEquals(ok, true)
    abnormal_fan.abn_status_mapping = {[1] = "", [2] = ""}
    ok = pcall(abnormal_fan.get_fan_speed_status, abnormal_fan, 0, 1, 2)
    lu.assertEquals(ok, true)
end

function TestAbnormalFan:test_get_fan_presence_status()
    abnormal_fan.abn_presence_mapping = {[1] = "NotInPosition", [2] = "NotInPosition"}
    local ok = pcall(abnormal_fan.get_fan_presence_status, abnormal_fan, 0, 1, 2)
    lu.assertEquals(ok, true)
    abnormal_fan.abn_presence_mapping = {[1] = "Normal", [2] = "Normal"}
    ok = pcall(abnormal_fan.get_fan_presence_status, abnormal_fan, 0, 1, 2)
    lu.assertEquals(ok, true)
    abnormal_fan.abn_presence_mapping = {[1] = "", [2] = ""}
    ok = pcall(abnormal_fan.get_fan_presence_status, abnormal_fan, 0, 1, 2)
    lu.assertEquals(ok, true)
end

function TestAbnormalFan:test_add_exp_speed_t()
    abnormal_fan.exp_speed_t = {[1] = ""}
    local ok = pcall(abnormal_fan.add_exp_speed_t, abnormal_fan, 1, 1)
    lu.assertEquals(ok, true)
end

function TestAbnormalFan:test_delete_exp_speed_t()
    abnormal_fan.exp_speed_t = {[1] = {[1] = "1"}}
    local ok = pcall(abnormal_fan.delete_exp_speed_t, abnormal_fan, 1)
    lu.assertEquals(ok, true)
end

function TestAbnormalFan:test_update_exp_speed_table()
    abnormal_fan.obj = {[0] = nil}
    local ok = pcall(abnormal_fan.update_exp_speed_table, abnormal_fan, 1, 0, "")
    lu.assertEquals(ok, true)
    abnormal_fan.obj = {[1] = {["1"] = {FanGroup = {}, SpeedPercentage = 1}}}
    abnormal_fan.exp_speed_t = {["AbnormalFan_1_1"] = nil}
    abnormal_fan.refresh_exp_speed_table = function(...)
        return
    end
    abnormal_fan.generate_abn_policy_table = function(...)
        return {[1] = ""}
    end
    ok = pcall(abnormal_fan.update_exp_speed_table, abnormal_fan, enums.exp_type.ABNORMAL_FAN, 1, "1")
    lu.assertEquals(ok, true)
    
end