-- Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local mdb = require 'mc.mdb'
local props = require 'basic_cooling.define.cooling_properties'
local cooling_enums = require 'basic_cooling.define.cooling_enums'
local skynet = require 'skynet'
local error = require 'mc.error'
local safe_call = error.safe_call

local test_min_pwm = {}

local function l_objs_init(bus)
    local ok
    local t_fan_1_obj, t_fan_2_obj, t_fan_3_obj, t_fan_4_obj
    local t_fan_1_path = '/bmc/kepler/Systems/1/Thermal/Fans/Fan_1_0101'
    local t_fan_2_path = '/bmc/kepler/Systems/1/Thermal/Fans/Fan_2_0101'
    local t_fan_3_path = '/bmc/kepler/Systems/1/Thermal/Fans/Fan_3_0101'
    local t_fan_4_path = '/bmc/kepler/Systems/1/Thermal/Fans/Fan_4_0101'

    ok, t_fan_1_obj = pcall(mdb.get_object, bus, t_fan_1_path, 'bmc.kepler.Systems.Fan')
    assert(ok)
    ok, t_fan_2_obj = pcall(mdb.get_object, bus, t_fan_2_path, 'bmc.kepler.Systems.Fan')
    assert(ok)
    ok, t_fan_3_obj = pcall(mdb.get_object, bus, t_fan_3_path, 'bmc.kepler.Systems.Fan')
    assert(ok)
    ok, t_fan_4_obj = pcall(mdb.get_object, bus, t_fan_4_path, 'bmc.kepler.Systems.Fan')
    assert(ok)
    return {
        ['t_fan_1'] = t_fan_1_obj,
        ['t_fan_2'] = t_fan_2_obj,
        ['t_fan_3'] = t_fan_3_obj,
        ['t_fan_4'] = t_fan_4_obj
    }
end

function test_min_pwm.main(bus, ctx_new, c_config_obj)
    log:info('================ test min pwm start ================')
    local objs = l_objs_init(bus)
    local err
    err = safe_call(c_config_obj.SetMinAllowedFanSpeedEnabled, c_config_obj, ctx_new, true)
    assert(not err, 'err_msg:' .. tostring(err))
    assert(objs['t_fan_1'].ExpectedPWM < 230, 'Actual:' .. objs['t_fan_1'].ExpectedPWM)
    assert(objs['t_fan_2'].ExpectedPWM < 230, 'Actual:' .. objs['t_fan_2'].ExpectedPWM)
    assert(objs['t_fan_3'].ExpectedPWM < 230, 'Actual:' .. objs['t_fan_3'].ExpectedPWM)
    assert(objs['t_fan_4'].ExpectedPWM < 230, 'Actual:' .. objs['t_fan_4'].ExpectedPWM)
    c_config_obj[props.MIN_FAN_SPEED_PERCENT] = 90
    -- 设置混合模式
    err = safe_call(c_config_obj.SetCtrlMode_PACKED, c_config_obj, ctx_new, cooling_enums.modes.Mixed, 30)
    assert(not err)
    assert(c_config_obj[props.MIN_FAN_SPEED_PERCENT], 90)
    skynet.sleep(1000)
    assert(objs['t_fan_1'].ExpectedPWM <= 230, 'Actual:' .. objs['t_fan_1'].ExpectedPWM)
    assert(objs['t_fan_2'].ExpectedPWM <= 230, 'Actual:' .. objs['t_fan_2'].ExpectedPWM)
    assert(objs['t_fan_3'].ExpectedPWM <= 230, 'Actual:' .. objs['t_fan_3'].ExpectedPWM)
    assert(objs['t_fan_4'].ExpectedPWM <= 230, 'Actual:' .. objs['t_fan_4'].ExpectedPWM)
    --心跳恢复转速下降
    err = safe_call(c_config_obj.SetMinAllowedFanSpeedEnabled, c_config_obj, ctx_new, false)
    assert(not err, 'err_msg:' .. tostring(err))
    skynet.sleep(1000)
    assert(objs['t_fan_1'].ExpectedPWM < 230, 'Actual:' .. objs['t_fan_1'].ExpectedPWM)
    assert(objs['t_fan_2'].ExpectedPWM < 230, 'Actual:' .. objs['t_fan_2'].ExpectedPWM)
    assert(objs['t_fan_3'].ExpectedPWM < 230, 'Actual:' .. objs['t_fan_3'].ExpectedPWM)
    assert(objs['t_fan_4'].ExpectedPWM < 230, 'Actual:' .. objs['t_fan_4'].ExpectedPWM)
    err = safe_call(c_config_obj.SetCtrlMode_PACKED, c_config_obj, ctx_new, cooling_enums.modes.Auto, 30)
    assert(not err)
    log:info('================ test min pwm end ================')
end

return test_min_pwm