-- Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
local mdb = require 'mc.mdb'
local log = require 'mc.logging'
require 'thermal_mgmt.json_types.DiskCoolingConfig'
require 'thermal_mgmt.json_types.CoolingRequirement'
require 'thermal_mgmt.json_types.Drive'

local test_data_keeping = {}

local function l_objs_init(bus)
    local ok, policy_10, policy_11

    local c_policy_10_path = '/bmc/kepler/Systems/1/CoolingPolicy/CoolingPolicy_1_10_0101'
    local c_policy_11_path = '/bmc/kepler/Systems/1/CoolingPolicy/CoolingPolicy_1_11_0101'

    ok, policy_10 = pcall(mdb.get_object, bus, c_policy_10_path, 'bmc.kepler.Systems.CoolingPolicy')
    assert(ok)
    ok, policy_11 = pcall(mdb.get_object, bus, c_policy_11_path, 'bmc.kepler.Systems.CoolingPolicy')
    assert(ok)

    return {
        policy_10 = policy_10,
        policy_11 = policy_11
    }
end

local function card_data_keeping_test(policy_10, policy_11)
    assert(policy_10.IsValid == 1, 'policy(id:10) IsValid: ' .. tostring(policy_10.IsValid))
    assert(policy_11.IsValid == 1, 'policy(id:11) IsValid: ' .. tostring(policy_11.IsValid))
end

function test_data_keeping.main(bus, config_o)
    log:info('================ test data keeping start ================')
    local l_objs = l_objs_init(bus)
    card_data_keeping_test(l_objs.policy_10, l_objs.policy_11)
    log:info('================ test data keeping complete ================')
end

return test_data_keeping