-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local mc_context = require 'mc.context'
local json = require 'cjson'
local skynet = require 'skynet'

local context = mc_context.new('IT', 'Admin', '127.0.0.1')

local test_customize_config = {}

local service = 'bmc.kepler.thermal_mgmt'
local path = '/bmc/kepler/thermal_mgmt/MicroComponent'
local intf = 'bmc.kepler.MicroComponent.ConfigManage'

local function test_on_import(bus)
    local data = json.encode({
        ConfigData = {
            CustomSettings = {
                BMCSet_Thermal_Policy = { Value = 17 },
                Custom_Inlet_Temp_Level = { Value = '3, 20, 30, 40, 40, 60, 80, 90' },
                Custom_OutletObjTem = { Value = 50 },
                Custom_CoreRemObjTem = { Value = 90 },
                BMCSet_FanInitDefaultLevel = { Value = 90 }
            }
        }
    })
    bus:call(service, path, intf, 'Import', 'a{ss}ss', context, data, 'custom')
end

local function test_on_export(bus)
    local ret = bus:call(service, path, intf, 'Export', 'a{ss}s', context, 'custom')
    assert(ret)
    local data = json.decode(ret)
    assert(data)
    assert(data.ConfigData)
    assert(data.ConfigData.CustomSettings.BMCSet_Thermal_Policy == 17)
    assert(data.ConfigData.CustomSettings.Custom_OutletObjTem == 50,
        'actual:' .. tostring(data.ConfigData.CustomSettings.Custom_OutletObjTem))
    assert(data.ConfigData.CustomSettings.Custom_CoreRemObjTem == 90,
        'actual:' .. tostring(data.ConfigData.CustomSettings.Custom_CoreRemObjTem))
    assert(data.ConfigData.CustomSettings.BMCSet_FanInitDefaultLevel == 90,
        'actual:' .. tostring(data.ConfigData.CustomSettings.BMCSet_FanInitDefaultLevel))
    assert(data.ConfigData.CustomSettings.Custom_Inlet_Temp_Level == "3,20,30,40,40,60,80,90",
        'actual:' .. tostring(data.ConfigData.CustomSettings.Custom_Inlet_Temp_Level))
end

function test_customize_config.main(bus)
    log:info('================ test customize config start ================')
    test_on_import(bus)
    skynet.sleep(2000)
    test_on_export(bus)
    log:info('================ test customize config end ================')
    
end

return test_customize_config