-- Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local log = require 'mc.logging'
local singleton = require 'mc.singleton'
local client = require 'thermal_mgmt.client'
local enums = require 'basic_cooling.define.cooling_enums'
local props = require 'basic_cooling.define.cooling_properties'
local base = require 'basic_cooling.data_keeping.base'

local MANUFACTURE_OBJ_PATH<const> = "/bmc/kepler/Managers/1/Manufacture"

local manufacture = class(base)

function manufacture:ctor(bus)
    self.obj_name = 'Manufacture'
    -- 监听的资源树路径
    self.paths_table = {
        "/bmc/kepler/Managers/:ManagerId/Manufacture"
    }
    -- 监听的接口
    self.interfaces_table = {
        ["bmc.kepler.Manufacture.Status"] = {
            [enums.data_keeping_config.FOREACH_FUNC] = client.ForeachStatusObjects,
            [enums.data_keeping_config.PROPERTIES] = {
                [props.MANUFACTURING_MODE] = enums.data_keeping_log.LOG
            }
        }
    }
end

function manufacture:init()
    self.super.init(self)
    self.global = {
        is_manufacture = false --是否为装备包
    }
    self:check_manufacture()
end

-- 检查是否是装备包
function manufacture:check_manufacture()
    local ok, _ = pcall(require, 'thermal_mgmt_manufacture')
    if ok then
        self.global.is_manufacture = true
        log:notice('Check manufacture result is true')
    else
        log:notice('Check manufacture result is false')
    end
end

-- 获取装备包标识
function manufacture:get_manufacture_package_flag()
    return self.global.is_manufacture
end

-- 获取装备模式
function manufacture:get_manufacture_mode()
    if self.objs and self.objs[MANUFACTURE_OBJ_PATH] then
        return self.objs[MANUFACTURE_OBJ_PATH][props.MANUFACTURING_MODE]
    end
    return nil
end

return singleton(manufacture)
