-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'

-- 默认pwm_channel对象
local pwm_channel = class()

function pwm_channel:ctor(fan)
    pwm_channel.fan = fan
end

function pwm_channel:set_fan_pwm(pwm_value)
    self.fan:set_pwm(pwm_value)
end

function pwm_channel:set_fan_hardware_pwm(pwm_value)
    self.fan:set_pwm(pwm_value)
end

function pwm_channel:set_fan_expected_pwm(pwm_value)
    self.fan:set_expected_pwm(pwm_value)
end

function pwm_channel:configurable()
    -- 已识别的风扇才支持设置
    return self.fan:is_identified()
end

return pwm_channel