-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PowerSupplies = {}

---@class PowerSupplies.UpgradeStatus
---@field UpgradeStatus integer
local TUpgradeStatus = {}
TUpgradeStatus.__index = TUpgradeStatus
TUpgradeStatus.group = {}

local function TUpgradeStatus_from_obj(obj)
    return setmetatable(obj, TUpgradeStatus)
end

function TUpgradeStatus.new(UpgradeStatus)
    return TUpgradeStatus_from_obj({UpgradeStatus = UpgradeStatus or 0})
end
---@param obj PowerSupplies.UpgradeStatus
function TUpgradeStatus:init_from_obj(obj)
    self.UpgradeStatus = obj.UpgradeStatus or 0
end

function TUpgradeStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeStatus.group)
end

TUpgradeStatus.from_obj = TUpgradeStatus_from_obj

TUpgradeStatus.proto_property = {'UpgradeStatus'}

TUpgradeStatus.default = {0}

TUpgradeStatus.struct = {{name = 'UpgradeStatus', is_array = false, struct = nil}}

function TUpgradeStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpgradeStatus', self.UpgradeStatus, 'uint8', true, errs, need_convert)

    TUpgradeStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeStatus.proto_property, errs, need_convert)
    return self
end

function TUpgradeStatus:unpack(_)
    return self.UpgradeStatus
end

PowerSupplies.UpgradeStatus = TUpgradeStatus

---@class PowerSupplies.SetPsusFanMinPWMRsp
local TSetPsusFanMinPWMRsp = {}
TSetPsusFanMinPWMRsp.__index = TSetPsusFanMinPWMRsp
TSetPsusFanMinPWMRsp.group = {}

local function TSetPsusFanMinPWMRsp_from_obj(obj)
    return setmetatable(obj, TSetPsusFanMinPWMRsp)
end

function TSetPsusFanMinPWMRsp.new()
    return TSetPsusFanMinPWMRsp_from_obj({})
end
---@param obj PowerSupplies.SetPsusFanMinPWMRsp
function TSetPsusFanMinPWMRsp:init_from_obj(obj)

end

function TSetPsusFanMinPWMRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPsusFanMinPWMRsp.group)
end

TSetPsusFanMinPWMRsp.from_obj = TSetPsusFanMinPWMRsp_from_obj

TSetPsusFanMinPWMRsp.proto_property = {}

TSetPsusFanMinPWMRsp.default = {}

TSetPsusFanMinPWMRsp.struct = {}

function TSetPsusFanMinPWMRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetPsusFanMinPWMRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPsusFanMinPWMRsp.proto_property, errs, need_convert)
    return self
end

function TSetPsusFanMinPWMRsp:unpack(_)
end

PowerSupplies.SetPsusFanMinPWMRsp = TSetPsusFanMinPWMRsp

---@class PowerSupplies.SetPsusFanMinPWMReq
---@field FanMinPWM integer
local TSetPsusFanMinPWMReq = {}
TSetPsusFanMinPWMReq.__index = TSetPsusFanMinPWMReq
TSetPsusFanMinPWMReq.group = {}

local function TSetPsusFanMinPWMReq_from_obj(obj)
    return setmetatable(obj, TSetPsusFanMinPWMReq)
end

function TSetPsusFanMinPWMReq.new(FanMinPWM)
    return TSetPsusFanMinPWMReq_from_obj({FanMinPWM = FanMinPWM})
end
---@param obj PowerSupplies.SetPsusFanMinPWMReq
function TSetPsusFanMinPWMReq:init_from_obj(obj)
    self.FanMinPWM = obj.FanMinPWM
end

function TSetPsusFanMinPWMReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPsusFanMinPWMReq.group)
end

TSetPsusFanMinPWMReq.from_obj = TSetPsusFanMinPWMReq_from_obj

TSetPsusFanMinPWMReq.proto_property = {'FanMinPWM'}

TSetPsusFanMinPWMReq.default = {0}

TSetPsusFanMinPWMReq.struct = {{name = 'FanMinPWM', is_array = false, struct = nil}}

function TSetPsusFanMinPWMReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FanMinPWM', self.FanMinPWM, 'uint8', false, errs, need_convert)

    TSetPsusFanMinPWMReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPsusFanMinPWMReq.proto_property, errs, need_convert)
    return self
end

function TSetPsusFanMinPWMReq:unpack(_)
    return self.FanMinPWM
end

PowerSupplies.SetPsusFanMinPWMReq = TSetPsusFanMinPWMReq

PowerSupplies.interface = mdb.register_interface('bmc.kepler.Chassis.PowerSubsystem.PowerSupplies',
    {UpgradeStatus = {'y', {'EMIT_CHANGE'}, true, 0, false}}, {
        SetPsusFanMinPWM = {'a{ss}y', '', TSetPsusFanMinPWMReq, TSetPsusFanMinPWMRsp}
    }, {})

return PowerSupplies
