-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Fans = {}

---@class Fans.EstimatedTotalPowerWatts
---@field EstimatedTotalPowerWatts integer
local TEstimatedTotalPowerWatts = {}
TEstimatedTotalPowerWatts.__index = TEstimatedTotalPowerWatts
TEstimatedTotalPowerWatts.group = {}

local function TEstimatedTotalPowerWatts_from_obj(obj)
    return setmetatable(obj, TEstimatedTotalPowerWatts)
end

function TEstimatedTotalPowerWatts.new(EstimatedTotalPowerWatts)
    return TEstimatedTotalPowerWatts_from_obj({EstimatedTotalPowerWatts = EstimatedTotalPowerWatts})
end
---@param obj Fans.EstimatedTotalPowerWatts
function TEstimatedTotalPowerWatts:init_from_obj(obj)
    self.EstimatedTotalPowerWatts = obj.EstimatedTotalPowerWatts
end

function TEstimatedTotalPowerWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEstimatedTotalPowerWatts.group)
end

TEstimatedTotalPowerWatts.from_obj = TEstimatedTotalPowerWatts_from_obj

TEstimatedTotalPowerWatts.proto_property = {'EstimatedTotalPowerWatts'}

TEstimatedTotalPowerWatts.default = {0}

TEstimatedTotalPowerWatts.struct = {{name = 'EstimatedTotalPowerWatts', is_array = false, struct = nil}}

function TEstimatedTotalPowerWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EstimatedTotalPowerWatts', self.EstimatedTotalPowerWatts, 'uint16', true, errs,
        need_convert)

    TEstimatedTotalPowerWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEstimatedTotalPowerWatts.proto_property, errs, need_convert)
    return self
end

function TEstimatedTotalPowerWatts:unpack(_)
    return self.EstimatedTotalPowerWatts
end

Fans.EstimatedTotalPowerWatts = TEstimatedTotalPowerWatts

---@class Fans.WorkInStandby
---@field WorkInStandby integer
local TWorkInStandby = {}
TWorkInStandby.__index = TWorkInStandby
TWorkInStandby.group = {}

local function TWorkInStandby_from_obj(obj)
    return setmetatable(obj, TWorkInStandby)
end

function TWorkInStandby.new(WorkInStandby)
    return TWorkInStandby_from_obj({WorkInStandby = WorkInStandby})
end
---@param obj Fans.WorkInStandby
function TWorkInStandby:init_from_obj(obj)
    self.WorkInStandby = obj.WorkInStandby
end

function TWorkInStandby:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWorkInStandby.group)
end

TWorkInStandby.from_obj = TWorkInStandby_from_obj

TWorkInStandby.proto_property = {'WorkInStandby'}

TWorkInStandby.default = {0}

TWorkInStandby.struct = {{name = 'WorkInStandby', is_array = false, struct = nil}}

function TWorkInStandby:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WorkInStandby', self.WorkInStandby, 'uint8', true, errs, need_convert)

    TWorkInStandby:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWorkInStandby.proto_property, errs, need_convert)
    return self
end

function TWorkInStandby:unpack(_)
    return self.WorkInStandby
end

Fans.WorkInStandby = TWorkInStandby

---@class Fans.SetPWMRsp
---@field Result integer
local TSetPWMRsp = {}
TSetPWMRsp.__index = TSetPWMRsp
TSetPWMRsp.group = {}

local function TSetPWMRsp_from_obj(obj)
    return setmetatable(obj, TSetPWMRsp)
end

function TSetPWMRsp.new(Result)
    return TSetPWMRsp_from_obj({Result = Result})
end
---@param obj Fans.SetPWMRsp
function TSetPWMRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetPWMRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPWMRsp.group)
end

TSetPWMRsp.from_obj = TSetPWMRsp_from_obj

TSetPWMRsp.proto_property = {'Result'}

TSetPWMRsp.default = {0}

TSetPWMRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetPWMRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'uint8', false, errs, need_convert)

    TSetPWMRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPWMRsp.proto_property, errs, need_convert)
    return self
end

function TSetPWMRsp:unpack(_)
    return self.Result
end

Fans.SetPWMRsp = TSetPWMRsp

---@class Fans.SetPWMReq
---@field PWM number[]
local TSetPWMReq = {}
TSetPWMReq.__index = TSetPWMReq
TSetPWMReq.group = {}

local function TSetPWMReq_from_obj(obj)
    return setmetatable(obj, TSetPWMReq)
end

function TSetPWMReq.new(PWM)
    return TSetPWMReq_from_obj({PWM = PWM})
end
---@param obj Fans.SetPWMReq
function TSetPWMReq:init_from_obj(obj)
    self.PWM = obj.PWM
end

function TSetPWMReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPWMReq.group)
end

TSetPWMReq.from_obj = TSetPWMReq_from_obj

TSetPWMReq.proto_property = {'PWM'}

TSetPWMReq.default = {{}}

TSetPWMReq.struct = {{name = 'PWM', is_array = true, struct = nil}}

function TSetPWMReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PWM', self.PWM, 'double', false, errs, need_convert)

    TSetPWMReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPWMReq.proto_property, errs, need_convert)
    return self
end

function TSetPWMReq:unpack(_)
    return self.PWM
end

Fans.SetPWMReq = TSetPWMReq

Fans.interface = mdb.register_interface('bmc.kepler.Systems.Fans', {
    WorkInStandby = {'y', nil, true, nil, false},
    EstimatedTotalPowerWatts = {'q', {}, true, nil, false}
}, {SetPWM = {'a{ss}ad', 'y', TSetPWMReq, TSetPWMRsp}}, {})

return Fans
