-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Drive = {}

---@class Drive.ContainerPhysicalContext
---@field ContainerPhysicalContext string
local TContainerPhysicalContext = {}
TContainerPhysicalContext.__index = TContainerPhysicalContext
TContainerPhysicalContext.group = {}

local function TContainerPhysicalContext_from_obj(obj)
    return setmetatable(obj, TContainerPhysicalContext)
end

function TContainerPhysicalContext.new(ContainerPhysicalContext)
    return TContainerPhysicalContext_from_obj({ContainerPhysicalContext = ContainerPhysicalContext})
end
---@param obj Drive.ContainerPhysicalContext
function TContainerPhysicalContext:init_from_obj(obj)
    self.ContainerPhysicalContext = obj.ContainerPhysicalContext
end

function TContainerPhysicalContext:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TContainerPhysicalContext.group)
end

TContainerPhysicalContext.from_obj = TContainerPhysicalContext_from_obj

TContainerPhysicalContext.proto_property = {'ContainerPhysicalContext'}

TContainerPhysicalContext.default = {''}

TContainerPhysicalContext.struct = {{name = 'ContainerPhysicalContext', is_array = false, struct = nil}}

function TContainerPhysicalContext:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ContainerPhysicalContext', self.ContainerPhysicalContext, 'string', true, errs,
        need_convert)

    TContainerPhysicalContext:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TContainerPhysicalContext.proto_property, errs, need_convert)
    return self
end

function TContainerPhysicalContext:unpack(_)
    return self.ContainerPhysicalContext
end

Drive.ContainerPhysicalContext = TContainerPhysicalContext

---@class Drive.ResourceId
---@field ResourceId integer
local TResourceId = {}
TResourceId.__index = TResourceId
TResourceId.group = {}

local function TResourceId_from_obj(obj)
    return setmetatable(obj, TResourceId)
end

function TResourceId.new(ResourceId)
    return TResourceId_from_obj({ResourceId = ResourceId})
end
---@param obj Drive.ResourceId
function TResourceId:init_from_obj(obj)
    self.ResourceId = obj.ResourceId
end

function TResourceId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResourceId.group)
end

TResourceId.from_obj = TResourceId_from_obj

TResourceId.proto_property = {'ResourceId'}

TResourceId.default = {0}

TResourceId.struct = {{name = 'ResourceId', is_array = false, struct = nil}}

function TResourceId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResourceId', self.ResourceId, 'uint8', true, errs, need_convert)

    TResourceId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResourceId.proto_property, errs, need_convert)
    return self
end

function TResourceId:unpack(_)
    return self.ResourceId
end

Drive.ResourceId = TResourceId

---@class Drive.DeviceName
---@field DeviceName string
local TDeviceName = {}
TDeviceName.__index = TDeviceName
TDeviceName.group = {}

local function TDeviceName_from_obj(obj)
    return setmetatable(obj, TDeviceName)
end

function TDeviceName.new(DeviceName)
    return TDeviceName_from_obj({DeviceName = DeviceName})
end
---@param obj Drive.DeviceName
function TDeviceName:init_from_obj(obj)
    self.DeviceName = obj.DeviceName
end

function TDeviceName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceName.group)
end

TDeviceName.from_obj = TDeviceName_from_obj

TDeviceName.proto_property = {'DeviceName'}

TDeviceName.default = {''}

TDeviceName.struct = {{name = 'DeviceName', is_array = false, struct = nil}}

function TDeviceName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceName', self.DeviceName, 'string', true, errs, need_convert)

    TDeviceName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceName.proto_property, errs, need_convert)
    return self
end

function TDeviceName:unpack(_)
    return self.DeviceName
end

Drive.DeviceName = TDeviceName

---@class Drive.Location
---@field Location string
local TLocation = {}
TLocation.__index = TLocation
TLocation.group = {}

local function TLocation_from_obj(obj)
    return setmetatable(obj, TLocation)
end

function TLocation.new(Location)
    return TLocation_from_obj({Location = Location})
end
---@param obj Drive.Location
function TLocation:init_from_obj(obj)
    self.Location = obj.Location
end

function TLocation:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocation.group)
end

TLocation.from_obj = TLocation_from_obj

TLocation.proto_property = {'Location'}

TLocation.default = {''}

TLocation.struct = {{name = 'Location', is_array = false, struct = nil}}

function TLocation:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Location', self.Location, 'string', true, errs, need_convert)

    TLocation:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocation.proto_property, errs, need_convert)
    return self
end

function TLocation:unpack(_)
    return self.Location
end

Drive.Location = TLocation

---@class Drive.PCIeLinkSpeed
---@field PCIeLinkSpeed number
local TPCIeLinkSpeed = {}
TPCIeLinkSpeed.__index = TPCIeLinkSpeed
TPCIeLinkSpeed.group = {}

local function TPCIeLinkSpeed_from_obj(obj)
    return setmetatable(obj, TPCIeLinkSpeed)
end

function TPCIeLinkSpeed.new(PCIeLinkSpeed)
    return TPCIeLinkSpeed_from_obj({PCIeLinkSpeed = PCIeLinkSpeed})
end
---@param obj Drive.PCIeLinkSpeed
function TPCIeLinkSpeed:init_from_obj(obj)
    self.PCIeLinkSpeed = obj.PCIeLinkSpeed
end

function TPCIeLinkSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPCIeLinkSpeed.group)
end

TPCIeLinkSpeed.from_obj = TPCIeLinkSpeed_from_obj

TPCIeLinkSpeed.proto_property = {'PCIeLinkSpeed'}

TPCIeLinkSpeed.default = {0}

TPCIeLinkSpeed.struct = {{name = 'PCIeLinkSpeed', is_array = false, struct = nil}}

function TPCIeLinkSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PCIeLinkSpeed', self.PCIeLinkSpeed, 'double', true, errs, need_convert)

    TPCIeLinkSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPCIeLinkSpeed.proto_property, errs, need_convert)
    return self
end

function TPCIeLinkSpeed:unpack(_)
    return self.PCIeLinkSpeed
end

Drive.PCIeLinkSpeed = TPCIeLinkSpeed

---@class Drive.ManufacturerId
---@field ManufacturerId integer
local TManufacturerId = {}
TManufacturerId.__index = TManufacturerId
TManufacturerId.group = {}

local function TManufacturerId_from_obj(obj)
    return setmetatable(obj, TManufacturerId)
end

function TManufacturerId.new(ManufacturerId)
    return TManufacturerId_from_obj({ManufacturerId = ManufacturerId})
end
---@param obj Drive.ManufacturerId
function TManufacturerId:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
end

function TManufacturerId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturerId.group)
end

TManufacturerId.from_obj = TManufacturerId_from_obj

TManufacturerId.proto_property = {'ManufacturerId'}

TManufacturerId.default = {0}

TManufacturerId.struct = {{name = 'ManufacturerId', is_array = false, struct = nil}}

function TManufacturerId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', true, errs, need_convert)

    TManufacturerId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturerId.proto_property, errs, need_convert)
    return self
end

function TManufacturerId:unpack(_)
    return self.ManufacturerId
end

Drive.ManufacturerId = TManufacturerId

---@class Drive.RefDiskArrayId
---@field RefDiskArrayId integer
local TRefDiskArrayId = {}
TRefDiskArrayId.__index = TRefDiskArrayId
TRefDiskArrayId.group = {}

local function TRefDiskArrayId_from_obj(obj)
    return setmetatable(obj, TRefDiskArrayId)
end

function TRefDiskArrayId.new(RefDiskArrayId)
    return TRefDiskArrayId_from_obj({RefDiskArrayId = RefDiskArrayId})
end
---@param obj Drive.RefDiskArrayId
function TRefDiskArrayId:init_from_obj(obj)
    self.RefDiskArrayId = obj.RefDiskArrayId
end

function TRefDiskArrayId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefDiskArrayId.group)
end

TRefDiskArrayId.from_obj = TRefDiskArrayId_from_obj

TRefDiskArrayId.proto_property = {'RefDiskArrayId'}

TRefDiskArrayId.default = {0}

TRefDiskArrayId.struct = {{name = 'RefDiskArrayId', is_array = false, struct = nil}}

function TRefDiskArrayId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RefDiskArrayId', self.RefDiskArrayId, 'uint16', true, errs, need_convert)

    TRefDiskArrayId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefDiskArrayId.proto_property, errs, need_convert)
    return self
end

function TRefDiskArrayId:unpack(_)
    return self.RefDiskArrayId
end

Drive.RefDiskArrayId = TRefDiskArrayId

---@class Drive.RefVolumeList
---@field RefVolumeList integer[]
local TRefVolumeList = {}
TRefVolumeList.__index = TRefVolumeList
TRefVolumeList.group = {}

local function TRefVolumeList_from_obj(obj)
    return setmetatable(obj, TRefVolumeList)
end

function TRefVolumeList.new(RefVolumeList)
    return TRefVolumeList_from_obj({RefVolumeList = RefVolumeList})
end
---@param obj Drive.RefVolumeList
function TRefVolumeList:init_from_obj(obj)
    self.RefVolumeList = obj.RefVolumeList
end

function TRefVolumeList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefVolumeList.group)
end

TRefVolumeList.from_obj = TRefVolumeList_from_obj

TRefVolumeList.proto_property = {'RefVolumeList'}

TRefVolumeList.default = {{}}

TRefVolumeList.struct = {{name = 'RefVolumeList', is_array = true, struct = nil}}

function TRefVolumeList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefVolumeList', self.RefVolumeList, 'uint16', true, errs, need_convert)

    TRefVolumeList:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefVolumeList.proto_property, errs, need_convert)
    return self
end

function TRefVolumeList:unpack(_)
    return self.RefVolumeList
end

Drive.RefVolumeList = TRefVolumeList

---@class Drive.RefControllerId
---@field RefControllerId integer
local TRefControllerId = {}
TRefControllerId.__index = TRefControllerId
TRefControllerId.group = {}

local function TRefControllerId_from_obj(obj)
    return setmetatable(obj, TRefControllerId)
end

function TRefControllerId.new(RefControllerId)
    return TRefControllerId_from_obj({RefControllerId = RefControllerId})
end
---@param obj Drive.RefControllerId
function TRefControllerId:init_from_obj(obj)
    self.RefControllerId = obj.RefControllerId
end

function TRefControllerId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefControllerId.group)
end

TRefControllerId.from_obj = TRefControllerId_from_obj

TRefControllerId.proto_property = {'RefControllerId'}

TRefControllerId.default = {0}

TRefControllerId.struct = {{name = 'RefControllerId', is_array = false, struct = nil}}

function TRefControllerId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RefControllerId', self.RefControllerId, 'uint8', true, errs, need_convert)

    TRefControllerId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefControllerId.proto_property, errs, need_convert)
    return self
end

function TRefControllerId:unpack(_)
    return self.RefControllerId
end

Drive.RefControllerId = TRefControllerId

---@class Drive.HotspareType
---@field HotspareType integer
local THotspareType = {}
THotspareType.__index = THotspareType
THotspareType.group = {}

local function THotspareType_from_obj(obj)
    return setmetatable(obj, THotspareType)
end

function THotspareType.new(HotspareType)
    return THotspareType_from_obj({HotspareType = HotspareType})
end
---@param obj Drive.HotspareType
function THotspareType:init_from_obj(obj)
    self.HotspareType = obj.HotspareType
end

function THotspareType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THotspareType.group)
end

THotspareType.from_obj = THotspareType_from_obj

THotspareType.proto_property = {'HotspareType'}

THotspareType.default = {0}

THotspareType.struct = {{name = 'HotspareType', is_array = false, struct = nil}}

function THotspareType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HotspareType', self.HotspareType, 'uint8', true, errs, need_convert)

    THotspareType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THotspareType.proto_property, errs, need_convert)
    return self
end

function THotspareType:unpack(_)
    return self.HotspareType
end

Drive.HotspareType = THotspareType

---@class Drive.BootPriority
---@field BootPriority integer
local TBootPriority = {}
TBootPriority.__index = TBootPriority
TBootPriority.group = {}

local function TBootPriority_from_obj(obj)
    return setmetatable(obj, TBootPriority)
end

function TBootPriority.new(BootPriority)
    return TBootPriority_from_obj({BootPriority = BootPriority})
end
---@param obj Drive.BootPriority
function TBootPriority:init_from_obj(obj)
    self.BootPriority = obj.BootPriority
end

function TBootPriority:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootPriority.group)
end

TBootPriority.from_obj = TBootPriority_from_obj

TBootPriority.proto_property = {'BootPriority'}

TBootPriority.default = {0}

TBootPriority.struct = {{name = 'BootPriority', is_array = false, struct = nil}}

function TBootPriority:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootPriority', self.BootPriority, 'uint8', true, errs, need_convert)

    TBootPriority:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootPriority.proto_property, errs, need_convert)
    return self
end

function TBootPriority:unpack(_)
    return self.BootPriority
end

Drive.BootPriority = TBootPriority

---@class Drive.RebuildProgress
---@field RebuildProgress integer
local TRebuildProgress = {}
TRebuildProgress.__index = TRebuildProgress
TRebuildProgress.group = {}

local function TRebuildProgress_from_obj(obj)
    return setmetatable(obj, TRebuildProgress)
end

function TRebuildProgress.new(RebuildProgress)
    return TRebuildProgress_from_obj({RebuildProgress = RebuildProgress})
end
---@param obj Drive.RebuildProgress
function TRebuildProgress:init_from_obj(obj)
    self.RebuildProgress = obj.RebuildProgress
end

function TRebuildProgress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRebuildProgress.group)
end

TRebuildProgress.from_obj = TRebuildProgress_from_obj

TRebuildProgress.proto_property = {'RebuildProgress'}

TRebuildProgress.default = {0}

TRebuildProgress.struct = {{name = 'RebuildProgress', is_array = false, struct = nil}}

function TRebuildProgress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RebuildProgress', self.RebuildProgress, 'uint8', true, errs, need_convert)

    TRebuildProgress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRebuildProgress.proto_property, errs, need_convert)
    return self
end

function TRebuildProgress:unpack(_)
    return self.RebuildProgress
end

Drive.RebuildProgress = TRebuildProgress

---@class Drive.RebuildState
---@field RebuildState integer
local TRebuildState = {}
TRebuildState.__index = TRebuildState
TRebuildState.group = {}

local function TRebuildState_from_obj(obj)
    return setmetatable(obj, TRebuildState)
end

function TRebuildState.new(RebuildState)
    return TRebuildState_from_obj({RebuildState = RebuildState})
end
---@param obj Drive.RebuildState
function TRebuildState:init_from_obj(obj)
    self.RebuildState = obj.RebuildState
end

function TRebuildState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRebuildState.group)
end

TRebuildState.from_obj = TRebuildState_from_obj

TRebuildState.proto_property = {'RebuildState'}

TRebuildState.default = {0}

TRebuildState.struct = {{name = 'RebuildState', is_array = false, struct = nil}}

function TRebuildState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RebuildState', self.RebuildState, 'uint8', true, errs, need_convert)

    TRebuildState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRebuildState.proto_property, errs, need_convert)
    return self
end

function TRebuildState:unpack(_)
    return self.RebuildState
end

Drive.RebuildState = TRebuildState

---@class Drive.PowerState
---@field PowerState integer
local TPowerState = {}
TPowerState.__index = TPowerState
TPowerState.group = {}

local function TPowerState_from_obj(obj)
    return setmetatable(obj, TPowerState)
end

function TPowerState.new(PowerState)
    return TPowerState_from_obj({PowerState = PowerState})
end
---@param obj Drive.PowerState
function TPowerState:init_from_obj(obj)
    self.PowerState = obj.PowerState
end

function TPowerState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerState.group)
end

TPowerState.from_obj = TPowerState_from_obj

TPowerState.proto_property = {'PowerState'}

TPowerState.default = {0}

TPowerState.struct = {{name = 'PowerState', is_array = false, struct = nil}}

function TPowerState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerState', self.PowerState, 'uint8', true, errs, need_convert)

    TPowerState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerState.proto_property, errs, need_convert)
    return self
end

function TPowerState:unpack(_)
    return self.PowerState
end

Drive.PowerState = TPowerState

---@class Drive.PatrolState
---@field PatrolState integer
local TPatrolState = {}
TPatrolState.__index = TPatrolState
TPatrolState.group = {}

local function TPatrolState_from_obj(obj)
    return setmetatable(obj, TPatrolState)
end

function TPatrolState.new(PatrolState)
    return TPatrolState_from_obj({PatrolState = PatrolState})
end
---@param obj Drive.PatrolState
function TPatrolState:init_from_obj(obj)
    self.PatrolState = obj.PatrolState
end

function TPatrolState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPatrolState.group)
end

TPatrolState.from_obj = TPatrolState_from_obj

TPatrolState.proto_property = {'PatrolState'}

TPatrolState.default = {0}

TPatrolState.struct = {{name = 'PatrolState', is_array = false, struct = nil}}

function TPatrolState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PatrolState', self.PatrolState, 'uint8', true, errs, need_convert)

    TPatrolState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPatrolState.proto_property, errs, need_convert)
    return self
end

function TPatrolState:unpack(_)
    return self.PatrolState
end

Drive.PatrolState = TPatrolState

---@class Drive.OtherErrorCount
---@field OtherErrorCount integer
local TOtherErrorCount = {}
TOtherErrorCount.__index = TOtherErrorCount
TOtherErrorCount.group = {}

local function TOtherErrorCount_from_obj(obj)
    return setmetatable(obj, TOtherErrorCount)
end

function TOtherErrorCount.new(OtherErrorCount)
    return TOtherErrorCount_from_obj({OtherErrorCount = OtherErrorCount})
end
---@param obj Drive.OtherErrorCount
function TOtherErrorCount:init_from_obj(obj)
    self.OtherErrorCount = obj.OtherErrorCount
end

function TOtherErrorCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOtherErrorCount.group)
end

TOtherErrorCount.from_obj = TOtherErrorCount_from_obj

TOtherErrorCount.proto_property = {'OtherErrorCount'}

TOtherErrorCount.default = {0}

TOtherErrorCount.struct = {{name = 'OtherErrorCount', is_array = false, struct = nil}}

function TOtherErrorCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OtherErrorCount', self.OtherErrorCount, 'uint32', true, errs, need_convert)

    TOtherErrorCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOtherErrorCount.proto_property, errs, need_convert)
    return self
end

function TOtherErrorCount:unpack(_)
    return self.OtherErrorCount
end

Drive.OtherErrorCount = TOtherErrorCount

---@class Drive.MediaErrorCount
---@field MediaErrorCount integer
local TMediaErrorCount = {}
TMediaErrorCount.__index = TMediaErrorCount
TMediaErrorCount.group = {}

local function TMediaErrorCount_from_obj(obj)
    return setmetatable(obj, TMediaErrorCount)
end

function TMediaErrorCount.new(MediaErrorCount)
    return TMediaErrorCount_from_obj({MediaErrorCount = MediaErrorCount})
end
---@param obj Drive.MediaErrorCount
function TMediaErrorCount:init_from_obj(obj)
    self.MediaErrorCount = obj.MediaErrorCount
end

function TMediaErrorCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMediaErrorCount.group)
end

TMediaErrorCount.from_obj = TMediaErrorCount_from_obj

TMediaErrorCount.proto_property = {'MediaErrorCount'}

TMediaErrorCount.default = {0}

TMediaErrorCount.struct = {{name = 'MediaErrorCount', is_array = false, struct = nil}}

function TMediaErrorCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MediaErrorCount', self.MediaErrorCount, 'uint32', true, errs, need_convert)

    TMediaErrorCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMediaErrorCount.proto_property, errs, need_convert)
    return self
end

function TMediaErrorCount:unpack(_)
    return self.MediaErrorCount
end

Drive.MediaErrorCount = TMediaErrorCount

---@class Drive.PredictedFailCount
---@field PredictedFailCount integer
local TPredictedFailCount = {}
TPredictedFailCount.__index = TPredictedFailCount
TPredictedFailCount.group = {}

local function TPredictedFailCount_from_obj(obj)
    return setmetatable(obj, TPredictedFailCount)
end

function TPredictedFailCount.new(PredictedFailCount)
    return TPredictedFailCount_from_obj({PredictedFailCount = PredictedFailCount})
end
---@param obj Drive.PredictedFailCount
function TPredictedFailCount:init_from_obj(obj)
    self.PredictedFailCount = obj.PredictedFailCount
end

function TPredictedFailCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPredictedFailCount.group)
end

TPredictedFailCount.from_obj = TPredictedFailCount_from_obj

TPredictedFailCount.proto_property = {'PredictedFailCount'}

TPredictedFailCount.default = {0}

TPredictedFailCount.struct = {{name = 'PredictedFailCount', is_array = false, struct = nil}}

function TPredictedFailCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PredictedFailCount', self.PredictedFailCount, 'uint32', true, errs, need_convert)

    TPredictedFailCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPredictedFailCount.proto_property, errs, need_convert)
    return self
end

function TPredictedFailCount:unpack(_)
    return self.PredictedFailCount
end

Drive.PredictedFailCount = TPredictedFailCount

---@class Drive.PredictedMediaLifeLeftPercent
---@field PredictedMediaLifeLeftPercent integer
local TPredictedMediaLifeLeftPercent = {}
TPredictedMediaLifeLeftPercent.__index = TPredictedMediaLifeLeftPercent
TPredictedMediaLifeLeftPercent.group = {}

local function TPredictedMediaLifeLeftPercent_from_obj(obj)
    return setmetatable(obj, TPredictedMediaLifeLeftPercent)
end

function TPredictedMediaLifeLeftPercent.new(PredictedMediaLifeLeftPercent)
    return TPredictedMediaLifeLeftPercent_from_obj({PredictedMediaLifeLeftPercent = PredictedMediaLifeLeftPercent})
end
---@param obj Drive.PredictedMediaLifeLeftPercent
function TPredictedMediaLifeLeftPercent:init_from_obj(obj)
    self.PredictedMediaLifeLeftPercent = obj.PredictedMediaLifeLeftPercent
end

function TPredictedMediaLifeLeftPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPredictedMediaLifeLeftPercent.group)
end

TPredictedMediaLifeLeftPercent.from_obj = TPredictedMediaLifeLeftPercent_from_obj

TPredictedMediaLifeLeftPercent.proto_property = {'PredictedMediaLifeLeftPercent'}

TPredictedMediaLifeLeftPercent.default = {0}

TPredictedMediaLifeLeftPercent.struct = {{name = 'PredictedMediaLifeLeftPercent', is_array = false, struct = nil}}

function TPredictedMediaLifeLeftPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PredictedMediaLifeLeftPercent', self.PredictedMediaLifeLeftPercent, 'uint8', true,
        errs, need_convert)

    TPredictedMediaLifeLeftPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPredictedMediaLifeLeftPercent.proto_property, errs, need_convert)
    return self
end

function TPredictedMediaLifeLeftPercent:unpack(_)
    return self.PredictedMediaLifeLeftPercent
end

Drive.PredictedMediaLifeLeftPercent = TPredictedMediaLifeLeftPercent

---@class Drive.SASAddress2
---@field SASAddress2 string
local TSASAddress2 = {}
TSASAddress2.__index = TSASAddress2
TSASAddress2.group = {}

local function TSASAddress2_from_obj(obj)
    return setmetatable(obj, TSASAddress2)
end

function TSASAddress2.new(SASAddress2)
    return TSASAddress2_from_obj({SASAddress2 = SASAddress2})
end
---@param obj Drive.SASAddress2
function TSASAddress2:init_from_obj(obj)
    self.SASAddress2 = obj.SASAddress2
end

function TSASAddress2:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSASAddress2.group)
end

TSASAddress2.from_obj = TSASAddress2_from_obj

TSASAddress2.proto_property = {'SASAddress2'}

TSASAddress2.default = {''}

TSASAddress2.struct = {{name = 'SASAddress2', is_array = false, struct = nil}}

function TSASAddress2:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SASAddress2', self.SASAddress2, 'string', true, errs, need_convert)

    TSASAddress2:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSASAddress2.proto_property, errs, need_convert)
    return self
end

function TSASAddress2:unpack(_)
    return self.SASAddress2
end

Drive.SASAddress2 = TSASAddress2

---@class Drive.SASAddress1
---@field SASAddress1 string
local TSASAddress1 = {}
TSASAddress1.__index = TSASAddress1
TSASAddress1.group = {}

local function TSASAddress1_from_obj(obj)
    return setmetatable(obj, TSASAddress1)
end

function TSASAddress1.new(SASAddress1)
    return TSASAddress1_from_obj({SASAddress1 = SASAddress1})
end
---@param obj Drive.SASAddress1
function TSASAddress1:init_from_obj(obj)
    self.SASAddress1 = obj.SASAddress1
end

function TSASAddress1:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSASAddress1.group)
end

TSASAddress1.from_obj = TSASAddress1_from_obj

TSASAddress1.proto_property = {'SASAddress1'}

TSASAddress1.default = {''}

TSASAddress1.struct = {{name = 'SASAddress1', is_array = false, struct = nil}}

function TSASAddress1:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SASAddress1', self.SASAddress1, 'string', true, errs, need_convert)

    TSASAddress1:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSASAddress1.proto_property, errs, need_convert)
    return self
end

function TSASAddress1:unpack(_)
    return self.SASAddress1
end

Drive.SASAddress1 = TSASAddress1

---@class Drive.BlockSizeBytes
---@field BlockSizeBytes integer
local TBlockSizeBytes = {}
TBlockSizeBytes.__index = TBlockSizeBytes
TBlockSizeBytes.group = {}

local function TBlockSizeBytes_from_obj(obj)
    return setmetatable(obj, TBlockSizeBytes)
end

function TBlockSizeBytes.new(BlockSizeBytes)
    return TBlockSizeBytes_from_obj({BlockSizeBytes = BlockSizeBytes})
end
---@param obj Drive.BlockSizeBytes
function TBlockSizeBytes:init_from_obj(obj)
    self.BlockSizeBytes = obj.BlockSizeBytes
end

function TBlockSizeBytes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBlockSizeBytes.group)
end

TBlockSizeBytes.from_obj = TBlockSizeBytes_from_obj

TBlockSizeBytes.proto_property = {'BlockSizeBytes'}

TBlockSizeBytes.default = {0}

TBlockSizeBytes.struct = {{name = 'BlockSizeBytes', is_array = false, struct = nil}}

function TBlockSizeBytes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BlockSizeBytes', self.BlockSizeBytes, 'uint16', true, errs, need_convert)

    TBlockSizeBytes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBlockSizeBytes.proto_property, errs, need_convert)
    return self
end

function TBlockSizeBytes:unpack(_)
    return self.BlockSizeBytes
end

Drive.BlockSizeBytes = TBlockSizeBytes

---@class Drive.RotationSpeedRPM
---@field RotationSpeedRPM integer
local TRotationSpeedRPM = {}
TRotationSpeedRPM.__index = TRotationSpeedRPM
TRotationSpeedRPM.group = {}

local function TRotationSpeedRPM_from_obj(obj)
    return setmetatable(obj, TRotationSpeedRPM)
end

function TRotationSpeedRPM.new(RotationSpeedRPM)
    return TRotationSpeedRPM_from_obj({RotationSpeedRPM = RotationSpeedRPM})
end
---@param obj Drive.RotationSpeedRPM
function TRotationSpeedRPM:init_from_obj(obj)
    self.RotationSpeedRPM = obj.RotationSpeedRPM
end

function TRotationSpeedRPM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRotationSpeedRPM.group)
end

TRotationSpeedRPM.from_obj = TRotationSpeedRPM_from_obj

TRotationSpeedRPM.proto_property = {'RotationSpeedRPM'}

TRotationSpeedRPM.default = {0}

TRotationSpeedRPM.struct = {{name = 'RotationSpeedRPM', is_array = false, struct = nil}}

function TRotationSpeedRPM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RotationSpeedRPM', self.RotationSpeedRPM, 'uint16', true, errs, need_convert)

    TRotationSpeedRPM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRotationSpeedRPM.proto_property, errs, need_convert)
    return self
end

function TRotationSpeedRPM:unpack(_)
    return self.RotationSpeedRPM
end

Drive.RotationSpeedRPM = TRotationSpeedRPM

---@class Drive.Revision
---@field Revision string
local TRevision = {}
TRevision.__index = TRevision
TRevision.group = {}

local function TRevision_from_obj(obj)
    return setmetatable(obj, TRevision)
end

function TRevision.new(Revision)
    return TRevision_from_obj({Revision = Revision})
end
---@param obj Drive.Revision
function TRevision:init_from_obj(obj)
    self.Revision = obj.Revision
end

function TRevision:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRevision.group)
end

TRevision.from_obj = TRevision_from_obj

TRevision.proto_property = {'Revision'}

TRevision.default = {''}

TRevision.struct = {{name = 'Revision', is_array = false, struct = nil}}

function TRevision:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Revision', self.Revision, 'string', true, errs, need_convert)

    TRevision:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRevision.proto_property, errs, need_convert)
    return self
end

function TRevision:unpack(_)
    return self.Revision
end

Drive.Revision = TRevision

---@class Drive.PowerOnHours
---@field PowerOnHours number
local TPowerOnHours = {}
TPowerOnHours.__index = TPowerOnHours
TPowerOnHours.group = {}

local function TPowerOnHours_from_obj(obj)
    return setmetatable(obj, TPowerOnHours)
end

function TPowerOnHours.new(PowerOnHours)
    return TPowerOnHours_from_obj({PowerOnHours = PowerOnHours})
end
---@param obj Drive.PowerOnHours
function TPowerOnHours:init_from_obj(obj)
    self.PowerOnHours = obj.PowerOnHours
end

function TPowerOnHours:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerOnHours.group)
end

TPowerOnHours.from_obj = TPowerOnHours_from_obj

TPowerOnHours.proto_property = {'PowerOnHours'}

TPowerOnHours.default = {0}

TPowerOnHours.struct = {{name = 'PowerOnHours', is_array = false, struct = nil}}

function TPowerOnHours:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerOnHours', self.PowerOnHours, 'double', true, errs, need_convert)

    TPowerOnHours:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerOnHours.proto_property, errs, need_convert)
    return self
end

function TPowerOnHours:unpack(_)
    return self.PowerOnHours
end

Drive.PowerOnHours = TPowerOnHours

---@class Drive.Manufacturer
---@field Manufacturer string
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer})
end
---@param obj Drive.Manufacturer
function TManufacturer:init_from_obj(obj)
    self.Manufacturer = obj.Manufacturer
end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {''}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'string', true, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs, need_convert)
    return self
end

function TManufacturer:unpack(_)
    return self.Manufacturer
end

Drive.Manufacturer = TManufacturer

---@class Drive.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj Drive.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', true, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

Drive.SerialNumber = TSerialNumber

---@class Drive.FirmwareStatus
---@field FirmwareStatus integer
local TFirmwareStatus = {}
TFirmwareStatus.__index = TFirmwareStatus
TFirmwareStatus.group = {}

local function TFirmwareStatus_from_obj(obj)
    return setmetatable(obj, TFirmwareStatus)
end

function TFirmwareStatus.new(FirmwareStatus)
    return TFirmwareStatus_from_obj({FirmwareStatus = FirmwareStatus})
end
---@param obj Drive.FirmwareStatus
function TFirmwareStatus:init_from_obj(obj)
    self.FirmwareStatus = obj.FirmwareStatus
end

function TFirmwareStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareStatus.group)
end

TFirmwareStatus.from_obj = TFirmwareStatus_from_obj

TFirmwareStatus.proto_property = {'FirmwareStatus'}

TFirmwareStatus.default = {0}

TFirmwareStatus.struct = {{name = 'FirmwareStatus', is_array = false, struct = nil}}

function TFirmwareStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareStatus', self.FirmwareStatus, 'uint8', true, errs, need_convert)

    TFirmwareStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareStatus.proto_property, errs, need_convert)
    return self
end

function TFirmwareStatus:unpack(_)
    return self.FirmwareStatus
end

Drive.FirmwareStatus = TFirmwareStatus

---@class Drive.MediaType
---@field MediaType integer
local TMediaType = {}
TMediaType.__index = TMediaType
TMediaType.group = {}

local function TMediaType_from_obj(obj)
    return setmetatable(obj, TMediaType)
end

function TMediaType.new(MediaType)
    return TMediaType_from_obj({MediaType = MediaType})
end
---@param obj Drive.MediaType
function TMediaType:init_from_obj(obj)
    self.MediaType = obj.MediaType
end

function TMediaType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMediaType.group)
end

TMediaType.from_obj = TMediaType_from_obj

TMediaType.proto_property = {'MediaType'}

TMediaType.default = {0}

TMediaType.struct = {{name = 'MediaType', is_array = false, struct = nil}}

function TMediaType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MediaType', self.MediaType, 'uint8', true, errs, need_convert)

    TMediaType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMediaType.proto_property, errs, need_convert)
    return self
end

function TMediaType:unpack(_)
    return self.MediaType
end

Drive.MediaType = TMediaType

---@class Drive.NegotiatedSpeedGbs
---@field NegotiatedSpeedGbs integer
local TNegotiatedSpeedGbs = {}
TNegotiatedSpeedGbs.__index = TNegotiatedSpeedGbs
TNegotiatedSpeedGbs.group = {}

local function TNegotiatedSpeedGbs_from_obj(obj)
    return setmetatable(obj, TNegotiatedSpeedGbs)
end

function TNegotiatedSpeedGbs.new(NegotiatedSpeedGbs)
    return TNegotiatedSpeedGbs_from_obj({NegotiatedSpeedGbs = NegotiatedSpeedGbs})
end
---@param obj Drive.NegotiatedSpeedGbs
function TNegotiatedSpeedGbs:init_from_obj(obj)
    self.NegotiatedSpeedGbs = obj.NegotiatedSpeedGbs
end

function TNegotiatedSpeedGbs:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNegotiatedSpeedGbs.group)
end

TNegotiatedSpeedGbs.from_obj = TNegotiatedSpeedGbs_from_obj

TNegotiatedSpeedGbs.proto_property = {'NegotiatedSpeedGbs'}

TNegotiatedSpeedGbs.default = {0}

TNegotiatedSpeedGbs.struct = {{name = 'NegotiatedSpeedGbs', is_array = false, struct = nil}}

function TNegotiatedSpeedGbs:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NegotiatedSpeedGbs', self.NegotiatedSpeedGbs, 'uint8', true, errs, need_convert)

    TNegotiatedSpeedGbs:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNegotiatedSpeedGbs.proto_property, errs, need_convert)
    return self
end

function TNegotiatedSpeedGbs:unpack(_)
    return self.NegotiatedSpeedGbs
end

Drive.NegotiatedSpeedGbs = TNegotiatedSpeedGbs

---@class Drive.CapableSpeedGbs
---@field CapableSpeedGbs integer
local TCapableSpeedGbs = {}
TCapableSpeedGbs.__index = TCapableSpeedGbs
TCapableSpeedGbs.group = {}

local function TCapableSpeedGbs_from_obj(obj)
    return setmetatable(obj, TCapableSpeedGbs)
end

function TCapableSpeedGbs.new(CapableSpeedGbs)
    return TCapableSpeedGbs_from_obj({CapableSpeedGbs = CapableSpeedGbs})
end
---@param obj Drive.CapableSpeedGbs
function TCapableSpeedGbs:init_from_obj(obj)
    self.CapableSpeedGbs = obj.CapableSpeedGbs
end

function TCapableSpeedGbs:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCapableSpeedGbs.group)
end

TCapableSpeedGbs.from_obj = TCapableSpeedGbs_from_obj

TCapableSpeedGbs.proto_property = {'CapableSpeedGbs'}

TCapableSpeedGbs.default = {0}

TCapableSpeedGbs.struct = {{name = 'CapableSpeedGbs', is_array = false, struct = nil}}

function TCapableSpeedGbs:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CapableSpeedGbs', self.CapableSpeedGbs, 'uint8', true, errs, need_convert)

    TCapableSpeedGbs:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCapableSpeedGbs.proto_property, errs, need_convert)
    return self
end

function TCapableSpeedGbs:unpack(_)
    return self.CapableSpeedGbs
end

Drive.CapableSpeedGbs = TCapableSpeedGbs

---@class Drive.Protocol
---@field Protocol integer
local TProtocol = {}
TProtocol.__index = TProtocol
TProtocol.group = {}

local function TProtocol_from_obj(obj)
    return setmetatable(obj, TProtocol)
end

function TProtocol.new(Protocol)
    return TProtocol_from_obj({Protocol = Protocol})
end
---@param obj Drive.Protocol
function TProtocol:init_from_obj(obj)
    self.Protocol = obj.Protocol
end

function TProtocol:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProtocol.group)
end

TProtocol.from_obj = TProtocol_from_obj

TProtocol.proto_property = {'Protocol'}

TProtocol.default = {0}

TProtocol.struct = {{name = 'Protocol', is_array = false, struct = nil}}

function TProtocol:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Protocol', self.Protocol, 'uint8', true, errs, need_convert)

    TProtocol:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProtocol.proto_property, errs, need_convert)
    return self
end

function TProtocol:unpack(_)
    return self.Protocol
end

Drive.Protocol = TProtocol

---@class Drive.FaultLed
---@field FaultLed integer
local TFaultLed = {}
TFaultLed.__index = TFaultLed
TFaultLed.group = {}

local function TFaultLed_from_obj(obj)
    return setmetatable(obj, TFaultLed)
end

function TFaultLed.new(FaultLed)
    return TFaultLed_from_obj({FaultLed = FaultLed})
end
---@param obj Drive.FaultLed
function TFaultLed:init_from_obj(obj)
    self.FaultLed = obj.FaultLed
end

function TFaultLed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFaultLed.group)
end

TFaultLed.from_obj = TFaultLed_from_obj

TFaultLed.proto_property = {'FaultLed'}

TFaultLed.default = {0}

TFaultLed.struct = {{name = 'FaultLed', is_array = false, struct = nil}}

function TFaultLed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FaultLed', self.FaultLed, 'uint8', true, errs, need_convert)

    TFaultLed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFaultLed.proto_property, errs, need_convert)
    return self
end

function TFaultLed:unpack(_)
    return self.FaultLed
end

Drive.FaultLed = TFaultLed

---@class Drive.LocateLed
---@field LocateLed integer
local TLocateLed = {}
TLocateLed.__index = TLocateLed
TLocateLed.group = {}

local function TLocateLed_from_obj(obj)
    return setmetatable(obj, TLocateLed)
end

function TLocateLed.new(LocateLed)
    return TLocateLed_from_obj({LocateLed = LocateLed})
end
---@param obj Drive.LocateLed
function TLocateLed:init_from_obj(obj)
    self.LocateLed = obj.LocateLed
end

function TLocateLed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocateLed.group)
end

TLocateLed.from_obj = TLocateLed_from_obj

TLocateLed.proto_property = {'LocateLed'}

TLocateLed.default = {0}

TLocateLed.struct = {{name = 'LocateLed', is_array = false, struct = nil}}

function TLocateLed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LocateLed', self.LocateLed, 'uint8', true, errs, need_convert)

    TLocateLed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocateLed.proto_property, errs, need_convert)
    return self
end

function TLocateLed:unpack(_)
    return self.LocateLed
end

Drive.LocateLed = TLocateLed

---@class Drive.LocationIndicatorState
---@field LocationIndicatorState integer
local TLocationIndicatorState = {}
TLocationIndicatorState.__index = TLocationIndicatorState
TLocationIndicatorState.group = {}

local function TLocationIndicatorState_from_obj(obj)
    return setmetatable(obj, TLocationIndicatorState)
end

function TLocationIndicatorState.new(LocationIndicatorState)
    return TLocationIndicatorState_from_obj({LocationIndicatorState = LocationIndicatorState})
end
---@param obj Drive.LocationIndicatorState
function TLocationIndicatorState:init_from_obj(obj)
    self.LocationIndicatorState = obj.LocationIndicatorState
end

function TLocationIndicatorState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocationIndicatorState.group)
end

TLocationIndicatorState.from_obj = TLocationIndicatorState_from_obj

TLocationIndicatorState.proto_property = {'LocationIndicatorState'}

TLocationIndicatorState.default = {0}

TLocationIndicatorState.struct = {{name = 'LocationIndicatorState', is_array = false, struct = nil}}

function TLocationIndicatorState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LocationIndicatorState', self.LocationIndicatorState, 'uint8', true, errs, need_convert)

    TLocationIndicatorState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocationIndicatorState.proto_property, errs, need_convert)
    return self
end

function TLocationIndicatorState:unpack(_)
    return self.LocationIndicatorState
end

Drive.LocationIndicatorState = TLocationIndicatorState

---@class Drive.EnclosureId
---@field EnclosureId integer
local TEnclosureId = {}
TEnclosureId.__index = TEnclosureId
TEnclosureId.group = {}

local function TEnclosureId_from_obj(obj)
    return setmetatable(obj, TEnclosureId)
end

function TEnclosureId.new(EnclosureId)
    return TEnclosureId_from_obj({EnclosureId = EnclosureId})
end
---@param obj Drive.EnclosureId
function TEnclosureId:init_from_obj(obj)
    self.EnclosureId = obj.EnclosureId
end

function TEnclosureId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnclosureId.group)
end

TEnclosureId.from_obj = TEnclosureId_from_obj

TEnclosureId.proto_property = {'EnclosureId'}

TEnclosureId.default = {0}

TEnclosureId.struct = {{name = 'EnclosureId', is_array = false, struct = nil}}

function TEnclosureId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EnclosureId', self.EnclosureId, 'uint16', true, errs, need_convert)

    TEnclosureId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnclosureId.proto_property, errs, need_convert)
    return self
end

function TEnclosureId:unpack(_)
    return self.EnclosureId
end

Drive.EnclosureId = TEnclosureId

---@class Drive.Model
---@field Model string
local TModel = {}
TModel.__index = TModel
TModel.group = {}

local function TModel_from_obj(obj)
    return setmetatable(obj, TModel)
end

function TModel.new(Model)
    return TModel_from_obj({Model = Model})
end
---@param obj Drive.Model
function TModel:init_from_obj(obj)
    self.Model = obj.Model
end

function TModel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModel.group)
end

TModel.from_obj = TModel_from_obj

TModel.proto_property = {'Model'}

TModel.default = {''}

TModel.struct = {{name = 'Model', is_array = false, struct = nil}}

function TModel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Model', self.Model, 'string', true, errs, need_convert)

    TModel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModel.proto_property, errs, need_convert)
    return self
end

function TModel:unpack(_)
    return self.Model
end

Drive.Model = TModel

---@class Drive.TemperatureCelsius
---@field TemperatureCelsius integer
local TTemperatureCelsius = {}
TTemperatureCelsius.__index = TTemperatureCelsius
TTemperatureCelsius.group = {}

local function TTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TTemperatureCelsius)
end

function TTemperatureCelsius.new(TemperatureCelsius)
    return TTemperatureCelsius_from_obj({TemperatureCelsius = TemperatureCelsius})
end
---@param obj Drive.TemperatureCelsius
function TTemperatureCelsius:init_from_obj(obj)
    self.TemperatureCelsius = obj.TemperatureCelsius
end

function TTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureCelsius.group)
end

TTemperatureCelsius.from_obj = TTemperatureCelsius_from_obj

TTemperatureCelsius.proto_property = {'TemperatureCelsius'}

TTemperatureCelsius.default = {0}

TTemperatureCelsius.struct = {{name = 'TemperatureCelsius', is_array = false, struct = nil}}

function TTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureCelsius', self.TemperatureCelsius, 'int16', true, errs, need_convert)

    TTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TTemperatureCelsius:unpack(_)
    return self.TemperatureCelsius
end

Drive.TemperatureCelsius = TTemperatureCelsius

---@class Drive.CapacityMiB
---@field CapacityMiB integer
local TCapacityMiB = {}
TCapacityMiB.__index = TCapacityMiB
TCapacityMiB.group = {}

local function TCapacityMiB_from_obj(obj)
    return setmetatable(obj, TCapacityMiB)
end

function TCapacityMiB.new(CapacityMiB)
    return TCapacityMiB_from_obj({CapacityMiB = CapacityMiB})
end
---@param obj Drive.CapacityMiB
function TCapacityMiB:init_from_obj(obj)
    self.CapacityMiB = obj.CapacityMiB
end

function TCapacityMiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCapacityMiB.group)
end

TCapacityMiB.from_obj = TCapacityMiB_from_obj

TCapacityMiB.proto_property = {'CapacityMiB'}

TCapacityMiB.default = {0}

TCapacityMiB.struct = {{name = 'CapacityMiB', is_array = false, struct = nil}}

function TCapacityMiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CapacityMiB', self.CapacityMiB, 'uint32', true, errs, need_convert)

    TCapacityMiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCapacityMiB.proto_property, errs, need_convert)
    return self
end

function TCapacityMiB:unpack(_)
    return self.CapacityMiB
end

Drive.CapacityMiB = TCapacityMiB

---@class Drive.Presence
---@field Presence integer
local TPresence = {}
TPresence.__index = TPresence
TPresence.group = {}

local function TPresence_from_obj(obj)
    return setmetatable(obj, TPresence)
end

function TPresence.new(Presence)
    return TPresence_from_obj({Presence = Presence})
end
---@param obj Drive.Presence
function TPresence:init_from_obj(obj)
    self.Presence = obj.Presence
end

function TPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresence.group)
end

TPresence.from_obj = TPresence_from_obj

TPresence.proto_property = {'Presence'}

TPresence.default = {0}

TPresence.struct = {{name = 'Presence', is_array = false, struct = nil}}

function TPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Presence', self.Presence, 'uint8', true, errs, need_convert)

    TPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresence.proto_property, errs, need_convert)
    return self
end

function TPresence:unpack(_)
    return self.Presence
end

Drive.Presence = TPresence

---@class Drive.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj Drive.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', true, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

Drive.Name = TName

---@class Drive.SlotNumber
---@field SlotNumber integer
local TSlotNumber = {}
TSlotNumber.__index = TSlotNumber
TSlotNumber.group = {}

local function TSlotNumber_from_obj(obj)
    return setmetatable(obj, TSlotNumber)
end

function TSlotNumber.new(SlotNumber)
    return TSlotNumber_from_obj({SlotNumber = SlotNumber})
end
---@param obj Drive.SlotNumber
function TSlotNumber:init_from_obj(obj)
    self.SlotNumber = obj.SlotNumber
end

function TSlotNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotNumber.group)
end

TSlotNumber.from_obj = TSlotNumber_from_obj

TSlotNumber.proto_property = {'SlotNumber'}

TSlotNumber.default = {0}

TSlotNumber.struct = {{name = 'SlotNumber', is_array = false, struct = nil}}

function TSlotNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotNumber', self.SlotNumber, 'uint8', true, errs, need_convert)

    TSlotNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotNumber.proto_property, errs, need_convert)
    return self
end

function TSlotNumber:unpack(_)
    return self.SlotNumber
end

Drive.SlotNumber = TSlotNumber

---@class Drive.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj Drive.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'uint8', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

Drive.Id = TId

---@class Drive.NodeId
---@field NodeId string
local TNodeId = {}
TNodeId.__index = TNodeId
TNodeId.group = {}

local function TNodeId_from_obj(obj)
    return setmetatable(obj, TNodeId)
end

function TNodeId.new(NodeId)
    return TNodeId_from_obj({NodeId = NodeId})
end
---@param obj Drive.NodeId
function TNodeId:init_from_obj(obj)
    self.NodeId = obj.NodeId
end

function TNodeId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNodeId.group)
end

TNodeId.from_obj = TNodeId_from_obj

TNodeId.proto_property = {'NodeId'}

TNodeId.default = {''}

TNodeId.struct = {{name = 'NodeId', is_array = false, struct = nil}}

function TNodeId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NodeId', self.NodeId, 'string', true, errs, need_convert)

    TNodeId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNodeId.proto_property, errs, need_convert)
    return self
end

function TNodeId:unpack(_)
    return self.NodeId
end

Drive.NodeId = TNodeId

---@class Drive.CryptoEraseRsp
local TCryptoEraseRsp = {}
TCryptoEraseRsp.__index = TCryptoEraseRsp
TCryptoEraseRsp.group = {}

local function TCryptoEraseRsp_from_obj(obj)
    return setmetatable(obj, TCryptoEraseRsp)
end

function TCryptoEraseRsp.new()
    return TCryptoEraseRsp_from_obj({})
end
---@param obj Drive.CryptoEraseRsp
function TCryptoEraseRsp:init_from_obj(obj)

end

function TCryptoEraseRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCryptoEraseRsp.group)
end

TCryptoEraseRsp.from_obj = TCryptoEraseRsp_from_obj

TCryptoEraseRsp.proto_property = {}

TCryptoEraseRsp.default = {}

TCryptoEraseRsp.struct = {}

function TCryptoEraseRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCryptoEraseRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCryptoEraseRsp.proto_property, errs, need_convert)
    return self
end

function TCryptoEraseRsp:unpack(_)
end

Drive.CryptoEraseRsp = TCryptoEraseRsp

---@class Drive.CryptoEraseReq
local TCryptoEraseReq = {}
TCryptoEraseReq.__index = TCryptoEraseReq
TCryptoEraseReq.group = {}

local function TCryptoEraseReq_from_obj(obj)
    return setmetatable(obj, TCryptoEraseReq)
end

function TCryptoEraseReq.new()
    return TCryptoEraseReq_from_obj({})
end
---@param obj Drive.CryptoEraseReq
function TCryptoEraseReq:init_from_obj(obj)

end

function TCryptoEraseReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCryptoEraseReq.group)
end

TCryptoEraseReq.from_obj = TCryptoEraseReq_from_obj

TCryptoEraseReq.proto_property = {}

TCryptoEraseReq.default = {}

TCryptoEraseReq.struct = {}

function TCryptoEraseReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCryptoEraseReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCryptoEraseReq.proto_property, errs, need_convert)
    return self
end

function TCryptoEraseReq:unpack(_)
end

Drive.CryptoEraseReq = TCryptoEraseReq

---@class Drive.SetPatrolStateRsp
local TSetPatrolStateRsp = {}
TSetPatrolStateRsp.__index = TSetPatrolStateRsp
TSetPatrolStateRsp.group = {}

local function TSetPatrolStateRsp_from_obj(obj)
    return setmetatable(obj, TSetPatrolStateRsp)
end

function TSetPatrolStateRsp.new()
    return TSetPatrolStateRsp_from_obj({})
end
---@param obj Drive.SetPatrolStateRsp
function TSetPatrolStateRsp:init_from_obj(obj)

end

function TSetPatrolStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPatrolStateRsp.group)
end

TSetPatrolStateRsp.from_obj = TSetPatrolStateRsp_from_obj

TSetPatrolStateRsp.proto_property = {}

TSetPatrolStateRsp.default = {}

TSetPatrolStateRsp.struct = {}

function TSetPatrolStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetPatrolStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPatrolStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetPatrolStateRsp:unpack(_)
end

Drive.SetPatrolStateRsp = TSetPatrolStateRsp

---@class Drive.SetPatrolStateReq
---@field PatrolState integer
local TSetPatrolStateReq = {}
TSetPatrolStateReq.__index = TSetPatrolStateReq
TSetPatrolStateReq.group = {}

local function TSetPatrolStateReq_from_obj(obj)
    return setmetatable(obj, TSetPatrolStateReq)
end

function TSetPatrolStateReq.new(PatrolState)
    return TSetPatrolStateReq_from_obj({PatrolState = PatrolState})
end
---@param obj Drive.SetPatrolStateReq
function TSetPatrolStateReq:init_from_obj(obj)
    self.PatrolState = obj.PatrolState
end

function TSetPatrolStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPatrolStateReq.group)
end

TSetPatrolStateReq.from_obj = TSetPatrolStateReq_from_obj

TSetPatrolStateReq.proto_property = {'PatrolState'}

TSetPatrolStateReq.default = {0}

TSetPatrolStateReq.struct = {{name = 'PatrolState', is_array = false, struct = nil}}

function TSetPatrolStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PatrolState', self.PatrolState, 'uint8', false, errs, need_convert)

    TSetPatrolStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPatrolStateReq.proto_property, errs, need_convert)
    return self
end

function TSetPatrolStateReq:unpack(_)
    return self.PatrolState
end

Drive.SetPatrolStateReq = TSetPatrolStateReq

---@class Drive.SetBootPriorityRsp
local TSetBootPriorityRsp = {}
TSetBootPriorityRsp.__index = TSetBootPriorityRsp
TSetBootPriorityRsp.group = {}

local function TSetBootPriorityRsp_from_obj(obj)
    return setmetatable(obj, TSetBootPriorityRsp)
end

function TSetBootPriorityRsp.new()
    return TSetBootPriorityRsp_from_obj({})
end
---@param obj Drive.SetBootPriorityRsp
function TSetBootPriorityRsp:init_from_obj(obj)

end

function TSetBootPriorityRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootPriorityRsp.group)
end

TSetBootPriorityRsp.from_obj = TSetBootPriorityRsp_from_obj

TSetBootPriorityRsp.proto_property = {}

TSetBootPriorityRsp.default = {}

TSetBootPriorityRsp.struct = {}

function TSetBootPriorityRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBootPriorityRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootPriorityRsp.proto_property, errs, need_convert)
    return self
end

function TSetBootPriorityRsp:unpack(_)
end

Drive.SetBootPriorityRsp = TSetBootPriorityRsp

---@class Drive.SetBootPriorityReq
---@field BootPriority integer
local TSetBootPriorityReq = {}
TSetBootPriorityReq.__index = TSetBootPriorityReq
TSetBootPriorityReq.group = {}

local function TSetBootPriorityReq_from_obj(obj)
    return setmetatable(obj, TSetBootPriorityReq)
end

function TSetBootPriorityReq.new(BootPriority)
    return TSetBootPriorityReq_from_obj({BootPriority = BootPriority})
end
---@param obj Drive.SetBootPriorityReq
function TSetBootPriorityReq:init_from_obj(obj)
    self.BootPriority = obj.BootPriority
end

function TSetBootPriorityReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootPriorityReq.group)
end

TSetBootPriorityReq.from_obj = TSetBootPriorityReq_from_obj

TSetBootPriorityReq.proto_property = {'BootPriority'}

TSetBootPriorityReq.default = {0}

TSetBootPriorityReq.struct = {{name = 'BootPriority', is_array = false, struct = nil}}

function TSetBootPriorityReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootPriority', self.BootPriority, 'uint8', false, errs, need_convert)

    TSetBootPriorityReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootPriorityReq.proto_property, errs, need_convert)
    return self
end

function TSetBootPriorityReq:unpack(_)
    return self.BootPriority
end

Drive.SetBootPriorityReq = TSetBootPriorityReq

---@class Drive.SetHotspareTypeRsp
local TSetHotspareTypeRsp = {}
TSetHotspareTypeRsp.__index = TSetHotspareTypeRsp
TSetHotspareTypeRsp.group = {}

local function TSetHotspareTypeRsp_from_obj(obj)
    return setmetatable(obj, TSetHotspareTypeRsp)
end

function TSetHotspareTypeRsp.new()
    return TSetHotspareTypeRsp_from_obj({})
end
---@param obj Drive.SetHotspareTypeRsp
function TSetHotspareTypeRsp:init_from_obj(obj)

end

function TSetHotspareTypeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetHotspareTypeRsp.group)
end

TSetHotspareTypeRsp.from_obj = TSetHotspareTypeRsp_from_obj

TSetHotspareTypeRsp.proto_property = {}

TSetHotspareTypeRsp.default = {}

TSetHotspareTypeRsp.struct = {}

function TSetHotspareTypeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetHotspareTypeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetHotspareTypeRsp.proto_property, errs, need_convert)
    return self
end

function TSetHotspareTypeRsp:unpack(_)
end

Drive.SetHotspareTypeRsp = TSetHotspareTypeRsp

---@class Drive.SetHotspareTypeReq
---@field HotspareType integer
---@field VolumeId integer
local TSetHotspareTypeReq = {}
TSetHotspareTypeReq.__index = TSetHotspareTypeReq
TSetHotspareTypeReq.group = {}

local function TSetHotspareTypeReq_from_obj(obj)
    return setmetatable(obj, TSetHotspareTypeReq)
end

function TSetHotspareTypeReq.new(HotspareType, VolumeId)
    return TSetHotspareTypeReq_from_obj({HotspareType = HotspareType, VolumeId = VolumeId})
end
---@param obj Drive.SetHotspareTypeReq
function TSetHotspareTypeReq:init_from_obj(obj)
    self.HotspareType = obj.HotspareType
    self.VolumeId = obj.VolumeId
end

function TSetHotspareTypeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetHotspareTypeReq.group)
end

TSetHotspareTypeReq.from_obj = TSetHotspareTypeReq_from_obj

TSetHotspareTypeReq.proto_property = {'HotspareType', 'VolumeId'}

TSetHotspareTypeReq.default = {0, 0}

TSetHotspareTypeReq.struct = {
    {name = 'HotspareType', is_array = false, struct = nil}, {name = 'VolumeId', is_array = false, struct = nil}
}

function TSetHotspareTypeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HotspareType', self.HotspareType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'VolumeId', self.VolumeId, 'uint16', false, errs, need_convert)

    TSetHotspareTypeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetHotspareTypeReq.proto_property, errs, need_convert)
    return self
end

function TSetHotspareTypeReq:unpack(_)
    return self.HotspareType, self.VolumeId
end

Drive.SetHotspareTypeReq = TSetHotspareTypeReq

---@class Drive.SetFirmwareStatusRsp
local TSetFirmwareStatusRsp = {}
TSetFirmwareStatusRsp.__index = TSetFirmwareStatusRsp
TSetFirmwareStatusRsp.group = {}

local function TSetFirmwareStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetFirmwareStatusRsp)
end

function TSetFirmwareStatusRsp.new()
    return TSetFirmwareStatusRsp_from_obj({})
end
---@param obj Drive.SetFirmwareStatusRsp
function TSetFirmwareStatusRsp:init_from_obj(obj)

end

function TSetFirmwareStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFirmwareStatusRsp.group)
end

TSetFirmwareStatusRsp.from_obj = TSetFirmwareStatusRsp_from_obj

TSetFirmwareStatusRsp.proto_property = {}

TSetFirmwareStatusRsp.default = {}

TSetFirmwareStatusRsp.struct = {}

function TSetFirmwareStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetFirmwareStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFirmwareStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetFirmwareStatusRsp:unpack(_)
end

Drive.SetFirmwareStatusRsp = TSetFirmwareStatusRsp

---@class Drive.SetFirmwareStatusReq
---@field FirmwareStatus integer
local TSetFirmwareStatusReq = {}
TSetFirmwareStatusReq.__index = TSetFirmwareStatusReq
TSetFirmwareStatusReq.group = {}

local function TSetFirmwareStatusReq_from_obj(obj)
    return setmetatable(obj, TSetFirmwareStatusReq)
end

function TSetFirmwareStatusReq.new(FirmwareStatus)
    return TSetFirmwareStatusReq_from_obj({FirmwareStatus = FirmwareStatus})
end
---@param obj Drive.SetFirmwareStatusReq
function TSetFirmwareStatusReq:init_from_obj(obj)
    self.FirmwareStatus = obj.FirmwareStatus
end

function TSetFirmwareStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFirmwareStatusReq.group)
end

TSetFirmwareStatusReq.from_obj = TSetFirmwareStatusReq_from_obj

TSetFirmwareStatusReq.proto_property = {'FirmwareStatus'}

TSetFirmwareStatusReq.default = {0}

TSetFirmwareStatusReq.struct = {{name = 'FirmwareStatus', is_array = false, struct = nil}}

function TSetFirmwareStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareStatus', self.FirmwareStatus, 'uint8', false, errs, need_convert)

    TSetFirmwareStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFirmwareStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetFirmwareStatusReq:unpack(_)
    return self.FirmwareStatus
end

Drive.SetFirmwareStatusReq = TSetFirmwareStatusReq

---@class Drive.SetFaultIndicatorStateRsp
local TSetFaultIndicatorStateRsp = {}
TSetFaultIndicatorStateRsp.__index = TSetFaultIndicatorStateRsp
TSetFaultIndicatorStateRsp.group = {}

local function TSetFaultIndicatorStateRsp_from_obj(obj)
    return setmetatable(obj, TSetFaultIndicatorStateRsp)
end

function TSetFaultIndicatorStateRsp.new()
    return TSetFaultIndicatorStateRsp_from_obj({})
end
---@param obj Drive.SetFaultIndicatorStateRsp
function TSetFaultIndicatorStateRsp:init_from_obj(obj)

end

function TSetFaultIndicatorStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFaultIndicatorStateRsp.group)
end

TSetFaultIndicatorStateRsp.from_obj = TSetFaultIndicatorStateRsp_from_obj

TSetFaultIndicatorStateRsp.proto_property = {}

TSetFaultIndicatorStateRsp.default = {}

TSetFaultIndicatorStateRsp.struct = {}

function TSetFaultIndicatorStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetFaultIndicatorStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFaultIndicatorStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetFaultIndicatorStateRsp:unpack(_)
end

Drive.SetFaultIndicatorStateRsp = TSetFaultIndicatorStateRsp

---@class Drive.SetFaultIndicatorStateReq
---@field FaultIndicatorState integer
local TSetFaultIndicatorStateReq = {}
TSetFaultIndicatorStateReq.__index = TSetFaultIndicatorStateReq
TSetFaultIndicatorStateReq.group = {}

local function TSetFaultIndicatorStateReq_from_obj(obj)
    return setmetatable(obj, TSetFaultIndicatorStateReq)
end

function TSetFaultIndicatorStateReq.new(FaultIndicatorState)
    return TSetFaultIndicatorStateReq_from_obj({FaultIndicatorState = FaultIndicatorState})
end
---@param obj Drive.SetFaultIndicatorStateReq
function TSetFaultIndicatorStateReq:init_from_obj(obj)
    self.FaultIndicatorState = obj.FaultIndicatorState
end

function TSetFaultIndicatorStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFaultIndicatorStateReq.group)
end

TSetFaultIndicatorStateReq.from_obj = TSetFaultIndicatorStateReq_from_obj

TSetFaultIndicatorStateReq.proto_property = {'FaultIndicatorState'}

TSetFaultIndicatorStateReq.default = {0}

TSetFaultIndicatorStateReq.struct = {{name = 'FaultIndicatorState', is_array = false, struct = nil}}

function TSetFaultIndicatorStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FaultIndicatorState', self.FaultIndicatorState, 'uint8', false, errs, need_convert)

    TSetFaultIndicatorStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFaultIndicatorStateReq.proto_property, errs, need_convert)
    return self
end

function TSetFaultIndicatorStateReq:unpack(_)
    return self.FaultIndicatorState
end

Drive.SetFaultIndicatorStateReq = TSetFaultIndicatorStateReq

---@class Drive.SetLocationIndicatorStateRsp
local TSetLocationIndicatorStateRsp = {}
TSetLocationIndicatorStateRsp.__index = TSetLocationIndicatorStateRsp
TSetLocationIndicatorStateRsp.group = {}

local function TSetLocationIndicatorStateRsp_from_obj(obj)
    return setmetatable(obj, TSetLocationIndicatorStateRsp)
end

function TSetLocationIndicatorStateRsp.new()
    return TSetLocationIndicatorStateRsp_from_obj({})
end
---@param obj Drive.SetLocationIndicatorStateRsp
function TSetLocationIndicatorStateRsp:init_from_obj(obj)

end

function TSetLocationIndicatorStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLocationIndicatorStateRsp.group)
end

TSetLocationIndicatorStateRsp.from_obj = TSetLocationIndicatorStateRsp_from_obj

TSetLocationIndicatorStateRsp.proto_property = {}

TSetLocationIndicatorStateRsp.default = {}

TSetLocationIndicatorStateRsp.struct = {}

function TSetLocationIndicatorStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetLocationIndicatorStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLocationIndicatorStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetLocationIndicatorStateRsp:unpack(_)
end

Drive.SetLocationIndicatorStateRsp = TSetLocationIndicatorStateRsp

---@class Drive.SetLocationIndicatorStateReq
---@field LocationIndicatorState integer
local TSetLocationIndicatorStateReq = {}
TSetLocationIndicatorStateReq.__index = TSetLocationIndicatorStateReq
TSetLocationIndicatorStateReq.group = {}

local function TSetLocationIndicatorStateReq_from_obj(obj)
    return setmetatable(obj, TSetLocationIndicatorStateReq)
end

function TSetLocationIndicatorStateReq.new(LocationIndicatorState)
    return TSetLocationIndicatorStateReq_from_obj({LocationIndicatorState = LocationIndicatorState})
end
---@param obj Drive.SetLocationIndicatorStateReq
function TSetLocationIndicatorStateReq:init_from_obj(obj)
    self.LocationIndicatorState = obj.LocationIndicatorState
end

function TSetLocationIndicatorStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLocationIndicatorStateReq.group)
end

TSetLocationIndicatorStateReq.from_obj = TSetLocationIndicatorStateReq_from_obj

TSetLocationIndicatorStateReq.proto_property = {'LocationIndicatorState'}

TSetLocationIndicatorStateReq.default = {0}

TSetLocationIndicatorStateReq.struct = {{name = 'LocationIndicatorState', is_array = false, struct = nil}}

function TSetLocationIndicatorStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LocationIndicatorState', self.LocationIndicatorState, 'uint8', false, errs,
        need_convert)

    TSetLocationIndicatorStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLocationIndicatorStateReq.proto_property, errs, need_convert)
    return self
end

function TSetLocationIndicatorStateReq:unpack(_)
    return self.LocationIndicatorState
end

Drive.SetLocationIndicatorStateReq = TSetLocationIndicatorStateReq

Drive.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Drive', {
    NodeId = {'s', nil, true, nil, false},
    Id = {'y', nil, true, nil, false},
    SlotNumber = {'y', nil, true, nil, false},
    Name = {'s', nil, true, nil, false},
    Presence = {'y', nil, true, nil, false},
    CapacityMiB = {'u', nil, true, nil, false},
    TemperatureCelsius = {'n', {'VOLATILE'}, true, nil, false},
    Model = {'s', nil, true, nil, false},
    EnclosureId = {'q', nil, true, nil, false},
    LocationIndicatorState = {'y', nil, true, nil, false},
    LocateLed = {'y', nil, true, nil, false},
    FaultLed = {'y', nil, true, nil, false},
    Protocol = {'y', nil, true, nil, false},
    CapableSpeedGbs = {'y', nil, true, nil, false},
    NegotiatedSpeedGbs = {'y', nil, true, nil, false},
    MediaType = {'y', nil, true, nil, false},
    FirmwareStatus = {'y', nil, true, nil, false},
    SerialNumber = {'s', nil, true, nil, false},
    Manufacturer = {'s', nil, true, nil, false},
    PowerOnHours = {'d', {'VOLATILE'}, true, nil, false},
    Revision = {'s', nil, true, nil, false},
    RotationSpeedRPM = {'q', nil, true, nil, false},
    BlockSizeBytes = {'q', nil, true, nil, false},
    SASAddress1 = {'s', nil, true, nil, false},
    SASAddress2 = {'s', nil, true, nil, false},
    PredictedMediaLifeLeftPercent = {'y', nil, true, nil, false},
    PredictedFailCount = {'u', nil, true, nil, false},
    MediaErrorCount = {'u', nil, true, nil, false},
    OtherErrorCount = {'u', nil, true, nil, false},
    PatrolState = {'y', nil, true, nil, false},
    PowerState = {'y', nil, true, nil, false},
    RebuildState = {'y', nil, true, nil, false},
    RebuildProgress = {'y', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    BootPriority = {'y', nil, true, nil, false},
    HotspareType = {'y', nil, true, nil, false},
    RefControllerId = {'y', nil, true, nil, false},
    RefVolumeList = {'aq', nil, true, nil, false},
    RefDiskArrayId = {'q', nil, true, nil, false},
    ManufacturerId = {'u', nil, true, nil, false},
    PCIeLinkSpeed = {'d', nil, true, nil, false},
    Location = {'s', {}, true, nil, false},
    DeviceName = {'s', {}, true, nil, false},
    ResourceId = {'y', nil, true, nil, false},
    ContainerPhysicalContext = {'s', {}, true, nil, false}
}, {
    SetLocationIndicatorState = {'a{ss}y', '', TSetLocationIndicatorStateReq, TSetLocationIndicatorStateRsp},
    SetFaultIndicatorState = {'a{ss}y', '', TSetFaultIndicatorStateReq, TSetFaultIndicatorStateRsp},
    SetFirmwareStatus = {'a{ss}y', '', TSetFirmwareStatusReq, TSetFirmwareStatusRsp},
    SetHotspareType = {'a{ss}yq', '', TSetHotspareTypeReq, TSetHotspareTypeRsp},
    SetBootPriority = {'a{ss}y', '', TSetBootPriorityReq, TSetBootPriorityRsp},
    SetPatrolState = {'a{ss}y', '', TSetPatrolStateReq, TSetPatrolStateRsp},
    CryptoErase = {'a{ss}', '', TCryptoEraseReq, TCryptoEraseRsp}
}, {})

return Drive
