-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local DiskCoolingConfig = {}

---@class DiskCoolingConfig.RearHddMaxTemperatureCelsius
---@field RearHddMaxTemperatureCelsius number
local TRearHddMaxTemperatureCelsius = {}
TRearHddMaxTemperatureCelsius.__index = TRearHddMaxTemperatureCelsius
TRearHddMaxTemperatureCelsius.group = {}

local function TRearHddMaxTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TRearHddMaxTemperatureCelsius)
end

function TRearHddMaxTemperatureCelsius.new(RearHddMaxTemperatureCelsius)
    return
        TRearHddMaxTemperatureCelsius_from_obj({RearHddMaxTemperatureCelsius = RearHddMaxTemperatureCelsius or 32768})
end
---@param obj DiskCoolingConfig.RearHddMaxTemperatureCelsius
function TRearHddMaxTemperatureCelsius:init_from_obj(obj)
    self.RearHddMaxTemperatureCelsius = obj.RearHddMaxTemperatureCelsius or 32768
end

function TRearHddMaxTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearHddMaxTemperatureCelsius.group)
end

TRearHddMaxTemperatureCelsius.from_obj = TRearHddMaxTemperatureCelsius_from_obj

TRearHddMaxTemperatureCelsius.proto_property = {'RearHddMaxTemperatureCelsius'}

TRearHddMaxTemperatureCelsius.default = {0}

TRearHddMaxTemperatureCelsius.struct = {{name = 'RearHddMaxTemperatureCelsius', is_array = false, struct = nil}}

function TRearHddMaxTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RearHddMaxTemperatureCelsius', self.RearHddMaxTemperatureCelsius, 'double', true, errs,
        need_convert)

    TRearHddMaxTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearHddMaxTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TRearHddMaxTemperatureCelsius:unpack(_)
    return self.RearHddMaxTemperatureCelsius
end

DiskCoolingConfig.RearHddMaxTemperatureCelsius = TRearHddMaxTemperatureCelsius

---@class DiskCoolingConfig.RearNVMeSSDMaxTemperatureCelsius
---@field RearNVMeSSDMaxTemperatureCelsius number
local TRearNVMeSSDMaxTemperatureCelsius = {}
TRearNVMeSSDMaxTemperatureCelsius.__index = TRearNVMeSSDMaxTemperatureCelsius
TRearNVMeSSDMaxTemperatureCelsius.group = {}

local function TRearNVMeSSDMaxTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TRearNVMeSSDMaxTemperatureCelsius)
end

function TRearNVMeSSDMaxTemperatureCelsius.new(RearNVMeSSDMaxTemperatureCelsius)
    return TRearNVMeSSDMaxTemperatureCelsius_from_obj({
        RearNVMeSSDMaxTemperatureCelsius = RearNVMeSSDMaxTemperatureCelsius or 32768
    })
end
---@param obj DiskCoolingConfig.RearNVMeSSDMaxTemperatureCelsius
function TRearNVMeSSDMaxTemperatureCelsius:init_from_obj(obj)
    self.RearNVMeSSDMaxTemperatureCelsius = obj.RearNVMeSSDMaxTemperatureCelsius or 32768
end

function TRearNVMeSSDMaxTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearNVMeSSDMaxTemperatureCelsius.group)
end

TRearNVMeSSDMaxTemperatureCelsius.from_obj = TRearNVMeSSDMaxTemperatureCelsius_from_obj

TRearNVMeSSDMaxTemperatureCelsius.proto_property = {'RearNVMeSSDMaxTemperatureCelsius'}

TRearNVMeSSDMaxTemperatureCelsius.default = {0}

TRearNVMeSSDMaxTemperatureCelsius.struct = {{name = 'RearNVMeSSDMaxTemperatureCelsius', is_array = false, struct = nil}}

function TRearNVMeSSDMaxTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RearNVMeSSDMaxTemperatureCelsius', self.RearNVMeSSDMaxTemperatureCelsius, 'double',
        true, errs, need_convert)

    TRearNVMeSSDMaxTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearNVMeSSDMaxTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TRearNVMeSSDMaxTemperatureCelsius:unpack(_)
    return self.RearNVMeSSDMaxTemperatureCelsius
end

DiskCoolingConfig.RearNVMeSSDMaxTemperatureCelsius = TRearNVMeSSDMaxTemperatureCelsius

---@class DiskCoolingConfig.FrontHddMaxTemperatureCelsius
---@field FrontHddMaxTemperatureCelsius number
local TFrontHddMaxTemperatureCelsius = {}
TFrontHddMaxTemperatureCelsius.__index = TFrontHddMaxTemperatureCelsius
TFrontHddMaxTemperatureCelsius.group = {}

local function TFrontHddMaxTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TFrontHddMaxTemperatureCelsius)
end

function TFrontHddMaxTemperatureCelsius.new(FrontHddMaxTemperatureCelsius)
    return TFrontHddMaxTemperatureCelsius_from_obj({
        FrontHddMaxTemperatureCelsius = FrontHddMaxTemperatureCelsius or 32768
    })
end
---@param obj DiskCoolingConfig.FrontHddMaxTemperatureCelsius
function TFrontHddMaxTemperatureCelsius:init_from_obj(obj)
    self.FrontHddMaxTemperatureCelsius = obj.FrontHddMaxTemperatureCelsius or 32768
end

function TFrontHddMaxTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFrontHddMaxTemperatureCelsius.group)
end

TFrontHddMaxTemperatureCelsius.from_obj = TFrontHddMaxTemperatureCelsius_from_obj

TFrontHddMaxTemperatureCelsius.proto_property = {'FrontHddMaxTemperatureCelsius'}

TFrontHddMaxTemperatureCelsius.default = {0}

TFrontHddMaxTemperatureCelsius.struct = {{name = 'FrontHddMaxTemperatureCelsius', is_array = false, struct = nil}}

function TFrontHddMaxTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FrontHddMaxTemperatureCelsius', self.FrontHddMaxTemperatureCelsius, 'double', true,
        errs, need_convert)

    TFrontHddMaxTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFrontHddMaxTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TFrontHddMaxTemperatureCelsius:unpack(_)
    return self.FrontHddMaxTemperatureCelsius
end

DiskCoolingConfig.FrontHddMaxTemperatureCelsius = TFrontHddMaxTemperatureCelsius

---@class DiskCoolingConfig.FrontNVMeSSDMaxTemperatureCelsius
---@field FrontNVMeSSDMaxTemperatureCelsius number
local TFrontNVMeSSDMaxTemperatureCelsius = {}
TFrontNVMeSSDMaxTemperatureCelsius.__index = TFrontNVMeSSDMaxTemperatureCelsius
TFrontNVMeSSDMaxTemperatureCelsius.group = {}

local function TFrontNVMeSSDMaxTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TFrontNVMeSSDMaxTemperatureCelsius)
end

function TFrontNVMeSSDMaxTemperatureCelsius.new(FrontNVMeSSDMaxTemperatureCelsius)
    return TFrontNVMeSSDMaxTemperatureCelsius_from_obj({
        FrontNVMeSSDMaxTemperatureCelsius = FrontNVMeSSDMaxTemperatureCelsius or 32768
    })
end
---@param obj DiskCoolingConfig.FrontNVMeSSDMaxTemperatureCelsius
function TFrontNVMeSSDMaxTemperatureCelsius:init_from_obj(obj)
    self.FrontNVMeSSDMaxTemperatureCelsius = obj.FrontNVMeSSDMaxTemperatureCelsius or 32768
end

function TFrontNVMeSSDMaxTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFrontNVMeSSDMaxTemperatureCelsius.group)
end

TFrontNVMeSSDMaxTemperatureCelsius.from_obj = TFrontNVMeSSDMaxTemperatureCelsius_from_obj

TFrontNVMeSSDMaxTemperatureCelsius.proto_property = {'FrontNVMeSSDMaxTemperatureCelsius'}

TFrontNVMeSSDMaxTemperatureCelsius.default = {0}

TFrontNVMeSSDMaxTemperatureCelsius.struct = {
    {name = 'FrontNVMeSSDMaxTemperatureCelsius', is_array = false, struct = nil}
}

function TFrontNVMeSSDMaxTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FrontNVMeSSDMaxTemperatureCelsius', self.FrontNVMeSSDMaxTemperatureCelsius, 'double',
        true, errs, need_convert)

    TFrontNVMeSSDMaxTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFrontNVMeSSDMaxTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TFrontNVMeSSDMaxTemperatureCelsius:unpack(_)
    return self.FrontNVMeSSDMaxTemperatureCelsius
end

DiskCoolingConfig.FrontNVMeSSDMaxTemperatureCelsius = TFrontNVMeSSDMaxTemperatureCelsius

---@class DiskCoolingConfig.SysAllSSDsMaxTemperature
---@field SysAllSSDsMaxTemperature number
local TSysAllSSDsMaxTemperature = {}
TSysAllSSDsMaxTemperature.__index = TSysAllSSDsMaxTemperature
TSysAllSSDsMaxTemperature.group = {}

local function TSysAllSSDsMaxTemperature_from_obj(obj)
    return setmetatable(obj, TSysAllSSDsMaxTemperature)
end

function TSysAllSSDsMaxTemperature.new(SysAllSSDsMaxTemperature)
    return TSysAllSSDsMaxTemperature_from_obj({SysAllSSDsMaxTemperature = SysAllSSDsMaxTemperature or 32768})
end
---@param obj DiskCoolingConfig.SysAllSSDsMaxTemperature
function TSysAllSSDsMaxTemperature:init_from_obj(obj)
    self.SysAllSSDsMaxTemperature = obj.SysAllSSDsMaxTemperature or 32768
end

function TSysAllSSDsMaxTemperature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSysAllSSDsMaxTemperature.group)
end

TSysAllSSDsMaxTemperature.from_obj = TSysAllSSDsMaxTemperature_from_obj

TSysAllSSDsMaxTemperature.proto_property = {'SysAllSSDsMaxTemperature'}

TSysAllSSDsMaxTemperature.default = {0}

TSysAllSSDsMaxTemperature.struct = {{name = 'SysAllSSDsMaxTemperature', is_array = false, struct = nil}}

function TSysAllSSDsMaxTemperature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SysAllSSDsMaxTemperature', self.SysAllSSDsMaxTemperature, 'double', true, errs,
        need_convert)

    TSysAllSSDsMaxTemperature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSysAllSSDsMaxTemperature.proto_property, errs, need_convert)
    return self
end

function TSysAllSSDsMaxTemperature:unpack(_)
    return self.SysAllSSDsMaxTemperature
end

DiskCoolingConfig.SysAllSSDsMaxTemperature = TSysAllSSDsMaxTemperature

---@class DiskCoolingConfig.SysM2sMaxTemperature
---@field SysM2sMaxTemperature number
local TSysM2sMaxTemperature = {}
TSysM2sMaxTemperature.__index = TSysM2sMaxTemperature
TSysM2sMaxTemperature.group = {}

local function TSysM2sMaxTemperature_from_obj(obj)
    return setmetatable(obj, TSysM2sMaxTemperature)
end

function TSysM2sMaxTemperature.new(SysM2sMaxTemperature)
    return TSysM2sMaxTemperature_from_obj({SysM2sMaxTemperature = SysM2sMaxTemperature or 32768})
end
---@param obj DiskCoolingConfig.SysM2sMaxTemperature
function TSysM2sMaxTemperature:init_from_obj(obj)
    self.SysM2sMaxTemperature = obj.SysM2sMaxTemperature or 32768
end

function TSysM2sMaxTemperature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSysM2sMaxTemperature.group)
end

TSysM2sMaxTemperature.from_obj = TSysM2sMaxTemperature_from_obj

TSysM2sMaxTemperature.proto_property = {'SysM2sMaxTemperature'}

TSysM2sMaxTemperature.default = {0}

TSysM2sMaxTemperature.struct = {{name = 'SysM2sMaxTemperature', is_array = false, struct = nil}}

function TSysM2sMaxTemperature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SysM2sMaxTemperature', self.SysM2sMaxTemperature, 'double', true, errs, need_convert)

    TSysM2sMaxTemperature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSysM2sMaxTemperature.proto_property, errs, need_convert)
    return self
end

function TSysM2sMaxTemperature:unpack(_)
    return self.SysM2sMaxTemperature
end

DiskCoolingConfig.SysM2sMaxTemperature = TSysM2sMaxTemperature

---@class DiskCoolingConfig.SysSSDsMaxTemperature
---@field SysSSDsMaxTemperature number
local TSysSSDsMaxTemperature = {}
TSysSSDsMaxTemperature.__index = TSysSSDsMaxTemperature
TSysSSDsMaxTemperature.group = {}

local function TSysSSDsMaxTemperature_from_obj(obj)
    return setmetatable(obj, TSysSSDsMaxTemperature)
end

function TSysSSDsMaxTemperature.new(SysSSDsMaxTemperature)
    return TSysSSDsMaxTemperature_from_obj({SysSSDsMaxTemperature = SysSSDsMaxTemperature or 32768})
end
---@param obj DiskCoolingConfig.SysSSDsMaxTemperature
function TSysSSDsMaxTemperature:init_from_obj(obj)
    self.SysSSDsMaxTemperature = obj.SysSSDsMaxTemperature or 32768
end

function TSysSSDsMaxTemperature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSysSSDsMaxTemperature.group)
end

TSysSSDsMaxTemperature.from_obj = TSysSSDsMaxTemperature_from_obj

TSysSSDsMaxTemperature.proto_property = {'SysSSDsMaxTemperature'}

TSysSSDsMaxTemperature.default = {0}

TSysSSDsMaxTemperature.struct = {{name = 'SysSSDsMaxTemperature', is_array = false, struct = nil}}

function TSysSSDsMaxTemperature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SysSSDsMaxTemperature', self.SysSSDsMaxTemperature, 'double', true, errs, need_convert)

    TSysSSDsMaxTemperature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSysSSDsMaxTemperature.proto_property, errs, need_convert)
    return self
end

function TSysSSDsMaxTemperature:unpack(_)
    return self.SysSSDsMaxTemperature
end

DiskCoolingConfig.SysSSDsMaxTemperature = TSysSSDsMaxTemperature

---@class DiskCoolingConfig.SysHDDsMaxTemperature
---@field SysHDDsMaxTemperature number
local TSysHDDsMaxTemperature = {}
TSysHDDsMaxTemperature.__index = TSysHDDsMaxTemperature
TSysHDDsMaxTemperature.group = {}

local function TSysHDDsMaxTemperature_from_obj(obj)
    return setmetatable(obj, TSysHDDsMaxTemperature)
end

function TSysHDDsMaxTemperature.new(SysHDDsMaxTemperature)
    return TSysHDDsMaxTemperature_from_obj({SysHDDsMaxTemperature = SysHDDsMaxTemperature or 32768})
end
---@param obj DiskCoolingConfig.SysHDDsMaxTemperature
function TSysHDDsMaxTemperature:init_from_obj(obj)
    self.SysHDDsMaxTemperature = obj.SysHDDsMaxTemperature or 32768
end

function TSysHDDsMaxTemperature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSysHDDsMaxTemperature.group)
end

TSysHDDsMaxTemperature.from_obj = TSysHDDsMaxTemperature_from_obj

TSysHDDsMaxTemperature.proto_property = {'SysHDDsMaxTemperature'}

TSysHDDsMaxTemperature.default = {0}

TSysHDDsMaxTemperature.struct = {{name = 'SysHDDsMaxTemperature', is_array = false, struct = nil}}

function TSysHDDsMaxTemperature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SysHDDsMaxTemperature', self.SysHDDsMaxTemperature, 'double', true, errs, need_convert)

    TSysHDDsMaxTemperature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSysHDDsMaxTemperature.proto_property, errs, need_convert)
    return self
end

function TSysHDDsMaxTemperature:unpack(_)
    return self.SysHDDsMaxTemperature
end

DiskCoolingConfig.SysHDDsMaxTemperature = TSysHDDsMaxTemperature

---@class DiskCoolingConfig.DiskRowTemperatureAvailable
---@field DiskRowTemperatureAvailable boolean
local TDiskRowTemperatureAvailable = {}
TDiskRowTemperatureAvailable.__index = TDiskRowTemperatureAvailable
TDiskRowTemperatureAvailable.group = {}

local function TDiskRowTemperatureAvailable_from_obj(obj)
    return setmetatable(obj, TDiskRowTemperatureAvailable)
end

function TDiskRowTemperatureAvailable.new(DiskRowTemperatureAvailable)
    return TDiskRowTemperatureAvailable_from_obj({DiskRowTemperatureAvailable = DiskRowTemperatureAvailable or false})
end
---@param obj DiskCoolingConfig.DiskRowTemperatureAvailable
function TDiskRowTemperatureAvailable:init_from_obj(obj)
    self.DiskRowTemperatureAvailable = obj.DiskRowTemperatureAvailable or false
end

function TDiskRowTemperatureAvailable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiskRowTemperatureAvailable.group)
end

TDiskRowTemperatureAvailable.from_obj = TDiskRowTemperatureAvailable_from_obj

TDiskRowTemperatureAvailable.proto_property = {'DiskRowTemperatureAvailable'}

TDiskRowTemperatureAvailable.default = {false}

TDiskRowTemperatureAvailable.struct = {{name = 'DiskRowTemperatureAvailable', is_array = false, struct = nil}}

function TDiskRowTemperatureAvailable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiskRowTemperatureAvailable', self.DiskRowTemperatureAvailable, 'bool', true, errs,
        need_convert)

    TDiskRowTemperatureAvailable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiskRowTemperatureAvailable.proto_property, errs, need_convert)
    return self
end

function TDiskRowTemperatureAvailable:unpack(_)
    return self.DiskRowTemperatureAvailable
end

DiskCoolingConfig.DiskRowTemperatureAvailable = TDiskRowTemperatureAvailable

DiskCoolingConfig.interface = mdb.register_interface('bmc.kepler.Systems.DiskCoolingConfig', {
    DiskRowTemperatureAvailable = {'b', nil, true, false, false},
    SysHDDsMaxTemperature = {'d', nil, true, 32768, false},
    SysSSDsMaxTemperature = {'d', nil, true, 32768, false},
    SysM2sMaxTemperature = {'d', nil, true, 32768, false},
    SysAllSSDsMaxTemperature = {'d', nil, true, 32768, false},
    FrontNVMeSSDMaxTemperatureCelsius = {'d', {'EMIT_CHANGE'}, true, 32768, false},
    FrontHddMaxTemperatureCelsius = {'d', {'EMIT_CHANGE'}, true, 32768, false},
    RearNVMeSSDMaxTemperatureCelsius = {'d', {'EMIT_CHANGE'}, true, 32768, false},
    RearHddMaxTemperatureCelsius = {'d', {'EMIT_CHANGE'}, true, 32768, false}
}, {}, {})

return DiskCoolingConfig
