-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local CoolingFan = {}

---@class CoolingFan.ManualSpeedPercentPoweroffPersist
---@field ManualSpeedPercentPoweroffPersist integer
local TManualSpeedPercentPoweroffPersist = {}
TManualSpeedPercentPoweroffPersist.__index = TManualSpeedPercentPoweroffPersist
TManualSpeedPercentPoweroffPersist.group = {}

local function TManualSpeedPercentPoweroffPersist_from_obj(obj)
    return setmetatable(obj, TManualSpeedPercentPoweroffPersist)
end

function TManualSpeedPercentPoweroffPersist.new(ManualSpeedPercentPoweroffPersist)
    return TManualSpeedPercentPoweroffPersist_from_obj({
        ManualSpeedPercentPoweroffPersist = ManualSpeedPercentPoweroffPersist or 0
    })
end
---@param obj CoolingFan.ManualSpeedPercentPoweroffPersist
function TManualSpeedPercentPoweroffPersist:init_from_obj(obj)
    self.ManualSpeedPercentPoweroffPersist = obj.ManualSpeedPercentPoweroffPersist or 0
end

function TManualSpeedPercentPoweroffPersist:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManualSpeedPercentPoweroffPersist.group)
end

TManualSpeedPercentPoweroffPersist.from_obj = TManualSpeedPercentPoweroffPersist_from_obj

TManualSpeedPercentPoweroffPersist.proto_property = {'ManualSpeedPercentPoweroffPersist'}

TManualSpeedPercentPoweroffPersist.default = {0}

TManualSpeedPercentPoweroffPersist.struct = {
    {name = 'ManualSpeedPercentPoweroffPersist', is_array = false, struct = nil}
}

function TManualSpeedPercentPoweroffPersist:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManualSpeedPercentPoweroffPersist', self.ManualSpeedPercentPoweroffPersist, 'uint8',
        true, errs, need_convert)

    if self.ManualSpeedPercentPoweroffPersist ~= nil then
        validate.ranges(prefix .. 'ManualSpeedPercentPoweroffPersist', self.ManualSpeedPercentPoweroffPersist, 0, 100,
            errs, need_convert)
    end

    TManualSpeedPercentPoweroffPersist:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManualSpeedPercentPoweroffPersist.proto_property, errs, need_convert)
    return self
end

function TManualSpeedPercentPoweroffPersist:unpack(_)
    return self.ManualSpeedPercentPoweroffPersist
end

CoolingFan.ManualSpeedPercentPoweroffPersist = TManualSpeedPercentPoweroffPersist

---@class CoolingFan.ManualSpeedPercentResetPersist
---@field ManualSpeedPercentResetPersist integer
local TManualSpeedPercentResetPersist = {}
TManualSpeedPercentResetPersist.__index = TManualSpeedPercentResetPersist
TManualSpeedPercentResetPersist.group = {}

local function TManualSpeedPercentResetPersist_from_obj(obj)
    return setmetatable(obj, TManualSpeedPercentResetPersist)
end

function TManualSpeedPercentResetPersist.new(ManualSpeedPercentResetPersist)
    return TManualSpeedPercentResetPersist_from_obj({
        ManualSpeedPercentResetPersist = ManualSpeedPercentResetPersist or 0
    })
end
---@param obj CoolingFan.ManualSpeedPercentResetPersist
function TManualSpeedPercentResetPersist:init_from_obj(obj)
    self.ManualSpeedPercentResetPersist = obj.ManualSpeedPercentResetPersist or 0
end

function TManualSpeedPercentResetPersist:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManualSpeedPercentResetPersist.group)
end

TManualSpeedPercentResetPersist.from_obj = TManualSpeedPercentResetPersist_from_obj

TManualSpeedPercentResetPersist.proto_property = {'ManualSpeedPercentResetPersist'}

TManualSpeedPercentResetPersist.default = {0}

TManualSpeedPercentResetPersist.struct = {{name = 'ManualSpeedPercentResetPersist', is_array = false, struct = nil}}

function TManualSpeedPercentResetPersist:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManualSpeedPercentResetPersist', self.ManualSpeedPercentResetPersist, 'uint8', true,
        errs, need_convert)

    if self.ManualSpeedPercentResetPersist ~= nil then
        validate.ranges(prefix .. 'ManualSpeedPercentResetPersist', self.ManualSpeedPercentResetPersist, 0, 100, errs,
            need_convert)
    end

    TManualSpeedPercentResetPersist:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManualSpeedPercentResetPersist.proto_property, errs, need_convert)
    return self
end

function TManualSpeedPercentResetPersist:unpack(_)
    return self.ManualSpeedPercentResetPersist
end

CoolingFan.ManualSpeedPercentResetPersist = TManualSpeedPercentResetPersist

---@class CoolingFan.Level
---@field Level integer
local TLevel = {}
TLevel.__index = TLevel
TLevel.group = {}

local function TLevel_from_obj(obj)
    return setmetatable(obj, TLevel)
end

function TLevel.new(Level)
    return TLevel_from_obj({Level = Level})
end
---@param obj CoolingFan.Level
function TLevel:init_from_obj(obj)
    self.Level = obj.Level
end

function TLevel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLevel.group)
end

TLevel.from_obj = TLevel_from_obj

TLevel.proto_property = {'Level'}

TLevel.default = {0}

TLevel.struct = {{name = 'Level', is_array = false, struct = nil}}

function TLevel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Level', self.Level, 'uint8', true, errs, need_convert)

    TLevel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLevel.proto_property, errs, need_convert)
    return self
end

function TLevel:unpack(_)
    return self.Level
end

CoolingFan.Level = TLevel

---@class CoolingFan.RearSpeed
---@field RearSpeed integer
local TRearSpeed = {}
TRearSpeed.__index = TRearSpeed
TRearSpeed.group = {}

local function TRearSpeed_from_obj(obj)
    return setmetatable(obj, TRearSpeed)
end

function TRearSpeed.new(RearSpeed)
    return TRearSpeed_from_obj({RearSpeed = RearSpeed})
end
---@param obj CoolingFan.RearSpeed
function TRearSpeed:init_from_obj(obj)
    self.RearSpeed = obj.RearSpeed
end

function TRearSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearSpeed.group)
end

TRearSpeed.from_obj = TRearSpeed_from_obj

TRearSpeed.proto_property = {'RearSpeed'}

TRearSpeed.default = {0}

TRearSpeed.struct = {{name = 'RearSpeed', is_array = false, struct = nil}}

function TRearSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RearSpeed', self.RearSpeed, 'uint16', true, errs, need_convert)

    TRearSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearSpeed.proto_property, errs, need_convert)
    return self
end

function TRearSpeed:unpack(_)
    return self.RearSpeed
end

CoolingFan.RearSpeed = TRearSpeed

---@class CoolingFan.FrontSpeed
---@field FrontSpeed integer
local TFrontSpeed = {}
TFrontSpeed.__index = TFrontSpeed
TFrontSpeed.group = {}

local function TFrontSpeed_from_obj(obj)
    return setmetatable(obj, TFrontSpeed)
end

function TFrontSpeed.new(FrontSpeed)
    return TFrontSpeed_from_obj({FrontSpeed = FrontSpeed})
end
---@param obj CoolingFan.FrontSpeed
function TFrontSpeed:init_from_obj(obj)
    self.FrontSpeed = obj.FrontSpeed
end

function TFrontSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFrontSpeed.group)
end

TFrontSpeed.from_obj = TFrontSpeed_from_obj

TFrontSpeed.proto_property = {'FrontSpeed'}

TFrontSpeed.default = {0}

TFrontSpeed.struct = {{name = 'FrontSpeed', is_array = false, struct = nil}}

function TFrontSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FrontSpeed', self.FrontSpeed, 'uint16', true, errs, need_convert)

    TFrontSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFrontSpeed.proto_property, errs, need_convert)
    return self
end

function TFrontSpeed:unpack(_)
    return self.FrontSpeed
end

CoolingFan.FrontSpeed = TFrontSpeed

---@class CoolingFan.RearStatus
---@field RearStatus integer
local TRearStatus = {}
TRearStatus.__index = TRearStatus
TRearStatus.group = {}

local function TRearStatus_from_obj(obj)
    return setmetatable(obj, TRearStatus)
end

function TRearStatus.new(RearStatus)
    return TRearStatus_from_obj({RearStatus = RearStatus or 0})
end
---@param obj CoolingFan.RearStatus
function TRearStatus:init_from_obj(obj)
    self.RearStatus = obj.RearStatus or 0
end

function TRearStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearStatus.group)
end

TRearStatus.from_obj = TRearStatus_from_obj

TRearStatus.proto_property = {'RearStatus'}

TRearStatus.default = {0}

TRearStatus.struct = {{name = 'RearStatus', is_array = false, struct = nil}}

function TRearStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RearStatus', self.RearStatus, 'uint8', true, errs, need_convert)

    TRearStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearStatus.proto_property, errs, need_convert)
    return self
end

function TRearStatus:unpack(_)
    return self.RearStatus
end

CoolingFan.RearStatus = TRearStatus

---@class CoolingFan.FrontStatus
---@field FrontStatus integer
local TFrontStatus = {}
TFrontStatus.__index = TFrontStatus
TFrontStatus.group = {}

local function TFrontStatus_from_obj(obj)
    return setmetatable(obj, TFrontStatus)
end

function TFrontStatus.new(FrontStatus)
    return TFrontStatus_from_obj({FrontStatus = FrontStatus or 0})
end
---@param obj CoolingFan.FrontStatus
function TFrontStatus:init_from_obj(obj)
    self.FrontStatus = obj.FrontStatus or 0
end

function TFrontStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFrontStatus.group)
end

TFrontStatus.from_obj = TFrontStatus_from_obj

TFrontStatus.proto_property = {'FrontStatus'}

TFrontStatus.default = {0}

TFrontStatus.struct = {{name = 'FrontStatus', is_array = false, struct = nil}}

function TFrontStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FrontStatus', self.FrontStatus, 'uint8', true, errs, need_convert)

    TFrontStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFrontStatus.proto_property, errs, need_convert)
    return self
end

function TFrontStatus:unpack(_)
    return self.FrontStatus
end

CoolingFan.FrontStatus = TFrontStatus

---@class CoolingFan.RearPresence
---@field RearPresence integer
local TRearPresence = {}
TRearPresence.__index = TRearPresence
TRearPresence.group = {}

local function TRearPresence_from_obj(obj)
    return setmetatable(obj, TRearPresence)
end

function TRearPresence.new(RearPresence)
    return TRearPresence_from_obj({RearPresence = RearPresence or 1})
end
---@param obj CoolingFan.RearPresence
function TRearPresence:init_from_obj(obj)
    self.RearPresence = obj.RearPresence or 1
end

function TRearPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearPresence.group)
end

TRearPresence.from_obj = TRearPresence_from_obj

TRearPresence.proto_property = {'RearPresence'}

TRearPresence.default = {0}

TRearPresence.struct = {{name = 'RearPresence', is_array = false, struct = nil}}

function TRearPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RearPresence', self.RearPresence, 'uint8', true, errs, need_convert)

    TRearPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearPresence.proto_property, errs, need_convert)
    return self
end

function TRearPresence:unpack(_)
    return self.RearPresence
end

CoolingFan.RearPresence = TRearPresence

---@class CoolingFan.FrontPresence
---@field FrontPresence integer
local TFrontPresence = {}
TFrontPresence.__index = TFrontPresence
TFrontPresence.group = {}

local function TFrontPresence_from_obj(obj)
    return setmetatable(obj, TFrontPresence)
end

function TFrontPresence.new(FrontPresence)
    return TFrontPresence_from_obj({FrontPresence = FrontPresence or 1})
end
---@param obj CoolingFan.FrontPresence
function TFrontPresence:init_from_obj(obj)
    self.FrontPresence = obj.FrontPresence or 1
end

function TFrontPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFrontPresence.group)
end

TFrontPresence.from_obj = TFrontPresence_from_obj

TFrontPresence.proto_property = {'FrontPresence'}

TFrontPresence.default = {0}

TFrontPresence.struct = {{name = 'FrontPresence', is_array = false, struct = nil}}

function TFrontPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FrontPresence', self.FrontPresence, 'uint8', true, errs, need_convert)

    TFrontPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFrontPresence.proto_property, errs, need_convert)
    return self
end

function TFrontPresence:unpack(_)
    return self.FrontPresence
end

CoolingFan.FrontPresence = TFrontPresence

---@class CoolingFan.HardwarePWM
---@field HardwarePWM number
local THardwarePWM = {}
THardwarePWM.__index = THardwarePWM
THardwarePWM.group = {}

local function THardwarePWM_from_obj(obj)
    return setmetatable(obj, THardwarePWM)
end

function THardwarePWM.new(HardwarePWM)
    return THardwarePWM_from_obj({HardwarePWM = HardwarePWM})
end
---@param obj CoolingFan.HardwarePWM
function THardwarePWM:init_from_obj(obj)
    self.HardwarePWM = obj.HardwarePWM
end

function THardwarePWM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THardwarePWM.group)
end

THardwarePWM.from_obj = THardwarePWM_from_obj

THardwarePWM.proto_property = {'HardwarePWM'}

THardwarePWM.default = {0}

THardwarePWM.struct = {{name = 'HardwarePWM', is_array = false, struct = nil}}

function THardwarePWM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HardwarePWM', self.HardwarePWM, 'double', true, errs, need_convert)

    THardwarePWM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THardwarePWM.proto_property, errs, need_convert)
    return self
end

function THardwarePWM:unpack(_)
    return self.HardwarePWM
end

CoolingFan.HardwarePWM = THardwarePWM

---@class CoolingFan.FanId
---@field FanId integer
local TFanId = {}
TFanId.__index = TFanId
TFanId.group = {}

local function TFanId_from_obj(obj)
    return setmetatable(obj, TFanId)
end

function TFanId.new(FanId)
    return TFanId_from_obj({FanId = FanId})
end
---@param obj CoolingFan.FanId
function TFanId:init_from_obj(obj)
    self.FanId = obj.FanId
end

function TFanId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanId.group)
end

TFanId.from_obj = TFanId_from_obj

TFanId.proto_property = {'FanId'}

TFanId.default = {0}

TFanId.struct = {{name = 'FanId', is_array = false, struct = nil}}

function TFanId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'FanId', self.FanId, 'uint8', true, errs, need_convert)

    TFanId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanId.proto_property, errs, need_convert)
    return self
end

function TFanId:unpack(_)
    return self.FanId
end

CoolingFan.FanId = TFanId

CoolingFan.interface = mdb.register_interface('bmc.kepler.Systems.CoolingFan', {
    FanId = {'y', {}, true, nil, false},
    HardwarePWM = {'d', {}, true, nil, false},
    FrontPresence = {'y', {}, true, 1, false},
    RearPresence = {'y', {}, true, 1, false},
    FrontStatus = {'y', {}, true, 0, false},
    RearStatus = {'y', {}, true, 0, false},
    FrontSpeed = {'q', {}, true, nil, false},
    RearSpeed = {'q', {}, true, nil, false},
    Level = {'y', {}, true, nil, false},
    ManualSpeedPercentResetPersist = {'y', {}, true, 0, false},
    ManualSpeedPercentPoweroffPersist = {'y', {}, true, 0, false}
}, {}, {})

return CoolingFan
