--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetFanLevel = {}

---@class ThermalMgmtIpmiCmds.GetFanLevelReq
---@field PicmgIdentifier integer
---@field FruId integer
local TGetFanLevelReq = {}
TGetFanLevelReq.__index = TGetFanLevelReq
TGetFanLevelReq.group = {}

local function TGetFanLevelReq_from_obj(obj)
    return setmetatable(obj, TGetFanLevelReq)
end

function TGetFanLevelReq.new(PicmgIdentifier, FruId)
    return TGetFanLevelReq_from_obj({PicmgIdentifier = PicmgIdentifier, FruId = FruId})
end
---@param obj ThermalMgmtIpmiCmds.GetFanLevelReq
function TGetFanLevelReq:init_from_obj(obj)
    self.PicmgIdentifier = obj.PicmgIdentifier
    self.FruId = obj.FruId
end

function TGetFanLevelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFanLevelReq.group)
end

TGetFanLevelReq.from_obj = TGetFanLevelReq_from_obj

TGetFanLevelReq.proto_property = {'PicmgIdentifier', 'FruId'}

TGetFanLevelReq.default = {0, 0}

TGetFanLevelReq.struct = {
    {name = 'PicmgIdentifier', is_array = false, struct = nil}, {name = 'FruId', is_array = false, struct = nil}
}

function TGetFanLevelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PicmgIdentifier', self.PicmgIdentifier, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)

    TGetFanLevelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFanLevelReq.proto_property, errs, need_convert)
    return self
end

function TGetFanLevelReq:unpack(_)
    return self.PicmgIdentifier, self.FruId
end

GetFanLevel.GetFanLevelReq = TGetFanLevelReq

---@class ThermalMgmtIpmiCmds.GetFanLevelRsp
---@field CompletionCode integer
---@field PicmgIdentifier integer
---@field LocalCtlFanLevel integer
local TGetFanLevelRsp = {}
TGetFanLevelRsp.__index = TGetFanLevelRsp
TGetFanLevelRsp.group = {}

local function TGetFanLevelRsp_from_obj(obj)
    return setmetatable(obj, TGetFanLevelRsp)
end

function TGetFanLevelRsp.new(CompletionCode, PicmgIdentifier, LocalCtlFanLevel)
    return TGetFanLevelRsp_from_obj({
        CompletionCode = CompletionCode,
        PicmgIdentifier = PicmgIdentifier,
        LocalCtlFanLevel = LocalCtlFanLevel
    })
end
---@param obj ThermalMgmtIpmiCmds.GetFanLevelRsp
function TGetFanLevelRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.PicmgIdentifier = obj.PicmgIdentifier
    self.LocalCtlFanLevel = obj.LocalCtlFanLevel
end

function TGetFanLevelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFanLevelRsp.group)
end

TGetFanLevelRsp.from_obj = TGetFanLevelRsp_from_obj

TGetFanLevelRsp.proto_property = {'CompletionCode', 'PicmgIdentifier', 'LocalCtlFanLevel'}

TGetFanLevelRsp.default = {0, 0, 0}

TGetFanLevelRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'PicmgIdentifier', is_array = false, struct = nil},
    {name = 'LocalCtlFanLevel', is_array = false, struct = nil}
}

function TGetFanLevelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PicmgIdentifier', self.PicmgIdentifier, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LocalCtlFanLevel', self.LocalCtlFanLevel, 'uint8', false, errs, need_convert)

    TGetFanLevelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFanLevelRsp.proto_property, errs, need_convert)
    return self
end

function TGetFanLevelRsp:unpack(_)
    return self.CompletionCode, self.PicmgIdentifier, self.LocalCtlFanLevel
end

GetFanLevel.GetFanLevelRsp = TGetFanLevelRsp

return GetFanLevel
