-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local Databases = require 'database'
local Col = require 'database.column'

---@class FanTable: Table
---@field FanId FieldBase
---@field Slot FieldBase
---@field Type FieldBase
---@field Model FieldBase
---@field Coefficient FieldBase
---@field FanHealth FieldBase
---@field FanEntity FieldBase
---@field FrontPresence FieldBase
---@field RearPresence FieldBase
---@field FrontSpeed FieldBase
---@field RearSpeed FieldBase
---@field FrontStatus FieldBase
---@field RearStatus FieldBase
---@field FrontRPM FieldBase
---@field RearRPM FieldBase
---@field HardwarePWM FieldBase
---@field PWMPercentage FieldBase
---@field ExpectedPWM FieldBase
---@field FanAlarmLed FieldBase
---@field BOM FieldBase
---@field SystemId FieldBase
---@field MaxSupportedPWM FieldBase
---@field IdentifySpeedLevel FieldBase
---@field PartNumber FieldBase
---@field FrontMaxSpeed FieldBase
---@field RearMaxSpeed FieldBase
---@field IsTwins FieldBase
---@field Position FieldBase
---@field SpeedStable FieldBase
---@field FunctionDesc FieldBase
---@field DeviceName FieldBase
---@field FanObjectName FieldBase
---@field PowerGood FieldBase
---@field DualConnector FieldBase
---@field SingleConnector FieldBase
---@field IdentifyStatus FieldBase

---@class FanTypeTable: Table
---@field Name FieldBase
---@field Index FieldBase
---@field IsDefaultType FieldBase
---@field IsTwins FieldBase
---@field FrontMaxSpeed FieldBase
---@field RearMaxSpeed FieldBase
---@field IdentifyRangeLow FieldBase
---@field IdentifyRangeHigh FieldBase
---@field MatchedCount FieldBase
---@field PartNumber FieldBase
---@field BOM FieldBase
---@field SystemId FieldBase
---@field SpeedRange FieldBase
---@field PowerRange FieldBase
---@field FanDiameterMm FieldBase
---@field FanTypeObjectName FieldBase

---@class FanInfoTable: Table
---@field FanId FieldBase
---@field SystemId FieldBase
---@field FanPosition FieldBase
---@field Type FieldBase
---@field Model FieldBase
---@field BOM FieldBase
---@field PartNumber FieldBase
---@field FrontMaxSpeed FieldBase
---@field RearMaxSpeed FieldBase
---@field IsTwins FieldBase

---@class ThermalConfigurationTable: Table
---@field StandbyFan FieldBase
---@field FanStartSlot FieldBase
---@field Id FieldBase

---@class PWMChannelTable: Table
---@field PWMChannelObjectName FieldBase
---@field ManageFans FieldBase

---@class SystemsFansTable: Table
---@field WorkInStandby FieldBase
---@field EstimatedTotalPowerWatts FieldBase
---@field SystemId FieldBase

---@class FansTable: Table
---@field FansObjectName FieldBase
---@field PWMChip FieldBase
---@field SetPWMCmd FieldBase
---@field WorkInStandby FieldBase

---@class PumpsTable: Table
---@field WorkInStandby FieldBase
---@field PumpsObjectName FieldBase
---@field PWMChip FieldBase
---@field SetPWMCmd FieldBase

---@class PumpTable: Table
---@field Id FieldBase
---@field Slot FieldBase
---@field Model FieldBase
---@field PartNumber FieldBase
---@field ExpectedPWM FieldBase
---@field ActualPWM FieldBase
---@field MaxSupportedPWM FieldBase
---@field SpeedRPM FieldBase
---@field MaxSpeedRPM FieldBase
---@field Presence FieldBase
---@field Status FieldBase
---@field PowerGood FieldBase

---@class ValvesTable: Table
---@field LastPatrolTimestamp FieldBase
---@field PatrolState FieldBase
---@field Id FieldBase
---@field PatrolType FieldBase
---@field InvalidLocationId FieldBase

---@class ValveTable: Table
---@field Id FieldBase
---@field Slot FieldBase
---@field Presence FieldBase
---@field OpeningDegree FieldBase
---@field StandardOpeningDegree FieldBase
---@field Status FieldBase
---@field OpeningDegreeState FieldBase
---@field PatrolResult FieldBase

---@class BasicCoolingConfigTable: Table
---@field FanGroupSpeedDiffThresholdPercent FieldBase
---@field PsuFanSpeedCalibration FieldBase
---@field Id FieldBase

---@class FanGroupTable: Table
---@field Id FieldBase
---@field FanSlots FieldBase
---@field SpeedPercent FieldBase
---@field ExpectedSpeedPercent FieldBase
---@field ResetSpeedPercent FieldBase

---@class FanGroupPolicyTable: Table
---@field Id FieldBase
---@field PolicyType FieldBase
---@field FanGroupIds FieldBase
---@field RelativeGroupIds FieldBase
---@field SpeedPercentDifference FieldBase

---@class PumpGroupTable: Table
---@field Id FieldBase
---@field PumpSlots FieldBase
---@field SpeedPercent FieldBase
---@field ExpectedSpeedPercent FieldBase

---@class CoolingConfigTable: Table
---@field SmartCoolingState FieldBase
---@field SmartCoolingMode FieldBase
---@field Medium FieldBase
---@field CtrlMode FieldBase
---@field TimeOut FieldBase
---@field ManualLevel FieldBase
---@field LevelPercentRange FieldBase
---@field SensorLocationSupported FieldBase
---@field MinAllowedFanSpeedPercent FieldBase
---@field MinAllowedFanSpeedEnabled FieldBase
---@field MixedModeSupported FieldBase
---@field DiskRowTemperatureAvailable FieldBase
---@field SysHDDsMaxTemperature FieldBase
---@field SysSSDsMaxTemperature FieldBase
---@field SysM2sMaxTemperature FieldBase
---@field SysAllSSDsMaxTemperature FieldBase
---@field FrontNVMeSSDMaxTemperatureCelsius FieldBase
---@field FrontHddMaxTemperatureCelsius FieldBase
---@field RearNVMeSSDMaxTemperatureCelsius FieldBase
---@field RearHddMaxTemperatureCelsius FieldBase
---@field Id FieldBase
---@field MinimalLevel FieldBase
---@field MaxLimitLevel FieldBase
---@field FanLevel FieldBase
---@field FanCtrlEnable FieldBase
---@field CoolingWay FieldBase
---@field FanBoardNum FieldBase
---@field OriginalSmartCoolingMode FieldBase
---@field InitLevelInStartup FieldBase

---@class AirCoolingConfigTable: Table
---@field CtrlMode FieldBase
---@field CtrlModePersistType FieldBase
---@field CtrlModeResetPersist FieldBase
---@field CtrlModePoweroffPersist FieldBase
---@field TimeOut FieldBase
---@field ManualSpeedPercent FieldBase
---@field ManualSpeedPercentResetPersist FieldBase
---@field ManualSpeedPercentPoweroffPersist FieldBase
---@field SpeedPercentRange FieldBase
---@field MinAllowedSpeedPercent FieldBase
---@field InitialSpeedPercent FieldBase
---@field ActiveAlgorithm FieldBase
---@field Id FieldBase

---@class CoolingFanTable: Table
---@field FanId FieldBase
---@field HardwarePWM FieldBase
---@field FrontPresence FieldBase
---@field RearPresence FieldBase
---@field FrontStatus FieldBase
---@field RearStatus FieldBase
---@field FrontSpeed FieldBase
---@field RearSpeed FieldBase
---@field Level FieldBase
---@field ManualSpeedPercentResetPersist FieldBase
---@field ManualSpeedPercentPoweroffPersist FieldBase
---@field Slot FieldBase
---@field MaxSupportedPWM FieldBase

---@class CoolingRequirementTable: Table
---@field RequirementId FieldBase
---@field TemperatureType FieldBase
---@field ActiveInStandby FieldBase
---@field TargetTemperatureCelsius FieldBase
---@field MaxAllowedTemperatureCelsius FieldBase
---@field CustomSupported FieldBase
---@field CustomTargetTemperatureCelsius FieldBase
---@field TargetTemperatureRangeCelsius FieldBase
---@field MonitoringStatus FieldBase
---@field MonitoringValue FieldBase
---@field FailedValue FieldBase
---@field ThresholdValue FieldBase
---@field AlarmSpeed FieldBase
---@field SmartCoolingTargetTemperatureCelsius FieldBase
---@field SensorName FieldBase
---@field BaseId FieldBase
---@field Slot FieldBase
---@field Enabled FieldBase
---@field IsValid FieldBase
---@field BackupRequirementIdx FieldBase
---@field IsBackupRequirement FieldBase
---@field ObtainTempFaildToValid FieldBase
---@field CoolingMedium FieldBase
---@field LiquidFailedValue FieldBase
---@field OriginTargetTemperatureCelsius FieldBase
---@field OriginFailedValue FieldBase
---@field OriginMaxAllowedTemperatureCelsius FieldBase
---@field OriginSmartCoolingTargetTemperature FieldBase
---@field SmartCoolingTargetTemperature FieldBase

---@class CoolingPolicyTable: Table
---@field PolicyIdx FieldBase
---@field PolicyType FieldBase
---@field IsValid FieldBase
---@field ExpCondVal FieldBase
---@field ActualCondVal FieldBase
---@field CustomSupported FieldBase
---@field FanSpeedRangePercents FieldBase
---@field Hysteresis FieldBase
---@field TemperatureRangeLow FieldBase
---@field TemperatureRangeHigh FieldBase
---@field SpeedRangeLow FieldBase
---@field SpeedRangeHigh FieldBase
---@field TemperatureArray FieldBase
---@field FanSpeedArray FieldBase
---@field FanType FieldBase
---@field DiskTempUnavailableToValid FieldBase
---@field HDDBackPlaneName FieldBase
---@field HDDRearBackPlaneName FieldBase
---@field HDDBackPlaneType FieldBase
---@field PCIeCardName FieldBase
---@field CoolingMedium FieldBase
---@field OriginTemperatureRangeLow FieldBase
---@field OriginTemperatureRangeHigh FieldBase
---@field OriginSpeedRangeLow FieldBase
---@field OriginSpeedRangeHigh FieldBase

---@class ThermalSubsystemTable: Table
---@field TotalPowerWatts FieldBase
---@field EnergyConsumptionkWh FieldBase
---@field ResetTime FieldBase
---@field Id FieldBase

---@class Thermal_mgmtDBDatabase
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field Fan FanTable
---@field FanType FanTypeTable
---@field FanInfo FanInfoTable
---@field ThermalConfiguration ThermalConfigurationTable
---@field PWMChannel PWMChannelTable
---@field SystemsFans SystemsFansTable
---@field Fans FansTable
---@field Pumps PumpsTable
---@field Pump PumpTable
---@field Valves ValvesTable
---@field Valve ValveTable
---@field BasicCoolingConfig BasicCoolingConfigTable
---@field FanGroup FanGroupTable
---@field FanGroupPolicy FanGroupPolicyTable
---@field PumpGroup PumpGroupTable
---@field CoolingConfig CoolingConfigTable
---@field AirCoolingConfig AirCoolingConfigTable
---@field CoolingFan CoolingFanTable
---@field CoolingRequirement CoolingRequirementTable
---@field CoolingPolicy CoolingPolicyTable
---@field ThermalSubsystem ThermalSubsystemTable
local Thermal_mgmtDBDatabase = {}
Thermal_mgmtDBDatabase.__index = Thermal_mgmtDBDatabase

function Thermal_mgmtDBDatabase.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.Fan = db:Table('t_fan', {
        FanId = Col.IntegerField():cid(1):null():max_length(16),
        Slot = Col.IntegerField():cid(2):null():max_length(8),
        Type = Col.IntegerField():cid(3):null():max_length(8),
        Model = Col.TextField():cid(4):null(),
        Coefficient = Col.IntegerField():cid(5):null():max_length(8),
        FanHealth = Col.IntegerField():cid(6):null():max_length(8),
        FanEntity = Col.TextField():cid(7):null(),
        FrontPresence = Col.IntegerField():cid(8):null():max_length(8),
        RearPresence = Col.IntegerField():cid(9):null():max_length(8),
        FrontSpeed = Col.IntegerField():cid(10):null():max_length(16),
        RearSpeed = Col.IntegerField():cid(11):null():max_length(16),
        FrontStatus = Col.IntegerField():cid(12):null():max_length(8),
        RearStatus = Col.IntegerField():cid(13):null():max_length(8),
        FrontRPM = Col.IntegerField():cid(14):null():max_length(16),
        RearRPM = Col.IntegerField():cid(15):null():max_length(16),
        HardwarePWM = Col.RealField():cid(16):null(),
        PWMPercentage = Col.IntegerField():cid(17):null():max_length(32),
        ExpectedPWM = Col.RealField():cid(18):null(),
        FanAlarmLed = Col.IntegerField():cid(19):null():max_length(8),
        BOM = Col.TextField():cid(20):null(),
        SystemId = Col.IntegerField():cid(21):null():max_length(8),
        MaxSupportedPWM = Col.IntegerField():cid(22):null():max_length(32),
        IdentifySpeedLevel = Col.IntegerField():cid(23):null():max_length(8),
        PartNumber = Col.TextField():cid(24):null(),
        FrontMaxSpeed = Col.IntegerField():cid(25):null():max_length(32),
        RearMaxSpeed = Col.IntegerField():cid(26):null():max_length(32),
        IsTwins = Col.BooleandField():cid(27):null(),
        Position = Col.TextField():cid(28):null(),
        SpeedStable = Col.BooleandField():cid(29):null(),
        FunctionDesc = Col.TextField():cid(30):null(),
        DeviceName = Col.TextField():cid(31):null(),
        FanObjectName = Col.TextField():cid(32):primary_key(),
        PowerGood = Col.IntegerField():cid(33):null():max_length(8),
        DualConnector = Col.JsonField():cid(34):null(),
        SingleConnector = Col.JsonField():cid(35):null(),
        IdentifyStatus = Col.IntegerField():cid(36):null():max_length(8):default(0)
    }):create_if_not_exist(datas and datas['t_fan'])
    obj.FanType = db:Table('t_fan_type', {
        Name = Col.TextField():cid(1):null(),
        Index = Col.IntegerField():cid(2):null():max_length(8),
        IsDefaultType = Col.BooleandField():cid(3):null(),
        IsTwins = Col.BooleandField():cid(4):null(),
        FrontMaxSpeed = Col.IntegerField():cid(5):null():max_length(32),
        RearMaxSpeed = Col.IntegerField():cid(6):null():max_length(32),
        IdentifyRangeLow = Col.IntegerField():cid(7):null():max_length(32),
        IdentifyRangeHigh = Col.IntegerField():cid(8):null():max_length(32),
        MatchedCount = Col.IntegerField():cid(9):null():max_length(8),
        PartNumber = Col.TextField():cid(10):null(),
        BOM = Col.TextField():cid(11):null(),
        SystemId = Col.IntegerField():cid(12):null():max_length(8),
        SpeedRange = Col.JsonField():cid(13):null(),
        PowerRange = Col.JsonField():cid(14):null(),
        FanDiameterMm = Col.IntegerField():cid(15):null():max_length(16),
        FanTypeObjectName = Col.TextField():cid(16):primary_key()
    }):create_if_not_exist(datas and datas['t_fan_type'])
    obj.FanInfo = db:Table('t_fan_info', {
        FanId = Col.IntegerField():cid(1):primary_key():persistence_key('protect_reset'):max_length(16):default(0),
        SystemId = Col.IntegerField():cid(2):primary_key():persistence_key('protect_reset'):max_length(8):default(0),
        FanPosition = Col.TextField():cid(3):primary_key():persistence_key('protect_reset'):default('\'\''),
        Type = Col.IntegerField():cid(4):persistence_key('protect_reset'):null():max_length(8):default(0),
        Model = Col.TextField():cid(5):persistence_key('protect_reset'):null():default('\'\''),
        BOM = Col.TextField():cid(6):persistence_key('protect_reset'):null():default('\'NA\''),
        PartNumber = Col.TextField():cid(7):persistence_key('protect_reset'):null():default('\'NA\''),
        FrontMaxSpeed = Col.IntegerField():cid(8):persistence_key('protect_reset'):null():max_length(32):default(10000),
        RearMaxSpeed = Col.IntegerField():cid(9):persistence_key('protect_reset'):null():max_length(32):default(10000),
        IsTwins = Col.BooleandField():cid(10):persistence_key('protect_reset'):null():default(true)
    }):create_if_not_exist(datas and datas['t_fan_info'])
    obj.ThermalConfiguration = db:Table('t_thermal_configuration', {
        StandbyFan = Col.IntegerField():cid(1):null():max_length(8):default(0),
        FanStartSlot = Col.JsonField():cid(2):null(),
        Id = Col.IntegerField():cid(3):primary_key():max_length(8):default(1)
    }):create_if_not_exist(datas and datas['t_thermal_configuration'])
    obj.PWMChannel = db:Table('t_pwm_channel', {
        PWMChannelObjectName = Col.TextField():cid(1):primary_key(),
        ManageFans = Col.JsonField():cid(2):null()
    }):create_if_not_exist(datas and datas['t_pwm_channel'])
    obj.SystemsFans = db:Table('t_systems_fans', {
        WorkInStandby = Col.IntegerField():cid(1):null():max_length(8),
        EstimatedTotalPowerWatts = Col.IntegerField():cid(2):null():max_length(16),
        SystemId = Col.IntegerField():cid(3):primary_key():max_length(8):default(1)
    }):create_if_not_exist(datas and datas['t_systems_fans'])
    obj.Fans = db:Table('t_fans', {
        FansObjectName = Col.TextField():cid(1):primary_key(),
        PWMChip = Col.JsonField():cid(2):null(),
        SetPWMCmd = Col.IntegerField():cid(3):null():max_length(32),
        WorkInStandby = Col.IntegerField():cid(4):null():max_length(8):default(0)
    }):create_if_not_exist(datas and datas['t_fans'])
    obj.Pumps = db:Table('t_pumps', {
        WorkInStandby = Col.IntegerField():cid(1):null():max_length(8),
        PumpsObjectName = Col.TextField():cid(2):primary_key(),
        PWMChip = Col.JsonField():cid(3):null(),
        SetPWMCmd = Col.IntegerField():cid(4):null():max_length(32)
    }):create_if_not_exist(datas and datas['t_pumps'])
    obj.Pump = db:Table('t_pump', {
        Id = Col.IntegerField():cid(1):primary_key():max_length(16),
        Slot = Col.IntegerField():cid(2):null():max_length(8),
        Model = Col.TextField():cid(3):null(),
        PartNumber = Col.TextField():cid(4):null(),
        ExpectedPWM = Col.RealField():cid(5):null(),
        ActualPWM = Col.RealField():cid(6):null(),
        MaxSupportedPWM = Col.IntegerField():cid(7):null():max_length(32),
        SpeedRPM = Col.IntegerField():cid(8):null():max_length(16),
        MaxSpeedRPM = Col.IntegerField():cid(9):null():max_length(32),
        Presence = Col.IntegerField():cid(10):null():max_length(8),
        Status = Col.IntegerField():cid(11):null():max_length(8),
        PowerGood = Col.IntegerField():cid(12):null():max_length(8)
    }):create_if_not_exist(datas and datas['t_pump'])
    obj.Valves = db:Table('t_valves', {
        LastPatrolTimestamp = Col.IntegerField():cid(1):persistence_key('protect_power_off'):null():max_length(32),
        PatrolState = Col.TextField():cid(2):null(),
        Id = Col.TextField():cid(3):primary_key():persistence_key('protect_power_off'):default('\'0\''),
        PatrolType = Col.IntegerField():cid(4):null():max_length(8):default(0),
        InvalidLocationId = Col.IntegerField():cid(5):null():max_length(8):default(0)
    }):create_if_not_exist(datas and datas['t_valves'])
    obj.Valve = db:Table('t_valve', {
        Id = Col.IntegerField():cid(1):primary_key():max_length(8),
        Slot = Col.IntegerField():cid(2):null():max_length(8),
        Presence = Col.IntegerField():cid(3):null():max_length(8),
        OpeningDegree = Col.IntegerField():cid(4):null():max_length(32),
        StandardOpeningDegree = Col.IntegerField():cid(5):null():max_length(32),
        Status = Col.IntegerField():cid(6):null():max_length(16),
        OpeningDegreeState = Col.IntegerField():cid(7):persistence_key('protect_reset'):null():max_length(8),
        PatrolResult = Col.IntegerField():cid(8):persistence_key('protect_reset'):null():max_length(8)
    }):create_if_not_exist(datas and datas['t_valve'])
    obj.BasicCoolingConfig = db:Table('t_basic_cooling_config', {
        FanGroupSpeedDiffThresholdPercent = Col.IntegerField():cid(1):null():max_length(16):default(32767),
        PsuFanSpeedCalibration = Col.IntegerField():cid(2):null():max_length(16):default(32767),
        Id = Col.IntegerField():cid(3):primary_key():max_length(8):default(1)
    }):create_if_not_exist(datas and datas['t_basic_cooling_config'])
    obj.FanGroup = db:Table('t_fan_group', {
        Id = Col.IntegerField():cid(1):primary_key():max_length(8),
        FanSlots = Col.JsonField():cid(2):null(),
        SpeedPercent = Col.RealField():cid(3):null(),
        ExpectedSpeedPercent = Col.RealField():cid(4):persistence_key('protect_reset'):null(),
        ResetSpeedPercent = Col.IntegerField():cid(5):null():max_length(8):default(100)
    }):create_if_not_exist(datas and datas['t_fan_group'])
    obj.FanGroupPolicy = db:Table('t_fan_group_policy', {
        Id = Col.IntegerField():cid(1):primary_key():max_length(8),
        PolicyType = Col.IntegerField():cid(2):null():max_length(8):default(0),
        FanGroupIds = Col.JsonField():cid(3):null(),
        RelativeGroupIds = Col.JsonField():cid(4):null(),
        SpeedPercentDifference = Col.IntegerField():cid(5):null():max_length(16):default(32767)
    }):create_if_not_exist(datas and datas['t_fan_group_policy'])
    obj.PumpGroup = db:Table('t_pump_group', {
        Id = Col.IntegerField():cid(1):primary_key():max_length(8),
        PumpSlots = Col.JsonField():cid(2):null(),
        SpeedPercent = Col.RealField():cid(3):null(),
        ExpectedSpeedPercent = Col.RealField():cid(4):persistence_key('protect_reset'):null()
    }):create_if_not_exist(datas and datas['t_pump_group'])
    obj.CoolingConfig = db:Table('t_cooling_config', {
        SmartCoolingState = Col.TextField():cid(1):persistence_key('protect_power_off'):null():default('\'Enabled\''),
        SmartCoolingMode = Col.TextField():cid(2):persistence_key('protect_power_off'):null()
            :default('\'EnergySaving\''),
        Medium = Col.TextField():cid(3):persistence_key('protect_power_off'):null():default('\'Air\''),
        CtrlMode = Col.TextField():cid(4):null():default('\'Auto\''),
        TimeOut = Col.IntegerField():cid(5):null():max_length(32):default(30),
        ManualLevel = Col.IntegerField():cid(6):null():max_length(8):default(10),
        LevelPercentRange = Col.JsonField():cid(7):null(),
        SensorLocationSupported = Col.BooleandField():cid(8):null():default(false),
        MinAllowedFanSpeedPercent = Col.IntegerField():cid(9):persistence_key('protect_power_off'):null():max_length(8)
            :default(255),
        MinAllowedFanSpeedEnabled = Col.BooleandField():cid(10):persistence_key('protect_power_off'):null():default(
            false),
        MixedModeSupported = Col.BooleandField():cid(11):null():default(false),
        DiskRowTemperatureAvailable = Col.BooleandField():cid(12):null():default(false),
        SysHDDsMaxTemperature = Col.RealField():cid(13):null():default(32768),
        SysSSDsMaxTemperature = Col.RealField():cid(14):null():default(32768),
        SysM2sMaxTemperature = Col.RealField():cid(15):null():default(32768),
        SysAllSSDsMaxTemperature = Col.RealField():cid(16):null():default(32768),
        FrontNVMeSSDMaxTemperatureCelsius = Col.RealField():cid(17):null():default(32768),
        FrontHddMaxTemperatureCelsius = Col.RealField():cid(18):null():default(32768),
        RearNVMeSSDMaxTemperatureCelsius = Col.RealField():cid(19):null():default(32768),
        RearHddMaxTemperatureCelsius = Col.RealField():cid(20):null():default(32768),
        Id = Col.IntegerField():cid(21):primary_key():persistence_key('protect_power_off'):max_length(8),
        MinimalLevel = Col.IntegerField():cid(22):null():max_length(8):default(0),
        MaxLimitLevel = Col.IntegerField():cid(23):null():max_length(8):default(100),
        FanLevel = Col.IntegerField():cid(24):null():max_length(8):default(20),
        FanCtrlEnable = Col.TextField():cid(25):null():default('\'Enabled\''),
        CoolingWay = Col.TextField():cid(26):null():default('\'Proactive\''),
        FanBoardNum = Col.IntegerField():cid(27):null():max_length(8):default(1),
        OriginalSmartCoolingMode = Col.TextField():cid(28):persistence_key('protect_power_off'):null():default('\'\''),
        InitLevelInStartup = Col.IntegerField():cid(29):persistence_key('protect_power_off'):max_length(8):default(100)
    }):create_if_not_exist(datas and datas['t_cooling_config'])
    obj.AirCoolingConfig = db:Table('t_cooling_fans_config', {
        CtrlMode = Col.TextField():cid(1):null():default('\'Auto\''),
        CtrlModePersistType = Col.IntegerField():cid(2):persistence_key('protect_permanent'):null():max_length(8)
            :default(0),
        CtrlModeResetPersist = Col.TextField():cid(3):persistence_key('protect_reset'):null():default('\'Auto\''),
        CtrlModePoweroffPersist = Col.TextField():cid(4):persistence_key('protect_power_off'):null():default('\'Auto\''),
        TimeOut = Col.IntegerField():cid(5):null():max_length(32):default(30),
        ManualSpeedPercent = Col.IntegerField():cid(6):null():max_length(8):default(10),
        ManualSpeedPercentResetPersist = Col.IntegerField():cid(7):persistence_key('protect_reset'):null():max_length(8)
            :default(0),
        ManualSpeedPercentPoweroffPersist = Col.IntegerField():cid(8):persistence_key('protect_power_off'):null()
            :max_length(8):default(0),
        SpeedPercentRange = Col.JsonField():cid(9):null(),
        MinAllowedSpeedPercent = Col.IntegerField():cid(10):persistence_key('protect_power_off'):null():max_length(8)
            :default(255),
        InitialSpeedPercent = Col.IntegerField():cid(11):persistence_key('protect_power_off'):null():max_length(8)
            :default(100),
        ActiveAlgorithm = Col.TextField():cid(12):null():default('\'N/A\''),
        Id = Col.IntegerField():cid(13):primary_key():persistence_key('protect_power_off'):max_length(8)
    }):create_if_not_exist(datas and datas['t_cooling_fans_config'])
    obj.CoolingFan = db:Table('t_cooling_fan', {
        FanId = Col.IntegerField():cid(1):primary_key():max_length(8),
        HardwarePWM = Col.RealField():cid(2):null(),
        FrontPresence = Col.IntegerField():cid(3):null():max_length(8):default(1),
        RearPresence = Col.IntegerField():cid(4):null():max_length(8):default(1),
        FrontStatus = Col.IntegerField():cid(5):null():max_length(8):default(0),
        RearStatus = Col.IntegerField():cid(6):null():max_length(8):default(0),
        FrontSpeed = Col.IntegerField():cid(7):null():max_length(16),
        RearSpeed = Col.IntegerField():cid(8):null():max_length(16),
        Level = Col.IntegerField():cid(9):null():max_length(8),
        ManualSpeedPercentResetPersist = Col.IntegerField():cid(10):persistence_key('protect_reset'):null()
            :max_length(8):default(0),
        ManualSpeedPercentPoweroffPersist = Col.IntegerField():cid(11):persistence_key('protect_power_off'):null()
            :max_length(8):default(0),
        Slot = Col.IntegerField():cid(12):null():max_length(8),
        MaxSupportedPWM = Col.IntegerField():cid(13):null():max_length(32)
    }):create_if_not_exist(datas and datas['t_cooling_fan'])
    obj.CoolingRequirement = db:Table('t_cooling_requirement', {
        RequirementId = Col.IntegerField():cid(1):primary_key():persistence_key('protect_power_off'):max_length(64),
        TemperatureType = Col.IntegerField():cid(2):null():max_length(32):default(4294967295),
        ActiveInStandby = Col.BooleandField():cid(3):null():default(false),
        TargetTemperatureCelsius = Col.IntegerField():cid(4):persistence_key('protect_power_off'):null():max_length(8)
            :default(127),
        MaxAllowedTemperatureCelsius = Col.IntegerField():cid(5):persistence_key('protect_power_off'):null():max_length(
            8),
        CustomSupported = Col.BooleandField():cid(6):null(),
        CustomTargetTemperatureCelsius = Col.IntegerField():cid(7):persistence_key('protect_power_off'):null()
            :max_length(8):default(255),
        TargetTemperatureRangeCelsius = Col.JsonField():cid(8):null(),
        MonitoringStatus = Col.IntegerField():cid(9):null():max_length(8),
        MonitoringValue = Col.RealField():cid(10):null(),
        FailedValue = Col.IntegerField():cid(11):persistence_key('protect_power_off'):null():max_length(64),
        ThresholdValue = Col.JsonField():cid(12):null(),
        AlarmSpeed = Col.JsonField():cid(13):null(),
        SmartCoolingTargetTemperatureCelsius = Col.JsonField():cid(14):persistence_key('protect_power_off'):null(),
        SensorName = Col.TextField():cid(15):null(),
        BaseId = Col.IntegerField():cid(16):null():max_length(8),
        Slot = Col.IntegerField():cid(17):null():max_length(8),
        Enabled = Col.BooleandField():cid(18):null():default(true),
        IsValid = Col.IntegerField():cid(19):null():max_length(8):default(1),
        BackupRequirementIdx = Col.IntegerField():cid(20):null():max_length(64),
        IsBackupRequirement = Col.BooleandField():cid(21):null():default(false),
        ObtainTempFaildToValid = Col.BooleandField():cid(22):null(),
        CoolingMedium = Col.TextField():cid(23):null():default('\'Air\''),
        LiquidFailedValue = Col.IntegerField():cid(24):null():max_length(64),
        OriginTargetTemperatureCelsius = Col.IntegerField():cid(25):null():max_length(8),
        OriginFailedValue = Col.IntegerField():cid(26):null():max_length(64),
        OriginMaxAllowedTemperatureCelsius = Col.IntegerField():cid(27):null():max_length(8),
        OriginSmartCoolingTargetTemperature = Col.JsonField():cid(28):null(),
        SmartCoolingTargetTemperature = Col.JsonField():cid(29):persistence_key('protect_power_off'):null()
    }):create_if_not_exist(datas and datas['t_cooling_requirement'])
    obj.CoolingPolicy = db:Table('t_cooling_policy', {
        PolicyIdx = Col.IntegerField():cid(1):primary_key():persistence_key('protect_power_off'):max_length(8),
        PolicyType = Col.IntegerField():cid(2):null():max_length(32):default(4294967295),
        IsValid = Col.IntegerField():cid(3):null():max_length(8):default(1),
        ExpCondVal = Col.TextField():cid(4):null(),
        ActualCondVal = Col.TextField():cid(5):null(),
        CustomSupported = Col.BooleandField():cid(6):null(),
        FanSpeedRangePercents = Col.JsonField():cid(7):null(),
        Hysteresis = Col.IntegerField():cid(8):persistence_key('protect_power_off'):null():max_length(8):default(0),
        TemperatureRangeLow = Col.JsonField():cid(9):persistence_key('protect_power_off'):null(),
        TemperatureRangeHigh = Col.JsonField():cid(10):persistence_key('protect_power_off'):null(),
        SpeedRangeLow = Col.JsonField():cid(11):persistence_key('protect_power_off'):null(),
        SpeedRangeHigh = Col.JsonField():cid(12):persistence_key('protect_power_off'):null(),
        TemperatureArray = Col.TextField():cid(13):persistence_key('protect_power_off'):null(),
        FanSpeedArray = Col.TextField():cid(14):persistence_key('protect_power_off'):null(),
        FanType = Col.JsonField():cid(15):null(),
        DiskTempUnavailableToValid = Col.BooleandField():cid(16):null(),
        HDDBackPlaneName = Col.JsonField():cid(17):null(),
        HDDRearBackPlaneName = Col.JsonField():cid(18):null(),
        HDDBackPlaneType = Col.TextField():cid(19):null(),
        PCIeCardName = Col.JsonField():cid(20):null(),
        CoolingMedium = Col.TextField():cid(21):null():default('\'Air\''),
        OriginTemperatureRangeLow = Col.JsonField():cid(22):null(),
        OriginTemperatureRangeHigh = Col.JsonField():cid(23):null(),
        OriginSpeedRangeLow = Col.JsonField():cid(24):null(),
        OriginSpeedRangeHigh = Col.JsonField():cid(25):null()
    }):create_if_not_exist(datas and datas['t_cooling_policy'])
    obj.ThermalSubsystem = db:Table('t_thermal_subsystem', {
        TotalPowerWatts = Col.IntegerField():cid(1):null():max_length(32),
        EnergyConsumptionkWh = Col.RealField():cid(2):persistence_key('protect_power_off'):null(),
        ResetTime = Col.IntegerField():cid(3):persistence_key('protect_power_off'):null():max_length(32),
        Id = Col.IntegerField():cid(4):primary_key():persistence_key('protect_power_off'):max_length(8)
    }):create_if_not_exist(datas and datas['t_thermal_subsystem'])

    obj.tables = db.tables
    return setmetatable(obj, Thermal_mgmtDBDatabase)
end

function Thermal_mgmtDBDatabase:select(table, ...)
    return self.db:select(table, ...)
end

function Thermal_mgmtDBDatabase:update(table, ...)
    return self.db:update(table, ...)
end

function Thermal_mgmtDBDatabase:insert(table, ...)
    return self.db:insert(table, ...)
end

function Thermal_mgmtDBDatabase:delete(table, ...)
    return self.db:delete(table, ...)
end

function Thermal_mgmtDBDatabase:exec(...)
    return self.db:exec(...)
end

return Thermal_mgmtDBDatabase.new
