-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPump = {}

---@class MPump.PowerGood
---@field PowerGood integer
local TPowerGood = {}
TPowerGood.__index = TPowerGood
TPowerGood.group = {}

local function TPowerGood_from_obj(obj)
    return setmetatable(obj, TPowerGood)
end

function TPowerGood.new(PowerGood)
    return TPowerGood_from_obj({PowerGood = PowerGood})
end
---@param obj MPump.PowerGood
function TPowerGood:init_from_obj(obj)
    self.PowerGood = obj.PowerGood
end

function TPowerGood:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerGood.group)
end

TPowerGood.from_obj = TPowerGood_from_obj

TPowerGood.proto_property = {'PowerGood'}

TPowerGood.default = {0}

TPowerGood.struct = {{name = 'PowerGood', is_array = false, struct = nil}}

function TPowerGood:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerGood', self.PowerGood, 'uint8', false, errs, need_convert)

    TPowerGood:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerGood.proto_property, errs, need_convert)
    return self
end

function TPowerGood:unpack(_)
    return self.PowerGood
end

MPump.PowerGood = TPowerGood

return MPump
