-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MFans = {}

---@class MFans.WorkInStandby
---@field WorkInStandby integer
local TWorkInStandby = {}
TWorkInStandby.__index = TWorkInStandby
TWorkInStandby.group = {}

local function TWorkInStandby_from_obj(obj)
    return setmetatable(obj, TWorkInStandby)
end

function TWorkInStandby.new(WorkInStandby)
    return TWorkInStandby_from_obj({WorkInStandby = WorkInStandby or 0})
end
---@param obj MFans.WorkInStandby
function TWorkInStandby:init_from_obj(obj)
    self.WorkInStandby = obj.WorkInStandby or 0
end

function TWorkInStandby:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWorkInStandby.group)
end

TWorkInStandby.from_obj = TWorkInStandby_from_obj

TWorkInStandby.proto_property = {'WorkInStandby'}

TWorkInStandby.default = {0}

TWorkInStandby.struct = {{name = 'WorkInStandby', is_array = false, struct = nil}}

function TWorkInStandby:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WorkInStandby', self.WorkInStandby, 'uint8', false, errs, need_convert)

    TWorkInStandby:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWorkInStandby.proto_property, errs, need_convert)
    return self
end

function TWorkInStandby:unpack(_)
    return self.WorkInStandby
end

MFans.WorkInStandby = TWorkInStandby

---@class MFans.SetPWMCmd
---@field SetPWMCmd integer
local TSetPWMCmd = {}
TSetPWMCmd.__index = TSetPWMCmd
TSetPWMCmd.group = {}

local function TSetPWMCmd_from_obj(obj)
    return setmetatable(obj, TSetPWMCmd)
end

function TSetPWMCmd.new(SetPWMCmd)
    return TSetPWMCmd_from_obj({SetPWMCmd = SetPWMCmd})
end
---@param obj MFans.SetPWMCmd
function TSetPWMCmd:init_from_obj(obj)
    self.SetPWMCmd = obj.SetPWMCmd
end

function TSetPWMCmd:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPWMCmd.group)
end

TSetPWMCmd.from_obj = TSetPWMCmd_from_obj

TSetPWMCmd.proto_property = {'SetPWMCmd'}

TSetPWMCmd.default = {0}

TSetPWMCmd.struct = {{name = 'SetPWMCmd', is_array = false, struct = nil}}

function TSetPWMCmd:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SetPWMCmd', self.SetPWMCmd, 'uint32', false, errs, need_convert)

    TSetPWMCmd:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPWMCmd.proto_property, errs, need_convert)
    return self
end

function TSetPWMCmd:unpack(_)
    return self.SetPWMCmd
end

MFans.SetPWMCmd = TSetPWMCmd

---@class MFans.PWMChip
---@field PWMChip integer[]
local TPWMChip = {}
TPWMChip.__index = TPWMChip
TPWMChip.group = {}

local function TPWMChip_from_obj(obj)
    return setmetatable(obj, TPWMChip)
end

function TPWMChip.new(PWMChip)
    return TPWMChip_from_obj({PWMChip = PWMChip})
end
---@param obj MFans.PWMChip
function TPWMChip:init_from_obj(obj)
    self.PWMChip = obj.PWMChip
end

function TPWMChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPWMChip.group)
end

TPWMChip.from_obj = TPWMChip_from_obj

TPWMChip.proto_property = {'PWMChip'}

TPWMChip.default = {{}}

TPWMChip.struct = {{name = 'PWMChip', is_array = true, struct = nil}}

function TPWMChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PWMChip', self.PWMChip, 'uint8', false, errs, need_convert)

    TPWMChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPWMChip.proto_property, errs, need_convert)
    return self
end

function TPWMChip:unpack(_)
    return self.PWMChip
end

MFans.PWMChip = TPWMChip

---@class MFans.FansObjectName
---@field FansObjectName string
local TFansObjectName = {}
TFansObjectName.__index = TFansObjectName
TFansObjectName.group = {}

local function TFansObjectName_from_obj(obj)
    return setmetatable(obj, TFansObjectName)
end

function TFansObjectName.new(FansObjectName)
    return TFansObjectName_from_obj({FansObjectName = FansObjectName})
end
---@param obj MFans.FansObjectName
function TFansObjectName:init_from_obj(obj)
    self.FansObjectName = obj.FansObjectName
end

function TFansObjectName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFansObjectName.group)
end

TFansObjectName.from_obj = TFansObjectName_from_obj

TFansObjectName.proto_property = {'FansObjectName'}

TFansObjectName.default = {''}

TFansObjectName.struct = {{name = 'FansObjectName', is_array = false, struct = nil}}

function TFansObjectName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'FansObjectName', self.FansObjectName, 'string', false, errs, need_convert)

    TFansObjectName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFansObjectName.proto_property, errs, need_convert)
    return self
end

function TFansObjectName:unpack(_)
    return self.FansObjectName
end

MFans.FansObjectName = TFansObjectName

return MFans
