
## 1、功能简介
thermal_mgmt负责散热器件管理，提供散热器件状态监测、调速、异常告警和资产信息收集与展示的功能。


## 2、关键特性
### 2.1 风扇特性
#### 2.1.1 风扇型号识别
通过对风扇槽位、转速、是否为双转子的筛选对风速型号进行唯一类别的判断。

#### 2.1.2 单双转子识别
根据单双转子在位识别，提供设置转子类型混插告警的功能。在刷新风扇转速是否稳定时，支持前、后转子最大转速区间内的稳定告警。

#### 2.1.3 风扇转速管理
支持风扇批量转速管理与单风扇转速管理。批量转速管理提供对所有风扇PWM值批量下发与查询的能力。单风扇调速支持对单个风扇的转速管理。支持查询风扇转速的功能。

#### 2.1.4 风扇状态监测
风扇状态监测包含状态异常、风扇类型混插监测的能力。

#### 2.1.5 风扇信息收集与展示
在Web风扇&散热界面与一键收集日志fan_info.txt、thermal_info.txt中可查看风扇槽位号、名称、型号、转速、速率比以及部件编码等信息。


### 2.2 液冷泵特性
#### 2.2.1 液冷泵转速管理
支持液冷泵批量转速管理，提供对所有液冷泵PWM值批量下发与查询的能力。

#### 2.2.2 液冷泵状态监测
液冷泵状态监测，包括液冷泵正常状态、异常转速、是否在位、与停转监测的能力。

#### 2.2.3 液冷泵信息收集与展示
在Web风扇&散热界面可查看LAAC泵转速、速率比与部件编码信息。


### 2.3 关断阀特性
#### 2.3.1 关断阀基础信息
支持关断阀硬件基础信息的查询，包括槽位号、在位状态、开度、标定开度、开度状态。

#### 2.3.2 关断阀开度值管理
在关断阀巡检时，会对关断阀设置目标开度值并对下发的值进行误差检验，最后将检验结果更新为开度值状态。支持查询、设置开度值。

#### 2.3.3 关断阀巡检
支持巡检信息的查询，包括关断阀巡检类型、巡检结果、巡检状态、最后一次巡检时间。提供两种巡检方式，分别是不巡检与例行巡检（仅支持月度巡检）。月度巡检会对关断阀进行批量读值，以定期监控阀的健康状况，记录日志，并上报网管。


## 3、对外接口
### 3.1 资源协作接口
#### 3.1.1 属性

1. Fan

<table>
	<tr>
	    <th>Object(path)</th>
	    <th>interface</th>
	    <th>method/property/signal</th> 
        <th>Type</th>
        <th>取值类型</th> 
        <th>备注</th> 
	</tr >
	<tr >
	    <td rowspan="32">/bmc/kepler/Systems/:SystemId/Thermal/Fans/:Id</td>
	    <td rowspan="32">bmc.kepler.Systems.Fan</td>
	    <td>FanId</td>
        <td>property</td>
        <td>U16</td>
        <td>风扇ID</td>
	</tr>
	<tr>
	    <td>Slot</td>
	    <td>property</td>
        <td>U8</td>
        <td>风扇槽位</td>
	</tr>
	<tr>
	    <td>Type</td>
	    <td>property</td>
        <td>U8</td>
        <td>风扇类型</td>
	</tr>
	<tr>
	    <td>Model</td>
	    <td>property</td>
        <td>String</td>
        <td>风扇类型</td>
	</tr>
    <tr>
	    <td>Coefficient</td>
	    <td>property</td>
        <td>U8</td>
        <td>风扇转速系数</td>
	</tr>
    <tr>
	    <td>FanHealth</td>
	    <td>property</td>
        <td>U8</td>
        <td>风扇健康</td>
	</tr>
    <tr>
	    <td>FanEntity</td>
	    <td>property</td>
        <td>String</td>
        <td>风扇实例</td>
	</tr>
    <tr>
	    <td>FrontPresence</td>
	    <td>property</td>
        <td>U8</td>
        <td>前风扇在位</td>
	</tr>
    <tr>
	    <td>RearPresence</td>
	    <td>property</td>
        <td>U8</td>
        <td>后风扇在位</td>
	</tr>
    <tr>
	    <td>FrontSpeed</td>
	    <td>property</td>
        <td>U16</td>
        <td>前风扇转速</td>
	</tr>
    <tr>
	    <td>RearSpeed</td>
	    <td>property</td>
        <td>U16</td>
        <td>后风扇转速</td>
	</tr>
    <tr>
	    <td>FrontStatus</td>
	    <td>property</td>
        <td>U8</td>
        <td>前风扇状态</td>
	</tr>
	<tr>
	    <td>RearStatus</td>
	    <td>property</td>
        <td>U8</td>
        <td>后风扇状态</td>
	</tr>
	<tr>
	    <td>FrontRPM</td>
	    <td>property</td>
        <td>U16</td>
        <td>前泵转速</td>
	</tr>
    <tr>
	    <td>RearRPM</td>
	    <td>property</td>
        <td>U16</td>
        <td>后泵转速</td>
	</tr>
    <tr>
	    <td>HardwarePWM</td>
	    <td>property</td>
        <td>Double</td>
        <td>硬件转速百分比</td>
	</tr>
    <tr>
	    <td>PWMPercentage</td>
	    <td>property</td>
        <td>U32</td>
        <td>转速百分比</td>
	</tr>
    <tr>
	    <td>ExpectedPWM</td>
	    <td>property</td>
        <td>Double</td>
        <td>预期转速百分比</td>
	</tr>
    <tr>
	    <td>FanAlarmLed</td>
	    <td>property</td>
        <td>U8</td>
        <td>风扇告警</td>
	</tr>
    <tr>
	    <td>BOM</td>
	    <td>property</td>
        <td>String</td>
        <td>BOM编码</td>
	</tr>
    <tr>
	    <td>SystemId</td>
	    <td>property</td>
        <td>U8</td>
        <td>系统Id</td>
	</tr>
    <tr>
	    <td>MaxSupportedPWM</td>
	    <td>property</td>
        <td>U32</td>
        <td>最大支持转速</td>
	</tr>
	<tr>
	    <td>IdentifySpeedLevel</td>
	    <td>property</td>
        <td>U8</td>
        <td>识别风速级别</td>
	</tr>
	<tr>
	    <td>PartNumber</td>
	    <td>property</td>
        <td>String</td>
        <td>部件号</td>
	</tr>
    <tr>
	    <td>FrontMaxSpeed</td>
	    <td>property</td>
        <td>U32</td>
        <td>前转子最大转速</td>
	</tr>
    <tr>
	    <td>RearMaxSpeed</td>
	    <td>property</td>
        <td>U32</td>
        <td>后转子最大转速</td>
	</tr>
    <tr>
	    <td>IsTwins</td>
	    <td>property</td>
        <td>Boolean</td>
        <td>是否为单双转子</td>
	</tr>
    <tr>
	    <td>Position</td>
	    <td>property</td>
        <td>String</td>
        <td>容器信息</td>
	</tr>
    <tr>
	    <td>FunctionDesc</td>
	    <td>property</td>
        <td>String</td>
        <td>功能描述</td>
	</tr>
    <tr>
	    <td>DeviceName</td>
	    <td>property</td>
        <td>String</td>
        <td>部件名称</td>
	</tr>
    <tr>
	    <td>SpeedStable</td>
	    <td>property</td>
        <td>Boolean</td>
        <td>风扇转速是否稳定（true:稳定，false:不稳定）,<br>期望转速与实际转速比相差25%以内为稳定</td>
	</tr>
</table>

2. Pump

<table>
	<tr>
	    <th>Object(path)</th>
	    <th>interface</th>
	    <th>method/property/signal</th> 
        <th>Type</th>
        <th>取值类型</th> 
        <th>备注</th> 
	</tr >
	<tr >
	    <td rowspan="11">/bmc/kepler/Systems/:SystemId/Thermal/Pumps/:Id</td>
	    <td rowspan="11">bmc.kepler.Systems.Pump</td>
	    <td>Id</td>
        <td>property</td>
        <td>U16</td>
        <td>泵Id</td>
	</tr>
	<tr>
	    <td>Slot</td>
	    <td>property</td>
        <td>U8</td>
        <td>槽位</td>
	</tr>
	<tr>
	    <td>Model</td>
	    <td>property</td>
        <td>String</td>
        <td>型号</td>
	</tr>
	<tr>
	    <td>ExpectedPWM</td>
	    <td>property</td>
        <td>Double</td>
        <td>预期的PWM值</td>
	</tr>
    <tr>
	    <td>ActualPWM</td>
	    <td>property</td>
        <td>Double</td>
        <td>实际PWM值</td>
	</tr>
    <tr>
	    <td>MaxSupportedPWM</td>
	    <td>property</td>
        <td>U32</td>
        <td>泵全速额定PWM值</td>
	</tr>
    <tr>
	    <td>SpeedRPM</td>
	    <td>property</td>
        <td>U16</td>
        <td>泵转速(转/分钟）</td>
	</tr>
    <tr>
	    <td>Presence</td>
	    <td>property</td>
        <td>U8</td>
        <td>在位信息：1在位，0不在位</td>
	</tr>
    <tr>
	    <td>Status</td>
	    <td>property</td>
        <td>U8</td>
        <td>泵状态</td>
	</tr>
    <tr>
	    <td>MaxSpeedRPM</td>
	    <td>property</td>
        <td>U32</td>
        <td>泵全速额定转速(转/分钟）</td>
	</tr>
    <tr>
	    <td>PartNumber</td>
	    <td>property</td>
        <td>String</td>
        <td>部件号</td>
	</tr>
</table>

3. Fans

<table>
	<tr>
	    <th>Object(path)</th>
	    <th>interface</th>
	    <th>method/property/signal</th> 
        <th>Type</th>
        <th>取值类型</th> 
        <th>备注</th> 
	</tr >
	<tr >
	    <td rowspan="2">/bmc/kepler/Systems/:SystemId/Thermal/Fans</td>
	    <td rowspan="2">bmc.kepler.Systems.Fans</td>
	    <td>SetPWM</td>
        <td>method</td>
        <td>Double[]</td>
        <td>设置所有风扇转速</td>
    </tr>
    <tr>
	    <td>WorkInStandby</td>
	    <td>property</td>
        <td>U8</td>
        <td>standby下风扇是否可以运转</td>
	</tr>
</table>

4. Pumps

<table>
	<tr>
	    <th>Object(path)</th>
	    <th>interface</th>
	    <th>method/property/signal</th> 
        <th>Type</th>
        <th>取值类型</th> 
        <th>备注</th> 
	</tr >
	<tr >
	    <td rowspan="2">/bmc/kepler/Systems/:SystemId/Thermal/Pumps</td>
	    <td rowspan="2">bmc.kepler.Systems.Pumps</td>
        <td>WorkInStandby</td>
	    <td>property</td>
        <td>U8</td>
        <td>standby下是否可以运转</td>
	</tr>
    <tr>
        <td>SetPWM</td>
        <td>method</td>
        <td>Double[]</td>
        <td>设置所有泵转速</td>
	</tr>
</table>

5. Valves

<table>
	<tr>
	    <th>Object(path)</th>
	    <th>interface</th>
	    <th>method/property/signal</th> 
        <th>Type</th>
        <th>取值类型</th> 
        <th>备注</th> 
	</tr >
	<tr >
	    <td rowspan="3">/bmc/kepler/Chassis/:ChassisId/Thermal/Valves</td>
	    <td rowspan="3">bmc.kepler.Chassis.Valves</td>
	    <td>StartPatrol</td>
        <td>method</td>
        <td>U32</td>
        <td>启动关断阀巡检</td>
	</tr>
    <tr>
	    <td>PatrolState</td>
	    <td>property</td>
        <td>String</td>
        <td>巡检状态</td>
	</tr>
    <tr>
	    <td>LastPatrolTimestamp</td>
	    <td>property</td>
        <td>U32</td>
        <td>最近一次巡检时间</td>
	</tr>
</table>

6. Valve

<table>
	<tr>
	    <th>Object(path)</th>
	    <th>interface</th>
	    <th>method/property/signal</th> 
        <th>Type</th>
        <th>取值类型</th> 
        <th>备注</th> 
	</tr >
	<tr >
	    <td rowspan="8">/bmc/kepler/Chassis/:ChassisId/Thermal/Valves/:Id</td>
	    <td rowspan="8">bmc.kepler.Chassis.Valve</td>
	    <td>Id</td>
        <td>property</td>
        <td>U8</td>
        <td>关断阀Id</td>
	</tr>
    <tr>
	    <td>Slot</td>
	    <td>property</td>
        <td>U8</td>
        <td>关断阀槽位</td>
	</tr>
    <tr>
	    <td>Presence</td>
	    <td>property</td>
        <td>U8</td>
        <td>关断阀在位。1在位，0不在位</td>
	</tr>
    <tr>
	    <td>Status</td>
	    <td>property</td>
        <td>U16</td>
        <td>关断阀故障状态: 0-正常, 非0-关断阀故障</td>
	</tr>
    <tr>
	    <td>OpeningDegreeState</td>
	    <td>property</td>
        <td>U8</td>
        <td>关断阀开度状态:0-正常, 1-异常</td>
	</tr>
    <tr>
	    <td>PatrolResult</td>
	    <td>property</td>
        <td>U8</td>
        <td>关断阀巡检结果: 0-成功, 1-失败</td>
	</tr>
    <tr>
	    <td>OpeningDegree</td>
	    <td>property</td>
        <td>U32</td>
        <td>关断阀开度</td>
	</tr>
    <tr>
	    <td>StandardOpeningDegree</td>
	    <td>property</td>
        <td>U32</td>
        <td>关断阀标称开度</td>
	</tr>
</table>

#### 3.1.2 方法
#### `/bmc/kepler/Systems/{SystemId}/Thermal/Fans` - `SetPWM`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/Thermal/Fans`|`bmc.kepler.Systems.Fans`|`SetPWM`|`a{ss}ad`|`y`|输入参数：<br>PWM：给所有风扇下发的转速百分比数组<br>输出参数：<br>Result：返回结果，0：设置成功；1：设置失败|设置所有风扇的转速|PWM数组长度需与风扇数量相同，且按风扇ID从小到大一一对应|不涉及|在风扇型号识别过程中或识别失败时不允许设置|PWM数组长度需与风扇数量相同|PWM为双精度浮点数数组，Result为0或1|风扇ID在相同SystemId下唯一|不涉及|

---

#### `/bmc/kepler/Systems/{SystemId}/Thermal/Pumps` - `SetPWM`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/Thermal/Pumps`|`bmc.kepler.Systems.Pumps`|`SetPWM`|`a{ss}ad`|`y`|输入参数：<br>PWM：给所有泵下发的转速百分比数组<br>输出参数：<br>Result：返回结果，0：设置成功；1：设置失败|设置所有泵的转速|PWM数组长度需与泵数量相同，且按泵ID从小到大一一对应|不涉及|在泵型号识别过程中或识别失败时不允许设置|PWM数组长度需与泵数量相同|PWM为双精度浮点数数组，Result为0或1|泵ID在相同SystemId下唯一|不涉及|

---

#### `/bmc/kepler/Chassis/{ChassisId}/Thermal/Valves` - `StartPatrol`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Chassis/{ChassisId}/Thermal/Valves`|`bmc.kepler.Chassis.Valves`|`StartPatrol`|`u`|`y`|输入参数：<br>DelaySeconds为巡检开始等待时间|启动关断阀巡检|关断阀关闭时不巡检|DelaySeconds：秒|关断阀关闭时不巡检|1.环境有Valve对象<br>2.依赖关断阀开启/关闭状态|十进制整数|不涉及|不涉及|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingConfig` - `SetCtrlMode`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingConfig`|`bmc.kepler.Systems.CoolingConfig`|`SetCtrlMode`|`a{ss}su`|`-`|输入参数：<br>CtrlMode：冷却单元控制模式<br>Timeout：超时时长|设置冷却单元控制模式|CtrlMode取值范围：<br>"Auto"：自动模式<br>"Manual"：手动模式<br>"Mixed"：混合模式|CtrlMode：不涉及<br>Timeout：秒|只能为所有设备设置控制模式，不能为单个冷却设备设置控制模式|支持混合模式的机型才可以设置混合模式|CtrlMode：字符串<br>Timeout：十进制整数|冷却设备ID在相同SystemId下唯一|不涉及|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingConfig` - `SetManualLevel`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingConfig`|`bmc.kepler.Systems.CoolingConfig`|`SetManualLevel`|`a{ss}yy`|`-`|输入参数：<br>UnitId：冷却单元Id<br>Level：设置的转速级别|设置手动模式冷却级别|不涉及|不涉及|自动模式下不能设置转速级别|冷却单元当前的控制模式为手动|十进制整数|冷却设备ID在相同SystemId下唯一|不涉及|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingConfig` - `SetMedium`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingConfig`|`bmc.kepler.Systems.CoolingConfig`|`SetMedium`|`a{ss}s`|`-`|输入参数：<br>Medium：散热介质|设置散热介质类型|Medium取值范围：<br>"Air"：风冷<br>"Liquid"：液冷|不涉及|不涉及|支持风冷的机型才可以设置风冷，支持液冷的机型才可以设置液冷|"Air"或"Liquid"|不涉及|不涉及|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingConfig` - `SetSmartCoolingMode`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingConfig`|`bmc.kepler.Systems.CoolingConfig`|`SetSmartCoolingMode`|`a{ss}s`|`-`|输入参数：<br>Mode：智能调速模式|设置智能调速模式|Mode取值范围：<br>Custom：自定义<br>HighPerformance：高性能<br>LowNoise：低噪<br>EnergySaving：节能<br>LiquidCooling：液冷|不涉及|只能批量设置散热器件的散热模式|设置液冷模式环境需支持液冷模式|Mode取值范围：<br>Custom：自定义<br>HighPerformance：高性能<br>LowNoise：低噪<br>EnergySaving：节能<br>LiquidCooling：液冷|不涉及|不涉及|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingConfig` - `GetAbnormalPolicyEffectiveStatus`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingConfig`|`bmc.kepler.Systems.CoolingConfig`|`GetAbnormalPolicyEffectiveStatus`|`a{ss}s`|`b`|<br>输入参数：<br>PolicyType：异常调速类型<br>输出参数：<br>EffectiveStatus：异常调速策略生效状态(Fan, Pump, Temperature, All)<br>true:触发异常调速<br>false:未触发异常调速|获取异常调速策略生效状态|PolicyType取值范围：Fan/Pump/Temperature/All|不涉及|没有触发异常调速时，该方法返回值为false|`-`|PolicyType：Fan/Pump/Temperature/All；<br>EffectiveStatus：true/false|风扇、泵的ID在相同SystemId下唯一，温度点ID全局唯一|PSR兼容BMC版本|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingConfig` - `SetMinPWM`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingConfig`|`bmc.kepler.Systems.CoolingConfig`|`SetMinPWM`|`a{ss}sayay`|`-`|输入参数：<br>DeviceType：散热设备类型（Fan/Pump）<br>DeviceIds：散热设备ID数组<br>DeviceSpeeds：散热设备转速数组|设置转速下限值|1.DeviceIds和DeviceSpeeds数组长度相同，且DeviceIds中的ID存在；<br>2.DeviceSpeeds中的值在LevelPercentRange的范围内|设置转速下限值|不涉及|DeviceSpeeds中的值要在LevelPercentRange的范围内|DeviceType：Fan/Pump<br>DeviceIds、DeviceSpeeds：十进制整数数组|风扇、泵的ID在相同SystemId下唯一|不涉及|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingConfig` - `GetComponentThermalZone`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingConfig`|`bmc.kepler.Systems.CoolingConfig`|`GetComponentThermalZone`|`a{ss}s`|`a(yayay)`||获取指定温度点器件类型与散热器件对应关系|输入参数：<br>DeviceType：温度器件类型<br>输出参数：<br>ComponentThermalZone：指定温度器件对应散热器件数组<br>[Slot：器件槽位号<br>FanIds：器件对应风扇ID<br>PumpIds：器件对应泵ID]|不涉及|不涉及|不涉及|DeviceType：字符串<br>ComponentThermalZone：十进制整数<br>FanIds、PumpIds：十进制整数数组|温度器件、风扇、泵的ID在相同SystemId下唯一|不涉及|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingConfig` - `GetCustomTargetTemperatures`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingConfig`|`bmc.kepler.Systems.CoolingConfig`|`GetCustomTargetTemperatures`|`a{ss}`|`a(uyyy)`|<br>输出参数：<br>CustomTargetTemperatures：自定义目标温度点数组：<br>[TemperatureType：温度点类型 <br>TargetTemperatureCelsius：目标调速温度值<br>MinTargetTemperatureCelsius：目标温度调速温度值的最小值<br>MaxTargetTemperatureCelsius：目标温度调速温度值的最大值]|获取自定义目标温度点|TemperatureType：温度点类型 1:Cpu 2:Outlet 3:Disk 4:Memory 5:PCH 6:VRD 7:VDDQ 8:NPUHbm 9:NPUAiCore 10:NPUBoard|不涉及|温度点ID唯一|温度点不支持自定义（CustomSupported为false）时，不返回|十进制整数数组|温度点ID唯一|兼容BMC版本|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingConfig` - `SetMinAllowedFanSpeedEnabled`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingConfig`|`bmc.kepler.Systems.CoolingConfig`|`SetMinAllowedFanSpeedEnabled`|`a{ss}b`|`-`|输入参数：<br>MinAllowedFanSpeedEnabled：MinAllowedFanSpeedPercent 使能状态|设置失联状态场景风扇转速级别（MinAllowedFanSpeedPercent）使能状态|不涉及|不涉及|不涉及|需要MinAllowedFanSpeedPercent属性存在|MinAllowedFanSpeedPercent：true/false|风扇ID在相同SystemId下唯一|CSR兼容BMC版本|

---

#### `/bmc/kepler/Systems/{SystemId}/AirCoolingConfig` - `SetCtrlMode`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/AirCoolingConfig`|`bmc.kepler.Systems.AirCoolingConfig`|`SetCtrlMode`|`a{ss}su`|`-`|输入参数：<br>CtrlMode：风扇控制模式<br>Timeout：超时时长|设置风扇控制模式|CtrlMode取值范围：<br>"Auto"：自动模式<br>"Manual"：手动模式<br>"Mixed"：混合模式|CtrlMode：不涉及<br>Timeout：秒|只能设置所有风扇的控制模式，不能为单个风扇设置控制模式|支持混合模式的机型才可以设置混合模式|CtrlMode：字符串<br>Timeout：十进制整数|风扇ID在相同SystemId下唯一|兼容老版本的CoolingConfig对象|

---

#### `/bmc/kepler/Systems/{SystemId}/AirCoolingConfig` - `SetCtrlModePersist`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/AirCoolingConfig`|`bmc.kepler.Systems.AirCoolingConfig`|`SetCtrlModePersist`|`a{ss}syu`|`-`|输入参数：<br>CtrlMode：风扇控制模式<br>CtrlModePersistType：当前风扇模式的持久化类型<br>Timeout：超时时长|设置可持久化的风扇控制模式，为了区分风冷和液冷|CtrlMode取值范围：<br>"Auto"：自动模式<br>"Manual"：手动模式<br>"Mixed"：混合模式|CtrlMode、CtrlModePersistType：不涉及<br>Timeout：秒|只能批量设置风扇的控制模式|支持混合模式的机型才可以设置混合模式|CtrlMode：字符串<br>CtrlModePersistType、Timeout：十进制整数|风扇ID在相同SystemId下唯一|兼容老版本的CoolingConfig对象|

---

#### `/bmc/kepler/Systems/{SystemId}/AirCoolingConfig` - `SetManualSpeedPercent`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/AirCoolingConfig`|`bmc.kepler.Systems.AirCoolingConfig`|`SetManualSpeedPercent`|`a{ss}yy`|`-`|输入参数：<br>FanId：风扇Id<br>SpeedPercent：风扇转速百分比|设置风扇手动模式转速百分比|1.SpeedPercent要在LevelPercentage的范围内<br>2.风扇控制模式为手动|不涉及|风扇手动模式未开启时不支持设置|依赖LevelPercentage取值和风扇控制模式开启|十进制整数|风扇ID在相同SystemId下唯一|兼容老版本的CoolingConfig对象|

---

#### `/bmc/kepler/Systems/{SystemId}/AirCoolingConfig` - `GetActivatedPolicyFactors`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/AirCoolingConfig`|`bmc.kepler.Systems.FanSnapshot`|`GetActivatedPolicyFactors`|`a{ss}`|`(byys)`|输出参数：<br>RetData：返回的数据<br>[ValidFlag：表示Cooling组件是否有获取到风扇信息，true表示获取成功，false表示获取失败<br>ActivatedType：策略激活类型，1表示触发异常调速，0表示无异常调速<br>PWM：风扇转速百分比<br>FactorName：当前转速生效的调速因子名称]|获取已激活的风扇转速最高的调速策略因子|不涉及|不涉及|不涉及|当前为正常调速，且环境为上电状态|ValidFlag：true/false<br>ActivatedType：0/1<br>PWM：十进制整数<br>FactorName：字符串|风扇ID在相同SystemId下唯一，温度点、调速策略ID唯一|兼容老版本的CoolingConfig对象|

---

#### `/bmc/kepler/Systems/{SystemId}/LiquidCoolingConfig` - `SetManualLevel`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/LiquidCoolingConfig`|`bmc.kepler.Systems.LiquidCoolingConfig`|`SetManualLevel`|`a{ss}yy`|`-`|输入参数：<br>UnitId：冷却单元ID<br>Level：设置的转速级别|设置手动模式冷却级别|不涉及|不涉及|自动模式下不能设置转速级别|冷却单元当前的控制模式为手动|十进制整数|冷却设备ID在相同SystemId下唯一|兼容老版本的CoolingConfig对象|

---

#### `/bmc/kepler/Systems/{SystemId}/LiquidCoolingConfig` - `SetCtrlMode`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/LiquidCoolingConfig`|`bmc.kepler.Systems.LiquidCoolingConfig`|`SetCtrlMode`|`a{ss}su`|`-`|输入参数：<br>CtrlMode：液冷单元控制模式<br>Timeout：超时时长|设置液冷单元控制模式|CtrlMode取值范围：<br>"Auto"：自动模式<br>"Manual"：手动模式<br>"Mixed"：混合模式|CtrlMode：不涉及<br>Timeout：秒|只能批量设置液冷单元的控制模式，不能设置单个的|支持混合模式的机型才可以设置混合模式|CtrlMode：字符串<br>Timeout：十进制整数|液冷设备ID在相同SystemId下唯一|兼容老版本的CoolingConfig对象|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingRequirement/{Id}` - `SetTargetTemperature`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingRequirement/{Id}`|`bmc.kepler.Systems.CoolingRequirement`|`SetTargetTemperature`|`a{ss}y`|`-`|输入参数：<br>TemperatureCelsius：目标温度值|设置目标温度值|输入参数TemperatureCelsius在TargetTemperatureRangeCelsius范围内|摄氏度|不涉及|1.可以匹配到调速区域<br>2.温度点支持自定义（CustomSupported为true）|十进制整数|调速区域、温度点ID唯一|SR兼容BMC|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingRequirement/{Id}` - `SetSmartCoolingTargetTemperature`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingRequirement/{Id}`|`bmc.kepler.Systems.CoolingRequirement`|`SetSmartCoolingTargetTemperature`|`a{ss}an`|`-`|输入参数：<br>SmartCoolingTargetTemperature：SmartCooling目标值数组|设置SmartCooling目标值数组|输入参数SmartCoolingTargetTemperature数组长度为3，每一项分别对应节能、高性能、低噪模式的目标温度，且要设置的温度不高于对应模式的原始目标温度|摄氏度|不涉及|温度点的原始SmartCoolingTargetTemperature数组长度为3|长度为3的十进制整数数组|温度点ID唯一|SR兼容BMC|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingRequirement/{Id}` - `SetBasicCoolingTargetTemperature`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingRequirement/{Id}`|`bmc.kepler.Systems.CoolingRequirement`|`SetBasicCoolingTargetTemperature`|`a{ss}y`|`-`|输入参数：<br>BasicCoolingTargetTemperature：目标温度|设置目标温度|BasicCoolingTargetTemperature不小于0，且不高于温度点原始的目标温度值|摄氏度|不涉及|不涉及|十进制整数|温度点ID唯一|SR兼容BMC|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingRequirement/{Id}` - `SetMaxAllowedTemperature`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingRequirement/{Id}`|`bmc.kepler.Systems.CoolingRequirement`|`SetMaxAllowedTemperature`|`a{ss}y`|`-`|输入参数：<br>MaxAllowedTemperature：全速阈值|设置全速阈值|输入参数MaxAllowedTemperature不小于0，且不高于温度点原始的全速阈值|摄氏度|不涉及|不涉及|十进制整数|温度点ID唯一|SR兼容BMC|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingRequirement/{Id}` - `SetFailedValue`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingRequirement/{Id}`|`bmc.kepler.Systems.CoolingRequirement`|`SetFailedValue`|`a{ss}t`|`-`|输入参数：<br>FailedValue：温度失效转速|设置温度失效转速|输入参数MaxAllowedTemperature不高于100，且不低于温度点原始的温度失效转速|不涉及|不涉及|不涉及|十进制整数|温度点ID唯一|SR兼容BMC|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingRequirement/{Id}` - `SetBackupTemperatureCelsius`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingRequirement/{Id}`|`bmc.kepler.Systems.CoolingRequirement`|`SetBackupTemperatureCelsius`|`a{ss}d`|`-`|暂未实现|设置备用温度点温度值||摄氏度||

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingRequirement/{Id}` - `SetBackupTemperatureStatus`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingRequirement/{Id}`|`bmc.kepler.Systems.CoolingRequirement`|`SetBackupTemperatureStatus`|`a{ss}y`|`-`|暂未实现|设置备用温度点状态||||

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingPolicy/{Id}` - `SetCustomCoolingPolicy`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingPolicy/{Id}`|`bmc.kepler.Systems.CoolingPolicy`|`SetCustomCoolingPolicy`|`a{ss}ayay`|`-`|输入参数：<br>TemperatureArray：温度数组<br>FanSpeedArray：风扇速度数组|设置自定义调速策略|1.TemperatureArray中温度值范围为[0,60]，数组长度为[3,63]，非升序排列；<br>2.FanSpeedArray中转速范围在SpeedPercent内，数组长度范围为[4,64]，且长度比TemperatureArray长度大1|TemperatureArray：摄氏度|不支持进风口温度设置|不涉及|TemperatureArray、FanSpeedArray：十进制整数|风扇ID在相同SystemId下唯一，温度点、调速策略、调速区域ID唯一|SR兼容BMC版本|

---

#### `/bmc/kepler/Systems/{SystemId}/CoolingPolicy/{Id}` - `SetHysteresis`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Systems/{SystemId}/CoolingPolicy/{Id}`|`bmc.kepler.Systems.CoolingPolicy`|`SetHysteresis`|`a{ss}y`|`-`|输入参数：<br>Hysteresis：迟滞量|设置迟滞量|输入参数Hysteresis范围为[0,5]|不涉及|不涉及|温度过高触发风扇满转后，当温度降到MaxAllowedTemperature减Hysteresis以下时，风扇退出满转调速状态|十进制整数|风扇ID在相同SystemId下唯一，调速策略ID唯一|SR兼容BMC版本|

---

#### `/bmc/kepler/Chassis/{ChassisId}/ThermalSubsystem/CoolingPolicies` - `GetSpecificPWM`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Chassis/{ChassisId}/ThermalSubsystem/CoolingPolicies`|`bmc.kepler.Chassis.CoolingPolicies`|`GetSpecificPWM`|`a{ss}sysn`|`y`|输入参数：<br>Medium：介质<br>PolicyType：温度曲线类型<br>SmartCoolingMode：SmartCooling模式<br>Temperature：温度值<br>输出参数：<br>ControlPWM：控制占空比|获取指定条件下环温策略控制PWM|输入参数：<br>Medium：Air/Liquid<br>PolicyType：1-Inlet,2-Disk<br>SmartCoolingMode：EnergySaving/LowNoise/HighPerformance/Custom/LiquidCooling|Temperature：摄氏度|不涉及|不涉及|输入参数：<br>Medium：Air/Liquid<br>PolicyType：1-Inlet,2-Disk<br>SmartCoolingMode：EnergySaving/LowNoise/HighPerformance/Custom/LiquidCooling<br>Temperature：十进制整数<br>输出参数：<br>ControlPWM：十进制整数|风扇ID在相同SystemId下唯一，调速策略ID唯一|SR兼容BMC版本|

---

#### `/bmc/kepler/Chassis/{ChassisId}/ThermalSubsystem` - `ResetMetrics`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/Chassis/{ChassisId}/ThermalSubsystem`|`bmc.kepler.Chassis.ThermalSubsystem.Metrics`|`ResetMetrics`|`a{ss}`|`-`|刷新重新统计的时间，散热器件累计耗电量重新统计|散热器件累计耗电量信息重新统计|不涉及|不涉及|不涉及|刷新ResetTime和EnergyConsumptionkWh|不涉及|不涉及|不涉及|

---

#### `/bmc/kepler/ThermalMgmt` - `SetFanPWM`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/ThermalMgmt`|`bmc.kepler.Chassis.ThermalSubsystem.Metrics`|`SetFanPWM`|`a{ss}yyd`|`y`|输入参数：<br>SystemId：系统Id<br>FanId：风扇Id<br>PWM：风扇转速占空比<br>输出参数：<br>Result：返回结果，0-设置成功；1-设置失败|设置风扇转速|不涉及|不涉及|风扇识别过程中或风扇识别失败时不可设置|依赖风扇是否识别成功|PWM：双精度浮点数<br>其余：十进制整数|风扇ID在相同SystemId下唯一|SR兼容BMC版本|

---

#### `/bmc/kepler/ThermalMgmt` - `GetActivatedPolicy`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|`/bmc/kepler/ThermalMgmt`|`bmc.kepler.Release.ThermalControlStrategy`|`GetActivatedPolicy`|`a{ss}sy`|`s`|输入参数：<br>Type：散热器件类型<br>Mode：查询模式，0表示生效因子，1表示生效算法<br>输出参数：<br>ActivatedPolicy：返回结果当前生效的散热策略|获取指定散热器件和模式生效的调速因子|Type需为"Fan"，否则无法获取生效的调速因子|不涉及|无法获取除风扇以外散热器件的生效的调速因子|当前为正常调速，且环境为上电状态|Mode：0/1<br>其余：字符串|散热器件ID在相同SystemId下唯一，温度点、调速策略、调速区域ID唯一|SR兼容BMC版本|

---

## 3.2 IPMI接口
| 命令路径 | 命令名称 | 功能说明 |
| --- | --- | --- |
| /bmc/kepler/IpmiCmds/30/93/GetFanSpeed | GetFanSpeed | 获取风扇转速 |
| /bmc/kepler/IpmiCmds/30/93/GetValveOpeningDegree | GetValveOpeningDegree | 获取节流阀开度 |
| /bmc/kepler/IpmiCmds/30/93/GetValveStandardOpeningDegree | GetValveStandardOpeningDegree | 获取节流阀标定开度 |
| /bmc/kepler/IpmiCmds/30/93/SetValveOpeningDegree | SetValveOpeningDegree | 设置节流阀开度 |
| /bmc/kepler/IpmiCmds/30/93/GetTotalFanPower | GetTotalFanPower | 获取风扇总功耗 |
| /bmc/kepler/IpmiCmds/30/91/SetFanCtlMode | SetFanCtlMode | 设置风扇控制模式 |
| /bmc/kepler/IpmiCmds/30/91/GetFanCtlMode | GetFanCtlMode | 获取风扇控制模式 |
| /bmc/kepler/IpmiCmds/2C/15/SetFanLevel | SetFanLevel | 设置风扇等级 |
| /bmc/kepler/IpmiCmds/2C/16/GetFanLevel | GetFanLevel | 获取风扇等级 |
| /bmc/kepler/IpmiCmds/30/92/SetCoolingMode | SetCoolingMode | 设置散热模式 |
| /bmc/kepler/IpmiCmds/30/92/GetCoolingMode | GetCoolingMode | 获取散热模式 |
| /bmc/kepler/IpmiCmds/2C/14/GetFanSpdProps | GetFanSpdProps | 获取风扇转速信息 |
| /bmc/kepler/IpmiCmds/30/93/GetInletPolicy | GetInletPolicy | 获取进风口调速策略 |
| /bmc/kepler/IpmiCmds/30/93/SetInletPolicy | SetInletPolicy | 设置进风口调速策略 |
| /bmc/kepler/IpmiCmds/30/93/SetInitCoolingUnitLevel | SetInitCoolingUnitLevel | 设置初始散热单元等级 |
| /bmc/kepler/IpmiCmds/30/93/GetInitCoolingUnitLevel | GetInitCoolingUnitLevel | 获取初始散热单元等级 |
| /bmc/kepler/IpmiCmds/30/91/SetCoolingDeviceMode | SetCoolingDeviceMode | 设置散热器件模式 |
| /bmc/kepler/IpmiCmds/30/91/GetCoolingDeviceMode | GetCoolingDeviceMode | 获取散热器件模式 |
| /bmc/kepler/IpmiCmds/30/91/SetCoolingDeviceLevel | SetCoolingDeviceLevel | 设置散热器件转速级别 |
| /bmc/kepler/IpmiCmds/30/91/GetCoolingDeviceLevel | GetCoolingDeviceLevel | 获取散热器件转速级别 |