-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local storage_app = require 'storage_app'
local file_sec = require 'utils.file'
local drive_collection = require 'drive.drive_collection'
local hook_tasks = require 'hook_orm_tasks'

TestStorageAPP = {}

function TestStorageAPP:setUp()
    self.tasks = hook_tasks:hook()
end

function TestStorageAPP:tearDown()
    hook_tasks.unhook()
end
--[[
function TestStorageAPP:test_dump_log()
    local origin_open_s = file_sec.open_s
    local origin_check_real_path_s = file_sec.check_real_path_s
    local log_storage_path = "/data/var/log/storage"
    file_sec.check_real_path_s = function(path)
        if path ~= nil and string.match(path, log_storage_path) ~= nil then
            return 1
        end
        return origin_check_real_path_s(path)
    end
    file_sec.open_s = function()
        return nil
    end
    storage_app.drive_collection = drive_collection.new()
    storage_app:dump_log()
    lu.assertEquals(origin_check_real_path_s(log_storage_path), 0)

    file_sec.open_s = origin_open_s
    file_sec.check_real_path_s = origin_check_real_path_s
end
]]

function TestStorageAPP:test_gc_collect()
    local mem_kb_before = collectgarbage('count')
    storage_app.start_gc_task(storage_app)
    self.tasks:run_task('start collect garbage')
    local mem_kb_after = collectgarbage('count')
    lu.assertIsTrue(mem_kb_after <= mem_kb_before)
end